/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1SetParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSet;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSet;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSet;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Iterable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ASN1Set
extends ASN1Primitive
implements Iterable<ASN1Encodable> {
    public final ASN1Encodable[] elements;
    public final boolean isSorted;

    public static ASN1Set getInstance(Object object) {
        if (object != null && !(object instanceof ASN1Set)) {
            ASN1Primitive aSN1Primitive;
            if (object instanceof ASN1SetParser) {
                return ASN1Set.getInstance(((ASN1SetParser)object).toASN1Primitive());
            }
            if (object instanceof byte[]) {
                try {
                    return ASN1Set.getInstance(ASN1Primitive.fromByteArray((byte[])object));
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(b.a(iOException, a.a("failed to construct set from byte[]: ")));
                }
            }
            if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1Set) {
                return (ASN1Set)aSN1Primitive;
            }
            throw new IllegalArgumentException(c.a(object, a.a("unknown object in getInstance: ")));
        }
        return (ASN1Set)object;
    }

    public static ASN1Set getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        if (bl) {
            if (((ASN1TaggedObject)aSN1Primitive).isExplicit()) {
                return ASN1Set.getInstance(((ASN1TaggedObject)aSN1Primitive).getObject());
            }
            throw new IllegalArgumentException("object implicit - explicit expected.");
        }
        ASN1TaggedObject aSN1TaggedObject = aSN1Primitive;
        ASN1Primitive aSN1Primitive2 = aSN1TaggedObject.getObject();
        if (aSN1TaggedObject.isExplicit()) {
            if (aSN1Primitive instanceof BERTaggedObject) {
                return new BERSet(aSN1Primitive2);
            }
            return new DLSet(aSN1Primitive2);
        }
        if (aSN1Primitive2 instanceof ASN1Set) {
            ASN1TaggedObject aSN1TaggedObject2 = aSN1Primitive;
            aSN1Primitive = (ASN1Set)aSN1Primitive2;
            if (aSN1TaggedObject2 instanceof BERTaggedObject) {
                return aSN1Primitive;
            }
            return (ASN1Set)((ASN1Set)aSN1Primitive).toDLObject();
        }
        if (aSN1Primitive2 instanceof ASN1Sequence) {
            ASN1Primitive aSN1Primitive3 = aSN1Primitive;
            aSN1Primitive = ((ASN1Sequence)aSN1Primitive2).toArrayInternal();
            if (aSN1Primitive3 instanceof BERTaggedObject) {
                return new BERSet(false, (ASN1Encodable[])aSN1Primitive);
            }
            return new DLSet(false, (ASN1Encodable[])aSN1Primitive);
        }
        throw new IllegalArgumentException(a.a("unknown object in getInstance: ").append(aSN1Primitive.getClass().getName()).toString());
    }

    public ASN1Set() {
        this.elements = ASN1EncodableVector.EMPTY_ELEMENTS;
        this.isSorted = true;
    }

    public ASN1Set(ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[1];
            ASN1Encodable[] aSN1EncodableArray2 = aSN1EncodableArray;
            aSN1EncodableArray[0] = aSN1Encodable;
            aSN1EncodableArray2.elements = aSN1EncodableArray2;
            aSN1EncodableArray2.isSorted = true;
            return;
        }
        throw new NullPointerException("'element' cannot be null");
    }

    public ASN1Set(ASN1EncodableVector aSN1EncodableArray, boolean bl) {
        if (aSN1EncodableArray != null) {
            if (bl && aSN1EncodableArray.size() >= 2) {
                aSN1EncodableArray = aSN1EncodableArray.copyElements();
                ASN1Set.sort(aSN1EncodableArray);
            } else {
                aSN1EncodableArray = aSN1EncodableArray.takeElements();
            }
            this.elements = aSN1EncodableArray;
            boolean bl2 = bl || aSN1EncodableArray.length < 2;
            this.isSorted = bl2;
            return;
        }
        throw new NullPointerException("'elementVector' cannot be null");
    }

    public ASN1Set(ASN1Encodable[] aSN1EncodableArray, boolean bl) {
        if (!Arrays.isNullOrContainsNull(aSN1EncodableArray)) {
            aSN1EncodableArray = ASN1EncodableVector.cloneElements(aSN1EncodableArray);
            if (bl && aSN1EncodableArray.length >= 2) {
                ASN1Set.sort(aSN1EncodableArray);
            }
            this.elements = aSN1EncodableArray;
            boolean bl2 = bl || aSN1EncodableArray.length < 2;
            this.isSorted = bl2;
            return;
        }
        throw new NullPointerException("'elements' cannot be null, or contain null");
    }

    public ASN1Set(boolean bl, ASN1Encodable[] aSN1EncodableArray) {
        this.elements = aSN1EncodableArray;
        bl = bl || aSN1EncodableArray.length < 2;
        this.isSorted = bl;
    }

    private static byte[] getDEREncoded(ASN1Encodable aSN1Encodable) {
        try {
            return aSN1Encodable.toASN1Primitive().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
    }

    private static boolean lessThanOrEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray[0] & 0xFFFFFFDF;
        int n2 = byArray2[0] & 0xFFFFFFDF;
        if (n != n2) {
            return n < n2;
        }
        n = Math.min(byArray.length, byArray2.length) - 1;
        for (n2 = 1; n2 < n; ++n2) {
            byte by = byArray[n2];
            byte by2 = byArray2[n2];
            if (by == by2) continue;
            return (by & 0xFF) < (by2 & 0xFF);
        }
        return (byArray[n] & 0xFF) <= (byArray2[n] & 0xFF);
    }

    private static void sort(ASN1Encodable[] aSN1EncodableArray) {
        int n = aSN1EncodableArray.length;
        if (n < 2) {
            return;
        }
        ASN1Encodable aSN1Encodable = aSN1EncodableArray[0];
        ASN1Encodable aSN1Encodable2 = aSN1EncodableArray[1];
        byte[] byArray = ASN1Set.getDEREncoded(aSN1Encodable);
        byte[] byArray2 = ASN1Set.getDEREncoded(aSN1Encodable2);
        if (ASN1Set.lessThanOrEqual(byArray2, byArray)) {
            ASN1Encodable aSN1Encodable3 = aSN1Encodable2;
            byte[] byArray3 = byArray2;
            byArray2 = byArray;
            byArray = byArray3;
            aSN1Encodable2 = aSN1Encodable;
            aSN1Encodable = aSN1Encodable3;
        }
        for (int k = 2; k < n; ++k) {
            ASN1Encodable aSN1Encodable4;
            ASN1Encodable aSN1Encodable5 = aSN1EncodableArray[k];
            byte[] byArray4 = ASN1Set.getDEREncoded(aSN1Encodable5);
            if (ASN1Set.lessThanOrEqual(byArray2, byArray4)) {
                aSN1EncodableArray[k - 2] = aSN1Encodable;
                ASN1Encodable aSN1Encodable6 = aSN1Encodable2;
                byte[] byArray5 = byArray2;
                byArray2 = byArray4;
                byArray = byArray5;
                aSN1Encodable2 = aSN1Encodable5;
                aSN1Encodable = aSN1Encodable6;
                continue;
            }
            if (ASN1Set.lessThanOrEqual(byArray, byArray4)) {
                aSN1EncodableArray[k - 2] = aSN1Encodable;
                byArray = byArray4;
                aSN1Encodable = aSN1Encodable5;
                continue;
            }
            int n2 = k - 1;
            while ((n2 += -1) > 0 && !ASN1Set.lessThanOrEqual(ASN1Set.getDEREncoded(aSN1Encodable4 = aSN1EncodableArray[n2 - 1]), byArray4)) {
                aSN1EncodableArray[n2] = aSN1Encodable4;
            }
            aSN1EncodableArray[n2] = aSN1Encodable5;
        }
        aSN1EncodableArray[n - 2] = aSN1Encodable;
        aSN1EncodableArray[n - 1] = aSN1Encodable2;
    }

    public Enumeration getObjects() {
        return new Enumeration(){
            private int pos = 0;

            @Override
            public boolean hasMoreElements() {
                return this.pos < ASN1Set.this.elements.length;
            }

            public Object nextElement() {
                int n = this.pos;
                ASN1Encodable[] aSN1EncodableArray = ASN1Set.this.elements;
                if (n < ASN1Set.this.elements.length) {
                    this.pos = n + 1;
                    return aSN1EncodableArray[n];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public ASN1Encodable getObjectAt(int n) {
        return this.elements[n];
    }

    public int size() {
        return this.elements.length;
    }

    public ASN1Encodable[] toArray() {
        return ASN1EncodableVector.cloneElements(this.elements);
    }

    public ASN1SetParser parser() {
        final int n = this.size();
        return new ASN1SetParser(){
            private int pos = 0;

            @Override
            public ASN1Encodable readObject() {
                int n2 = aSN1Encodable.pos;
                if (aSN1Encodable.n == n2) {
                    return null;
                }
                aSN1Encodable.pos = n2 + 1;
                ASN1Encodable aSN1Encodable = aSN1Encodable.ASN1Set.this.elements[n2];
                if (aSN1Encodable instanceof ASN1Sequence) {
                    return ((ASN1Sequence)aSN1Encodable).parser();
                }
                if (aSN1Encodable instanceof ASN1Set) {
                    return ((ASN1Set)aSN1Encodable).parser();
                }
                return aSN1Encodable;
            }

            @Override
            public ASN1Primitive getLoadedObject() {
                return ASN1Set.this;
            }

            @Override
            public ASN1Primitive toASN1Primitive() {
                return ASN1Set.this;
            }
        };
    }

    @Override
    public int hashCode() {
        int n = this.elements.length;
        int n2 = n + 1;
        while ((n += -1) >= 0) {
            n2 = this.elements[n].toASN1Primitive().hashCode() + n2;
        }
        return n2;
    }

    @Override
    public ASN1Primitive toDERObject() {
        ASN1Encodable[] aSN1EncodableArray;
        if (aSN1EncodableArray.isSorted) {
            aSN1EncodableArray = aSN1EncodableArray.elements;
        } else {
            aSN1EncodableArray = (ASN1Encodable[])aSN1EncodableArray.elements.clone();
            ASN1Set.sort(aSN1EncodableArray);
        }
        return new DERSet(true, aSN1EncodableArray);
    }

    @Override
    public ASN1Primitive toDLObject() {
        ASN1Set aSN1Set = this;
        boolean bl = aSN1Set.isSorted;
        return new DLSet(bl, aSN1Set.elements);
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Set)) {
            return false;
        }
        aSN1Primitive = (ASN1Set)aSN1Primitive;
        int n = aSN1Set.size();
        if (((ASN1Set)aSN1Primitive).size() != n) {
            return false;
        }
        ASN1Set aSN1Set = (DERSet)aSN1Set.toDERObject();
        aSN1Primitive = (DERSet)((ASN1Set)aSN1Primitive).toDERObject();
        for (int k = 0; k < n; ++k) {
            ASN1Primitive aSN1Primitive2;
            ASN1Primitive aSN1Primitive3 = aSN1Set.elements[k].toASN1Primitive();
            if (aSN1Primitive3 == (aSN1Primitive2 = ((ASN1Set)aSN1Primitive).elements[k].toASN1Primitive()) || aSN1Primitive3.asn1Equals(aSN1Primitive2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConstructed() {
        return true;
    }

    @Override
    public abstract void encode(ASN1OutputStream var1, boolean var2);

    public String toString() {
        StringBuffer stringBuffer;
        int n = this.size();
        if (n == 0) {
            return "[]";
        }
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append('[');
        int n2 = 0;
        while (true) {
            stringBuffer2.append(this.elements[n2]);
            if (++n2 >= n) {
                StringBuffer stringBuffer3 = stringBuffer2;
                stringBuffer3.append(']');
                return stringBuffer3.toString();
            }
            stringBuffer2.append(", ");
        }
    }

    @Override
    public Iterator<ASN1Encodable> iterator() {
        return new Arrays.Iterator<ASN1Encodable>(this.toArray());
    }
}

