/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1BitStringParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1StreamParser;
import java.io.IOException;
import java.io.InputStream;

class ConstructedBitStream
extends InputStream {
    private final ASN1StreamParser _parser;
    private final boolean _octetAligned;
    private boolean _first = true;
    private int _padBits = 0;
    private ASN1BitStringParser _currentParser;
    private InputStream _currentStream;

    public ConstructedBitStream(ASN1StreamParser aSN1StreamParser, boolean bl) {
        this._parser = aSN1StreamParser;
        this._octetAligned = bl;
    }

    private ASN1BitStringParser getNextParser() {
        ASN1Encodable aSN1Encodable = this._parser.readObject();
        if (aSN1Encodable == null) {
            if (this._octetAligned && this._padBits != 0) {
                throw new IOException(a.a("expected octet-aligned bitstring, but found padBits: ").append(this._padBits).toString());
            }
            return null;
        }
        if (aSN1Encodable instanceof ASN1BitStringParser) {
            if (this._padBits == 0) {
                return (ASN1BitStringParser)aSN1Encodable;
            }
            throw new IOException("only the last nested bitstring can have padding");
        }
        throw new IOException(a.a("unknown object encountered: ").append(aSN1Encodable.getClass()).toString());
    }

    public int getPadBits() {
        return this._padBits;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (this._currentStream == null) {
            ASN1BitStringParser aSN1BitStringParser;
            if (!this._first) {
                return -1;
            }
            this._currentParser = aSN1BitStringParser = this.getNextParser();
            if (aSN1BitStringParser == null) {
                return -1;
            }
            this._first = false;
            this._currentStream = aSN1BitStringParser.getBitStream();
        }
        int n3 = 0;
        while (true) {
            ASN1BitStringParser aSN1BitStringParser;
            int n4 = n + n3;
            if ((n4 = this._currentStream.read(byArray, n4, n2 - n3)) >= 0) {
                if ((n3 += n4) != n2) continue;
                return n3;
            }
            ConstructedBitStream constructedBitStream = this;
            constructedBitStream._padBits = constructedBitStream._currentParser.getPadBits();
            this._currentParser = aSN1BitStringParser = constructedBitStream.getNextParser();
            if (aSN1BitStringParser == null) {
                this._currentStream = null;
                if (n3 < 1) {
                    n3 = -1;
                }
                return n3;
            }
            this._currentStream = aSN1BitStringParser.getBitStream();
        }
    }

    @Override
    public int read() {
        ASN1BitStringParser aSN1BitStringParser;
        if (this._currentStream == null) {
            if (!this._first) {
                return -1;
            }
            this._currentParser = aSN1BitStringParser = this.getNextParser();
            if (aSN1BitStringParser == null) {
                return -1;
            }
            this._first = false;
            this._currentStream = aSN1BitStringParser.getBitStream();
        }
        int n;
        while ((n = this._currentStream.read()) < 0) {
            ConstructedBitStream constructedBitStream = this;
            constructedBitStream._padBits = constructedBitStream._currentParser.getPadBits();
            this._currentParser = aSN1BitStringParser = constructedBitStream.getNextParser();
            if (aSN1BitStringParser == null) {
                this._currentStream = null;
                return -1;
            }
            this._currentStream = aSN1BitStringParser.getBitStream();
        }
        return n;
    }
}

