/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;

public class DERPrintableString
extends ASN1Primitive
implements ASN1String {
    private final byte[] string;

    public static DERPrintableString getInstance(Object object) {
        if (object != null && !(object instanceof DERPrintableString)) {
            if (object instanceof byte[]) {
                try {
                    return (DERPrintableString)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(d.a(exception, a.a("encoding error in getInstance: ")));
                }
            }
            throw new IllegalArgumentException(c.a(object, a.a("illegal object in getInstance: ")));
        }
        return (DERPrintableString)object;
    }

    public static DERPrintableString getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        aSN1Primitive = aSN1Primitive.getObject();
        if (!bl && !(aSN1Primitive instanceof DERPrintableString)) {
            return new DERPrintableString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
        }
        return DERPrintableString.getInstance(aSN1Primitive);
    }

    public DERPrintableString(byte[] byArray) {
        this.string = byArray;
    }

    public DERPrintableString(String string) {
        this(string, false);
    }

    public DERPrintableString(String string, boolean bl) {
        if (bl && !DERPrintableString.isPrintableString(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.string = Strings.toByteArray(string);
    }

    public static boolean isPrintableString(String string) {
        for (int k = string.length() - 1; k >= 0; --k) {
            char c2 = string.charAt(k);
            if (c2 > '\u007f') {
                return false;
            }
            if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || '0' <= c2 && c2 <= '9' || c2 == ' ' || c2 == ':' || c2 == '=' || c2 == '?') continue;
            switch (c2) {
                default: {
                    switch (c2) {
                        default: {
                            return false;
                        }
                        case '+': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '/': 
                    }
                }
                case '\'': 
                case '(': 
                case ')': 
            }
        }
        return true;
    }

    @Override
    public String getString() {
        return Strings.fromByteArray(this.string);
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    @Override
    public boolean isConstructed() {
        return false;
    }

    @Override
    public int encodedLength() {
        return StreamUtil.calculateBodyLength(this.string.length) + 1 + this.string.length;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        Object object = ((DERPrintableString)object).string;
        aSN1OutputStream.writeEncoded(bl, 19, (byte[])object);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERPrintableString)) {
            return false;
        }
        DERPrintableString dERPrintableString = dERPrintableString2;
        DERPrintableString dERPrintableString2 = (DERPrintableString)aSN1Primitive;
        return Arrays.areEqual(dERPrintableString.string, dERPrintableString2.string);
    }

    public String toString() {
        return this.getString();
    }
}

