/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;

public class DLTaggedObject
extends ASN1TaggedObject {
    public DLTaggedObject(boolean bl, int n, ASN1Encodable aSN1Encodable) {
        super(bl, n, aSN1Encodable);
    }

    @Override
    public boolean isConstructed() {
        return this.explicit || this.obj.toASN1Primitive().toDLObject().isConstructed();
    }

    @Override
    public int encodedLength() {
        DLTaggedObject dLTaggedObject = this;
        int n = dLTaggedObject.obj.toASN1Primitive().toDLObject().encodedLength();
        if (dLTaggedObject.explicit) {
            return StreamUtil.calculateTagLength(this.tagNo) + StreamUtil.calculateBodyLength(n) + n;
        }
        int n2 = n - 1;
        return StreamUtil.calculateTagLength(this.tagNo) + n2;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        DLTaggedObject dLTaggedObject = this;
        ASN1Primitive aSN1Primitive = dLTaggedObject.obj.toASN1Primitive().toDLObject();
        int n = 128;
        if (dLTaggedObject.explicit || aSN1Primitive.isConstructed()) {
            n = 160;
        }
        aSN1OutputStream.writeTag(bl, n, this.tagNo);
        if (this.explicit) {
            aSN1OutputStream.writeLength(aSN1Primitive.encodedLength());
        }
        aSN1OutputStream.getDLSubStream().writePrimitive(aSN1Primitive, this.explicit);
    }

    @Override
    public ASN1Primitive toDLObject() {
        return this;
    }
}

