/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.LimitedInputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class DefiniteLengthInputStream
extends LimitedInputStream {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final int _originalLength;
    private int _remaining;

    public DefiniteLengthInputStream(InputStream inputStream, int n, int n2) {
        super(inputStream, n2);
        if (n >= 0) {
            DefiniteLengthInputStream definiteLengthInputStream = this;
            definiteLengthInputStream._originalLength = n;
            definiteLengthInputStream._remaining = n;
            if (n == 0) {
                this.setParentEofDetect(true);
            }
            return;
        }
        throw new IllegalArgumentException("negative lengths not allowed");
    }

    public int getRemaining() {
        return this._remaining;
    }

    @Override
    public int read() {
        if (this._remaining == 0) {
            return -1;
        }
        int n = this._in.read();
        if (n >= 0) {
            if (--this._remaining == 0) {
                this.setParentEofDetect(true);
            }
            return n;
        }
        throw new EOFException(a.a("DEF length ").append(this._originalLength).append(" object truncated by ").append(this._remaining).toString());
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = this._remaining;
        if (n3 == 0) {
            return -1;
        }
        int n4 = this._in.read(byArray, n, n2 = Math.min(n2, n3));
        if (n4 >= 0) {
            if ((this._remaining -= n4) == 0) {
                this.setParentEofDetect(true);
            }
            return n4;
        }
        throw new EOFException(a.a("DEF length ").append(this._originalLength).append(" object truncated by ").append(this._remaining).toString());
    }

    public void readAllIntoByteArray(byte[] byArray) {
        int n = this._remaining;
        if (n == byArray.length) {
            if (n == 0) {
                return;
            }
            DefiniteLengthInputStream definiteLengthInputStream = this;
            int n2 = definiteLengthInputStream._remaining;
            n = definiteLengthInputStream.getLimit();
            if (n2 < n) {
                this._remaining = n2 - Streams.readFully(this._in, byArray);
                if (this._remaining == 0) {
                    this.setParentEofDetect(true);
                    return;
                }
                throw new EOFException(a.a("DEF length ").append(this._originalLength).append(" object truncated by ").append(this._remaining).toString());
            }
            throw new IOException(a.a("corrupted stream - out of bounds length found: ").append(this._remaining).append(" >= ").append(n).toString());
        }
        throw new IllegalArgumentException("buffer length not right for data");
    }

    public byte[] toByteArray() {
        if (this._remaining == 0) {
            return EMPTY_BYTES;
        }
        DefiniteLengthInputStream definiteLengthInputStream = this;
        int n = definiteLengthInputStream._remaining;
        int n2 = definiteLengthInputStream.getLimit();
        if (n < n2) {
            byte[] byArray = new byte[n];
            this._remaining = n - Streams.readFully(this._in, byArray);
            if (this._remaining == 0) {
                this.setParentEofDetect(true);
                return byArray;
            }
            throw new EOFException(a.a("DEF length ").append(this._originalLength).append(" object truncated by ").append(this._remaining).toString());
        }
        throw new IOException(a.a("corrupted stream - out of bounds length found: ").append(this._remaining).append(" >= ").append(n2).toString());
    }
}

