/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERUTF8String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.BodyPartID;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.CMCFailInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.CMCStatus;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.PendInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.Utils;

public class CMCStatusInfo
extends ASN1Object {
    private final CMCStatus cMCStatus;
    private final ASN1Sequence bodyList;
    private final DERUTF8String statusString;
    private final OtherInfo otherInfo;

    public CMCStatusInfo(CMCStatus cMCStatus, ASN1Sequence aSN1Sequence, DERUTF8String dERUTF8String, OtherInfo otherInfo) {
        this.cMCStatus = cMCStatus;
        this.bodyList = aSN1Sequence;
        this.statusString = dERUTF8String;
        this.otherInfo = otherInfo;
    }

    private CMCStatusInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() >= 2 && aSN1Sequence.size() <= 4) {
            this.cMCStatus = CMCStatus.getInstance(aSN1Sequence.getObjectAt(0));
            this.bodyList = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
            if (aSN1Sequence.size() > 3) {
                this.statusString = DERUTF8String.getInstance(aSN1Sequence.getObjectAt(2));
                this.otherInfo = OtherInfo.getInstance(aSN1Sequence.getObjectAt(3));
            } else if (aSN1Sequence.size() > 2) {
                if (aSN1Sequence.getObjectAt(2) instanceof DERUTF8String) {
                    CMCStatusInfo cMCStatusInfo = this;
                    cMCStatusInfo.statusString = DERUTF8String.getInstance(aSN1Sequence.getObjectAt(2));
                    cMCStatusInfo.otherInfo = null;
                } else {
                    this.statusString = null;
                    this.otherInfo = OtherInfo.getInstance(aSN1Sequence.getObjectAt(2));
                }
            } else {
                CMCStatusInfo cMCStatusInfo = this;
                cMCStatusInfo.statusString = null;
                cMCStatusInfo.otherInfo = null;
            }
            return;
        }
        throw new IllegalArgumentException("incorrect sequence size");
    }

    public static CMCStatusInfo getInstance(Object object) {
        if (object instanceof CMCStatusInfo) {
            return (CMCStatusInfo)object;
        }
        if (object != null) {
            return new CMCStatusInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        OtherInfo otherInfo;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(4);
        aSN1EncodableVector2.add(this.cMCStatus);
        aSN1EncodableVector.add(this.bodyList);
        DERUTF8String dERUTF8String = this.statusString;
        if (dERUTF8String != null) {
            aSN1EncodableVector2.add(dERUTF8String);
        }
        if ((otherInfo = this.otherInfo) != null) {
            aSN1EncodableVector2.add(otherInfo);
        }
        return new DERSequence(aSN1EncodableVector2);
    }

    public CMCStatus getCMCStatus() {
        return this.cMCStatus;
    }

    public BodyPartID[] getBodyList() {
        return Utils.toBodyPartIDArray(this.bodyList);
    }

    public DERUTF8String getStatusString() {
        return this.statusString;
    }

    public boolean hasOtherInfo() {
        return this.otherInfo != null;
    }

    public OtherInfo getOtherInfo() {
        return this.otherInfo;
    }

    public static class OtherInfo
    extends ASN1Object
    implements ASN1Choice {
        private final CMCFailInfo failInfo;
        private final PendInfo pendInfo;

        private static OtherInfo getInstance(Object object) {
            if (object instanceof OtherInfo) {
                return (OtherInfo)object;
            }
            if (object instanceof ASN1Encodable) {
                ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
                if (aSN1Primitive instanceof ASN1Integer) {
                    return new OtherInfo(CMCFailInfo.getInstance(aSN1Primitive));
                }
                if (aSN1Primitive instanceof ASN1Sequence) {
                    return new OtherInfo(PendInfo.getInstance(aSN1Primitive));
                }
            }
            throw new IllegalArgumentException(c.a(object, a.a("unknown object in getInstance(): ")));
        }

        public OtherInfo(CMCFailInfo cMCFailInfo) {
            this(cMCFailInfo, null);
        }

        public OtherInfo(PendInfo pendInfo) {
            this(null, pendInfo);
        }

        private OtherInfo(CMCFailInfo cMCFailInfo, PendInfo pendInfo) {
            this.failInfo = cMCFailInfo;
            this.pendInfo = pendInfo;
        }

        public boolean isFailInfo() {
            return this.failInfo != null;
        }

        @Override
        public ASN1Primitive toASN1Primitive() {
            PendInfo pendInfo = this.pendInfo;
            if (pendInfo != null) {
                return pendInfo.toASN1Primitive();
            }
            return this.failInfo.toASN1Primitive();
        }
    }
}

