/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;

public class ExtendedFailInfo
extends ASN1Object {
    private final ASN1ObjectIdentifier failInfoOID;
    private final ASN1Encodable failInfoValue;

    public ExtendedFailInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.failInfoOID = aSN1ObjectIdentifier;
        this.failInfoValue = aSN1Encodable;
    }

    private ExtendedFailInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 2) {
            this.failInfoOID = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
            this.failInfoValue = aSN1Sequence.getObjectAt(1);
            return;
        }
        throw new IllegalArgumentException("Sequence must be 2 elements.");
    }

    public static ExtendedFailInfo getInstance(Object object) {
        if (object instanceof ExtendedFailInfo) {
            return (ExtendedFailInfo)object;
        }
        if (object instanceof ASN1Encodable) {
            if ((object = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1Sequence) {
                return new ExtendedFailInfo((ASN1Sequence)object);
            }
        } else if (object instanceof byte[]) {
            return ExtendedFailInfo.getInstance(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[2];
        ASN1Encodable[] aSN1EncodableArray2 = aSN1EncodableArray;
        aSN1EncodableArray2[0] = this.failInfoOID;
        aSN1EncodableArray[1] = this.failInfoValue;
        return new DERSequence(aSN1EncodableArray2);
    }

    public ASN1ObjectIdentifier getFailInfoOID() {
        return this.failInfoOID;
    }

    public ASN1Encodable getFailInfoValue() {
        return this.failInfoValue;
    }
}

