/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.EncryptedContentInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.OriginatorInfo;

public class AuthEnvelopedData
extends ASN1Object {
    private ASN1Integer version;
    private OriginatorInfo originatorInfo;
    private ASN1Set recipientInfos;
    private EncryptedContentInfo authEncryptedContentInfo;
    private ASN1Set authAttrs;
    private ASN1OctetString mac;
    private ASN1Set unauthAttrs;

    public AuthEnvelopedData(OriginatorInfo originatorInfo, ASN1Set aSN1Set, EncryptedContentInfo encryptedContentInfo, ASN1Set aSN1Set2, ASN1OctetString aSN1OctetString, ASN1Set aSN1Set3) {
        this.version = new ASN1Integer(0L);
        this.originatorInfo = originatorInfo;
        this.recipientInfos = aSN1Set;
        if (aSN1Set.size() != 0) {
            this.authEncryptedContentInfo = encryptedContentInfo;
            this.authAttrs = aSN1Set2;
            if (!(encryptedContentInfo.getContentType().equals(CMSObjectIdentifiers.data) || aSN1Set2 != null && aSN1Set2.size() != 0)) {
                throw new IllegalArgumentException("authAttrs must be present with non-data content");
            }
            AuthEnvelopedData authEnvelopedData = this;
            authEnvelopedData.mac = aSN1OctetString;
            authEnvelopedData.unauthAttrs = aSN1Set3;
            return;
        }
        throw new IllegalArgumentException("AuthEnvelopedData requires at least 1 RecipientInfo");
    }

    private AuthEnvelopedData(ASN1Sequence aSN1Sequence) {
        int n = 1;
        ASN1Primitive aSN1Primitive = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0).toASN1Primitive());
        this.version = aSN1Primitive;
        if (((ASN1Integer)aSN1Primitive).intValueExact() == 0) {
            int n2 = n;
            n = 2;
            aSN1Primitive = aSN1Sequence.getObjectAt(n2).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1TaggedObject) {
                int n3 = n;
                this.originatorInfo = OriginatorInfo.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                n = 3;
                aSN1Primitive = aSN1Sequence.getObjectAt(n3).toASN1Primitive();
            }
            aSN1Primitive = ASN1Set.getInstance(aSN1Primitive);
            this.recipientInfos = aSN1Primitive;
            if (((ASN1Set)aSN1Primitive).size() != 0) {
                ASN1Set aSN1Set;
                this.authEncryptedContentInfo = EncryptedContentInfo.getInstance(aSN1Sequence.getObjectAt(n++).toASN1Primitive());
                if ((aSN1Primitive = aSN1Sequence.getObjectAt(n++).toASN1Primitive()) instanceof ASN1TaggedObject) {
                    this.authAttrs = ASN1Set.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                    aSN1Primitive = aSN1Sequence.getObjectAt(n++).toASN1Primitive();
                } else if (!(this.authEncryptedContentInfo.getContentType().equals(CMSObjectIdentifiers.data) || (aSN1Set = this.authAttrs) != null && aSN1Set.size() != 0)) {
                    throw new IllegalArgumentException("authAttrs must be present with non-data content");
                }
                this.mac = ASN1OctetString.getInstance(aSN1Primitive);
                if (aSN1Sequence.size() > n) {
                    this.unauthAttrs = ASN1Set.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n).toASN1Primitive(), false);
                }
                return;
            }
            throw new IllegalArgumentException("AuthEnvelopedData requires at least 1 RecipientInfo");
        }
        throw new IllegalArgumentException("AuthEnvelopedData version number must be 0");
    }

    public static AuthEnvelopedData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return AuthEnvelopedData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static AuthEnvelopedData getInstance(Object object) {
        if (object != null && !(object instanceof AuthEnvelopedData)) {
            if (object instanceof ASN1Sequence) {
                return new AuthEnvelopedData((ASN1Sequence)object);
            }
            throw new IllegalArgumentException(c.a(object, a.a("Invalid AuthEnvelopedData: ")));
        }
        return (AuthEnvelopedData)object;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public EncryptedContentInfo getAuthEncryptedContentInfo() {
        return this.authEncryptedContentInfo;
    }

    public ASN1Set getAuthAttrs() {
        return this.authAttrs;
    }

    public ASN1OctetString getMac() {
        return this.mac;
    }

    public ASN1Set getUnauthAttrs() {
        return this.unauthAttrs;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(7);
        aSN1EncodableVector.add(aSN1Object2.version);
        ASN1Object aSN1Object = aSN1Object2.originatorInfo;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            dERTaggedObject2 = new DERTaggedObject(false, 0, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        aSN1EncodableVector2.add(aSN1Object2.recipientInfos);
        aSN1EncodableVector2.add(aSN1Object2.authEncryptedContentInfo);
        aSN1Object = aSN1Object2.authAttrs;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            dERTaggedObject3 = new DERTaggedObject(false, 1, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        aSN1EncodableVector2.add(aSN1Object2.mac);
        ASN1Object aSN1Object2 = aSN1Object2.unauthAttrs;
        if (aSN1Object2 != null) {
            DERTaggedObject dERTaggedObject4;
            aSN1Object = dERTaggedObject4;
            dERTaggedObject4 = new DERTaggedObject(false, 2, aSN1Object2);
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new BERSequence(aSN1EncodableVector2);
    }
}

