/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class CMSAlgorithmProtection
extends ASN1Object {
    public static final int SIGNATURE = 1;
    public static final int MAC = 2;
    private final AlgorithmIdentifier digestAlgorithm;
    private final AlgorithmIdentifier signatureAlgorithm;
    private final AlgorithmIdentifier macAlgorithm;

    public CMSAlgorithmProtection(AlgorithmIdentifier algorithmIdentifier, int n, AlgorithmIdentifier algorithmIdentifier2) {
        block2: {
            block5: {
                block4: {
                    block3: {
                        if (algorithmIdentifier == null || algorithmIdentifier2 == null) break block2;
                        this.digestAlgorithm = algorithmIdentifier;
                        if (n != 1) break block3;
                        CMSAlgorithmProtection cMSAlgorithmProtection = this;
                        cMSAlgorithmProtection.signatureAlgorithm = algorithmIdentifier2;
                        cMSAlgorithmProtection.macAlgorithm = null;
                        break block4;
                    }
                    if (n != 2) break block5;
                    CMSAlgorithmProtection cMSAlgorithmProtection = this;
                    cMSAlgorithmProtection.signatureAlgorithm = null;
                    cMSAlgorithmProtection.macAlgorithm = algorithmIdentifier2;
                }
                return;
            }
            throw new IllegalArgumentException(a.a("Unknown type: ", n));
        }
        throw new NullPointerException("AlgorithmIdentifiers cannot be null");
    }

    private CMSAlgorithmProtection(ASN1Sequence aSN1Primitive) {
        block2: {
            block5: {
                block4: {
                    block3: {
                        if (((ASN1Sequence)aSN1Primitive).size() != 2) break block2;
                        this.digestAlgorithm = AlgorithmIdentifier.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(0));
                        if (((ASN1TaggedObject)(aSN1Primitive = ASN1TaggedObject.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(1)))).getTagNo() != 1) break block3;
                        CMSAlgorithmProtection cMSAlgorithmProtection = this;
                        cMSAlgorithmProtection.signatureAlgorithm = AlgorithmIdentifier.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                        cMSAlgorithmProtection.macAlgorithm = null;
                        break block4;
                    }
                    if (((ASN1TaggedObject)aSN1Primitive).getTagNo() != 2) break block5;
                    this.signatureAlgorithm = null;
                    this.macAlgorithm = AlgorithmIdentifier.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                }
                return;
            }
            throw new IllegalArgumentException(b.a((ASN1TaggedObject)aSN1Primitive, b.a.a("Unknown tag found: ")));
        }
        throw new IllegalArgumentException("Sequence wrong size: One of signatureAlgorithm or macAlgorithm must be present");
    }

    public static CMSAlgorithmProtection getInstance(Object object) {
        if (object instanceof CMSAlgorithmProtection) {
            return (CMSAlgorithmProtection)object;
        }
        if (object != null) {
            return new CMSAlgorithmProtection(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public AlgorithmIdentifier getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        AlgorithmIdentifier algorithmIdentifier;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector.add(this.digestAlgorithm);
        ASN1Object aSN1Object = this.signatureAlgorithm;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 1, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        if ((algorithmIdentifier = this.macAlgorithm) != null) {
            DERTaggedObject dERTaggedObject;
            aSN1Object = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 2, algorithmIdentifier);
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

