/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSet;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.ContentInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.SignerInfo;
import java.util.Enumeration;

public class SignedData
extends ASN1Object {
    private static final ASN1Integer VERSION_1 = new ASN1Integer(1L);
    private static final ASN1Integer VERSION_3 = new ASN1Integer(3L);
    private static final ASN1Integer VERSION_4 = new ASN1Integer(4L);
    private static final ASN1Integer VERSION_5 = new ASN1Integer(5L);
    private ASN1Integer version;
    private ASN1Set digestAlgorithms;
    private ContentInfo contentInfo;
    private ASN1Set certificates;
    private ASN1Set crls;
    private ASN1Set signerInfos;
    private boolean certsBer;
    private boolean crlsBer;

    public static SignedData getInstance(Object object) {
        if (object instanceof SignedData) {
            return (SignedData)object;
        }
        if (object != null) {
            return new SignedData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public SignedData(ASN1Set aSN1Set, ContentInfo contentInfo, ASN1Set aSN1Set2, ASN1Set aSN1Set3, ASN1Set aSN1Set4) {
        this.version = this.calculateVersion(contentInfo.getContentType(), aSN1Set2, aSN1Set3, aSN1Set4);
        this.digestAlgorithms = aSN1Set;
        this.contentInfo = contentInfo;
        this.certificates = aSN1Set2;
        this.crls = aSN1Set3;
        this.signerInfos = aSN1Set4;
        this.crlsBer = aSN1Set3 instanceof BERSet;
        this.certsBer = aSN1Set2 instanceof BERSet;
    }

    private ASN1Integer calculateVersion(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Set object, ASN1Set aSN1Set, ASN1Set aSN1Set2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (object != null) {
            object = ((ASN1Set)object).getObjects();
            while (object.hasMoreElements()) {
                Object object2 = object.nextElement();
                if (!(object2 instanceof ASN1TaggedObject)) continue;
                if (((ASN1TaggedObject)(object2 = ASN1TaggedObject.getInstance(object2))).getTagNo() == 1) {
                    bl3 = true;
                    continue;
                }
                if (((ASN1TaggedObject)object2).getTagNo() == 2) {
                    bl4 = true;
                    continue;
                }
                if (((ASN1TaggedObject)object2).getTagNo() != 3) continue;
                bl = true;
            }
        }
        if (bl) {
            return new ASN1Integer(5L);
        }
        if (aSN1Set != null) {
            object = aSN1Set.getObjects();
            while (object.hasMoreElements()) {
                if (!(object.nextElement() instanceof ASN1TaggedObject)) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            return VERSION_5;
        }
        if (bl4) {
            return VERSION_4;
        }
        if (bl3) {
            return VERSION_3;
        }
        if (this.checkForVersion3(aSN1Set2)) {
            return VERSION_3;
        }
        if (!CMSObjectIdentifiers.data.equals(aSN1ObjectIdentifier)) {
            return VERSION_3;
        }
        return VERSION_1;
    }

    private boolean checkForVersion3(ASN1Set aSN1Set) {
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            if (SignerInfo.getInstance(enumeration.nextElement()).getVersion().intValueExact() != 3) continue;
            return true;
        }
        return false;
    }

    private SignedData(ASN1Sequence object) {
        SignedData signedData = this;
        object = ((ASN1Sequence)object).getObjects();
        signedData.version = ASN1Integer.getInstance(object.nextElement());
        signedData.digestAlgorithms = (ASN1Set)object.nextElement();
        signedData.contentInfo = ContentInfo.getInstance(object.nextElement());
        while (object.hasMoreElements()) {
            ASN1Primitive aSN1Primitive = (ASN1Primitive)object.nextElement();
            if (aSN1Primitive instanceof ASN1TaggedObject) {
                int n = ((ASN1TaggedObject)(aSN1Primitive = (ASN1TaggedObject)aSN1Primitive)).getTagNo();
                if (n != 0) {
                    if (n == 1) {
                        this.crlsBer = aSN1Primitive instanceof BERTaggedObject;
                        this.crls = ASN1Set.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                        continue;
                    }
                    throw new IllegalArgumentException(b.a((ASN1TaggedObject)aSN1Primitive, a.a("unknown tag value ")));
                }
                this.certsBer = aSN1Primitive instanceof BERTaggedObject;
                this.certificates = ASN1Set.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                continue;
            }
            this.signerInfos = (ASN1Set)aSN1Primitive;
        }
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Set getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public ContentInfo getEncapContentInfo() {
        return this.contentInfo;
    }

    public ASN1Set getCertificates() {
        return this.certificates;
    }

    public ASN1Set getCRLs() {
        return this.crls;
    }

    public ASN1Set getSignerInfos() {
        return this.signerInfos;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1TaggedObject aSN1TaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(6);
        aSN1EncodableVector2.add(this.version);
        aSN1EncodableVector2.add(this.digestAlgorithms);
        aSN1EncodableVector.add(this.contentInfo);
        ASN1Set aSN1Set = this.certificates;
        if (aSN1Set != null) {
            if (this.certsBer) {
                BERTaggedObject bERTaggedObject;
                aSN1TaggedObject = bERTaggedObject;
                bERTaggedObject = new BERTaggedObject(false, 0, aSN1Set);
                aSN1EncodableVector2.add(aSN1TaggedObject);
            } else {
                DERTaggedObject dERTaggedObject;
                aSN1TaggedObject = dERTaggedObject;
                dERTaggedObject = new DERTaggedObject(false, 0, aSN1Set);
                aSN1EncodableVector2.add(aSN1TaggedObject);
            }
        }
        if ((aSN1Set = this.crls) != null) {
            if (this.crlsBer) {
                BERTaggedObject bERTaggedObject;
                aSN1TaggedObject = bERTaggedObject;
                bERTaggedObject = new BERTaggedObject(false, 1, aSN1Set);
                aSN1EncodableVector2.add(aSN1TaggedObject);
            } else {
                DERTaggedObject dERTaggedObject;
                aSN1TaggedObject = dERTaggedObject;
                dERTaggedObject = new DERTaggedObject(false, 1, aSN1Set);
                aSN1EncodableVector2.add(aSN1TaggedObject);
            }
        }
        aSN1EncodableVector2.add(this.signerInfos);
        return new BERSequence(aSN1EncodableVector2);
    }
}

