/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1SequenceParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1SetParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObjectParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.ContentInfoParser;
import java.io.IOException;

public class SignedDataParser {
    private ASN1SequenceParser _seq;
    private ASN1Integer _version;
    private Object _nextObject;
    private boolean _certsCalled;
    private boolean _crlsCalled;

    public static SignedDataParser getInstance(Object object) {
        if (object instanceof ASN1Sequence) {
            return new SignedDataParser(((ASN1Sequence)object).parser());
        }
        if (object instanceof ASN1SequenceParser) {
            return new SignedDataParser((ASN1SequenceParser)object);
        }
        throw new IOException(c.a(object, a.a("unknown object encountered: ")));
    }

    private SignedDataParser(ASN1SequenceParser aSN1SequenceParser) {
        this._seq = aSN1SequenceParser;
        this._version = (ASN1Integer)aSN1SequenceParser.readObject();
    }

    public ASN1Integer getVersion() {
        return this._version;
    }

    public ASN1SetParser getDigestAlgorithms() {
        ASN1Encodable aSN1Encodable = ((SignedDataParser)((Object)aSN1Encodable))._seq.readObject();
        if (aSN1Encodable instanceof ASN1Set) {
            return ((ASN1Set)aSN1Encodable).parser();
        }
        return (ASN1SetParser)aSN1Encodable;
    }

    public ContentInfoParser getEncapContentInfo() {
        return new ContentInfoParser((ASN1SequenceParser)this._seq.readObject());
    }

    public ASN1SetParser getCertificates() {
        this._certsCalled = true;
        ASN1Encodable aSN1Encodable = this._seq.readObject();
        this._nextObject = aSN1Encodable;
        if (aSN1Encodable instanceof ASN1TaggedObjectParser && ((ASN1TaggedObjectParser)aSN1Encodable).getTagNo() == 0) {
            this._nextObject = null;
            return (ASN1SetParser)((ASN1TaggedObjectParser)this._nextObject).getObjectParser(17, false);
        }
        return null;
    }

    public ASN1SetParser getCrls() {
        if (this._certsCalled) {
            Object object;
            this._crlsCalled = true;
            if (this._nextObject == null) {
                this._nextObject = this._seq.readObject();
            }
            if ((object = this._nextObject) instanceof ASN1TaggedObjectParser && ((ASN1TaggedObjectParser)object).getTagNo() == 1) {
                this._nextObject = null;
                return (ASN1SetParser)((ASN1TaggedObjectParser)this._nextObject).getObjectParser(17, false);
            }
            return null;
        }
        throw new IOException("getCerts() has not been called.");
    }

    public ASN1SetParser getSignerInfos() {
        if (this._certsCalled && this._crlsCalled) {
            if (this._nextObject == null) {
                this._nextObject = this._seq.readObject();
            }
            return (ASN1SetParser)this._nextObject;
        }
        throw new IOException("getCerts() and/or getCrls() has not been called.");
    }
}

