/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs.DVCSRequestInformation;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs.DVCSTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs.TargetEtcChain;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DigestInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.PolicyInformation;

public class DVCSCertInfo
extends ASN1Object {
    private static final int DEFAULT_VERSION = 1;
    private static final int TAG_DV_STATUS = 0;
    private static final int TAG_POLICY = 1;
    private static final int TAG_REQ_SIGNATURE = 2;
    private static final int TAG_CERTS = 3;
    private int version = 1;
    private DVCSRequestInformation dvReqInfo;
    private DigestInfo messageImprint;
    private ASN1Integer serialNumber;
    private DVCSTime responseTime;
    private PKIStatusInfo dvStatus;
    private PolicyInformation policy;
    private ASN1Set reqSignature;
    private ASN1Sequence certs;
    private Extensions extensions;

    public DVCSCertInfo(DVCSRequestInformation dVCSRequestInformation, DigestInfo digestInfo, ASN1Integer aSN1Integer, DVCSTime dVCSTime) {
        this.dvReqInfo = dVCSRequestInformation;
        this.messageImprint = digestInfo;
        this.serialNumber = aSN1Integer;
        this.responseTime = dVCSTime;
    }

    private DVCSCertInfo(ASN1Sequence aSN1Sequence) {
        int n;
        int n2 = 1;
        ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(0);
        try {
            this.version = ASN1Integer.getInstance(aSN1Encodable).intValueExact();
            n = n2;
            n2 = 2;
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        aSN1Encodable = aSN1Sequence.getObjectAt(n);
        this.dvReqInfo = DVCSRequestInformation.getInstance(aSN1Encodable);
        this.messageImprint = DigestInfo.getInstance(aSN1Sequence.getObjectAt(n2++));
        this.serialNumber = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(n2++));
        this.responseTime = DVCSTime.getInstance(aSN1Sequence.getObjectAt(n2++));
        block11: while (n2 < aSN1Sequence.size()) {
            if ((aSN1Encodable = aSN1Sequence.getObjectAt(n2++)) instanceof ASN1TaggedObject) {
                aSN1Encodable = ASN1TaggedObject.getInstance(aSN1Encodable);
                int n3 = ((ASN1TaggedObject)aSN1Encodable).getTagNo();
                switch (n3) {
                    default: {
                        throw new IllegalArgumentException(a.a("Unknown tag encountered: ", n3));
                    }
                    case 3: {
                        this.certs = ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Encodable, false);
                        continue block11;
                    }
                    case 2: {
                        this.reqSignature = ASN1Set.getInstance((ASN1TaggedObject)aSN1Encodable, false);
                        continue block11;
                    }
                    case 1: {
                        this.policy = PolicyInformation.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Encodable, false));
                        continue block11;
                    }
                    case 0: 
                }
                this.dvStatus = PKIStatusInfo.getInstance((ASN1TaggedObject)aSN1Encodable, false);
                continue;
            }
            try {
                this.extensions = Extensions.getInstance(aSN1Encodable);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public static DVCSCertInfo getInstance(Object object) {
        if (object instanceof DVCSCertInfo) {
            return (DVCSCertInfo)object;
        }
        if (object != null) {
            return new DVCSCertInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static DVCSCertInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DVCSCertInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    private void setVersion(int n) {
        this.version = n;
    }

    private void setDvReqInfo(DVCSRequestInformation dVCSRequestInformation) {
        this.dvReqInfo = dVCSRequestInformation;
    }

    private void setMessageImprint(DigestInfo digestInfo) {
        this.messageImprint = digestInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        Extensions extensions;
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(10);
        int aSN1Object = this.version;
        if (aSN1Object != 1) {
            aSN1EncodableVector2.add(new ASN1Integer(aSN1Object));
        }
        aSN1EncodableVector2.add(this.dvReqInfo);
        aSN1EncodableVector2.add(this.messageImprint);
        aSN1EncodableVector2.add(this.serialNumber);
        aSN1EncodableVector2.add(this.responseTime);
        ASN1Object aSN1Object2 = this.dvStatus;
        if (aSN1Object2 != null) {
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            dERTaggedObject2 = new DERTaggedObject(false, 0, aSN1Object2);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Object2 = this.policy) != null) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            dERTaggedObject3 = new DERTaggedObject(false, 1, aSN1Object2);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Object2 = this.reqSignature) != null) {
            DERTaggedObject dERTaggedObject4;
            dERTaggedObject = dERTaggedObject4;
            dERTaggedObject4 = new DERTaggedObject(false, 2, aSN1Object2);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Object2 = this.certs) != null) {
            DERTaggedObject dERTaggedObject5;
            dERTaggedObject = dERTaggedObject5;
            dERTaggedObject5 = new DERTaggedObject(false, 3, aSN1Object2);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((extensions = this.extensions) != null) {
            aSN1EncodableVector2.add(extensions);
        }
        return new DERSequence(aSN1EncodableVector2);
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append("DVCSCertInfo {\n");
        if (this.version != 1) {
            stringBuffer2.append(b.a.a("version: ").append(this.version).append("\n").toString());
        }
        StringBuffer stringBuffer3 = stringBuffer2;
        stringBuffer3.append(b.a.a("dvReqInfo: ").append(this.dvReqInfo).append("\n").toString());
        stringBuffer3.append("messageImprint: " + this.messageImprint + "\n");
        stringBuffer3.append("serialNumber: " + this.serialNumber + "\n");
        stringBuffer3.append("responseTime: " + this.responseTime + "\n");
        if (this.dvStatus != null) {
            stringBuffer2.append(b.a.a("dvStatus: ").append(this.dvStatus).append("\n").toString());
        }
        if (this.policy != null) {
            stringBuffer2.append(b.a.a("policy: ").append(this.policy).append("\n").toString());
        }
        if (this.reqSignature != null) {
            stringBuffer2.append(b.a.a("reqSignature: ").append(this.reqSignature).append("\n").toString());
        }
        if (this.certs != null) {
            stringBuffer2.append(b.a.a("certs: ").append(this.certs).append("\n").toString());
        }
        if (this.extensions != null) {
            stringBuffer2.append(b.a.a("extensions: ").append(this.extensions).append("\n").toString());
        }
        StringBuffer stringBuffer4 = stringBuffer2;
        stringBuffer4.append("}\n");
        return stringBuffer4.toString();
    }

    public int getVersion() {
        return this.version;
    }

    public DVCSRequestInformation getDvReqInfo() {
        return this.dvReqInfo;
    }

    public DigestInfo getMessageImprint() {
        return this.messageImprint;
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public DVCSTime getResponseTime() {
        return this.responseTime;
    }

    public PKIStatusInfo getDvStatus() {
        return this.dvStatus;
    }

    public PolicyInformation getPolicy() {
        return this.policy;
    }

    public ASN1Set getReqSignature() {
        return this.reqSignature;
    }

    public TargetEtcChain[] getCerts() {
        ASN1Object aSN1Object = aSN1Object.certs;
        if (aSN1Object != null) {
            return TargetEtcChain.arrayFromSequence((ASN1Sequence)aSN1Object);
        }
        return null;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }
}

