/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs.DVCSCertInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs.DVCSErrorNotice;
import java.io.IOException;

public class DVCSResponse
extends ASN1Object
implements ASN1Choice {
    private DVCSCertInfo dvCertInfo;
    private DVCSErrorNotice dvErrorNote;

    public DVCSResponse(DVCSCertInfo dVCSCertInfo) {
        this.dvCertInfo = dVCSCertInfo;
    }

    public DVCSResponse(DVCSErrorNotice dVCSErrorNotice) {
        this.dvErrorNote = dVCSErrorNotice;
    }

    public static DVCSResponse getInstance(Object object) {
        if (object != null && !(object instanceof DVCSResponse)) {
            if (object instanceof byte[]) {
                try {
                    return DVCSResponse.getInstance(ASN1Primitive.fromByteArray((byte[])object));
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(b.a(iOException, a.a("failed to construct sequence from byte[]: ")));
                }
            }
            if (object instanceof ASN1Sequence) {
                object = DVCSCertInfo.getInstance(object);
                return new DVCSResponse((DVCSCertInfo)object);
            }
            if (object instanceof ASN1TaggedObject) {
                object = DVCSErrorNotice.getInstance(ASN1TaggedObject.getInstance(object), false);
                return new DVCSResponse((DVCSErrorNotice)object);
            }
            throw new IllegalArgumentException(c.a(object, a.a("Couldn't convert from object to DVCSResponse: ")));
        }
        return (DVCSResponse)object;
    }

    public static DVCSResponse getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DVCSResponse.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public DVCSCertInfo getCertInfo() {
        return this.dvCertInfo;
    }

    public DVCSErrorNotice getErrorNotice() {
        return this.dvErrorNote;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DVCSCertInfo dVCSCertInfo = aSN1Object.dvCertInfo;
        if (dVCSCertInfo != null) {
            return dVCSCertInfo.toASN1Primitive();
        }
        ASN1Object aSN1Object = aSN1Object.dvErrorNote;
        return new DERTaggedObject(false, 0, aSN1Object);
    }

    public String toString() {
        if (this.dvCertInfo != null) {
            return a.a("DVCSResponse {\ndvCertInfo: ").append(this.dvCertInfo.toString()).append("}\n").toString();
        }
        return a.a("DVCSResponse {\ndvErrorNote: ").append(this.dvErrorNote.toString()).append("}\n").toString();
    }
}

