/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs.TargetEtcChain;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DigestInfo;

public class Data
extends ASN1Object
implements ASN1Choice {
    private ASN1OctetString message;
    private DigestInfo messageImprint;
    private ASN1Sequence certs;

    public Data(byte[] byArray) {
        DEROctetString dEROctetString;
        ASN1Object aSN1Object = dEROctetString;
        dEROctetString = new DEROctetString(byArray);
        v1.message = aSN1Object;
    }

    public Data(ASN1OctetString aSN1OctetString) {
        this.message = aSN1OctetString;
    }

    public Data(DigestInfo digestInfo) {
        this.messageImprint = digestInfo;
    }

    public Data(TargetEtcChain targetEtcChain) {
        DERSequence dERSequence;
        ASN1Object aSN1Object = dERSequence;
        dERSequence = new DERSequence(targetEtcChain);
        v1.certs = aSN1Object;
    }

    public Data(TargetEtcChain[] targetEtcChainArray) {
        DERSequence dERSequence;
        ASN1Object aSN1Object = dERSequence;
        dERSequence = new DERSequence(targetEtcChainArray);
        v1.certs = aSN1Object;
    }

    private Data(ASN1Sequence aSN1Sequence) {
        this.certs = aSN1Sequence;
    }

    public static Data getInstance(Object object) {
        if (object instanceof Data) {
            return (Data)object;
        }
        if (object instanceof ASN1OctetString) {
            return new Data((ASN1OctetString)object);
        }
        if (object instanceof ASN1Sequence) {
            return new Data(DigestInfo.getInstance(object));
        }
        if (object instanceof ASN1TaggedObject) {
            return new Data(ASN1Sequence.getInstance((ASN1TaggedObject)object, false));
        }
        throw new IllegalArgumentException(c.a(object, a.a("Unknown object submitted to getInstance: ")));
    }

    public static Data getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return Data.getInstance(aSN1TaggedObject.getObject());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1Object aSN1Object = aSN1Object2.message;
        if (aSN1Object != null) {
            return ((ASN1Primitive)aSN1Object).toASN1Primitive();
        }
        aSN1Object = aSN1Object2.messageImprint;
        if (aSN1Object != null) {
            return ((DigestInfo)aSN1Object).toASN1Primitive();
        }
        ASN1Object aSN1Object2 = aSN1Object2.certs;
        return new DERTaggedObject(false, 0, aSN1Object2);
    }

    public String toString() {
        if (this.message != null) {
            return a.a("Data {\n").append(this.message).append("}\n").toString();
        }
        if (this.messageImprint != null) {
            return a.a("Data {\n").append(this.messageImprint).append("}\n").toString();
        }
        return a.a("Data {\n").append(this.certs).append("}\n").toString();
    }

    public ASN1OctetString getMessage() {
        return this.message;
    }

    public DigestInfo getMessageImprint() {
        return this.messageImprint;
    }

    public TargetEtcChain[] getCerts() {
        ASN1Sequence aSN1Sequence = this.certs;
        if (aSN1Sequence == null) {
            return null;
        }
        int n = aSN1Sequence.size();
        TargetEtcChain[] targetEtcChainArray = new TargetEtcChain[n];
        for (int k = 0; k != n; ++k) {
            targetEtcChainArray[k] = TargetEtcChain.getInstance(this.certs.getObjectAt(k));
        }
        return targetEtcChainArray;
    }
}

