/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.dvcs;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Boolean;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.PolicyInformation;
import java.util.Arrays;

public class PathProcInput
extends ASN1Object {
    private PolicyInformation[] acceptablePolicySet;
    private boolean inhibitPolicyMapping = false;
    private boolean explicitPolicyReqd = false;
    private boolean inhibitAnyPolicy = false;

    public PathProcInput(PolicyInformation[] policyInformationArray) {
        this.acceptablePolicySet = this.copy(policyInformationArray);
    }

    public PathProcInput(PolicyInformation[] policyInformationArray, boolean bl, boolean bl2, boolean bl3) {
        this.acceptablePolicySet = this.copy(policyInformationArray);
        this.inhibitPolicyMapping = bl;
        this.explicitPolicyReqd = bl2;
        this.inhibitAnyPolicy = bl3;
    }

    private static PolicyInformation[] fromSequence(ASN1Sequence aSN1Sequence) {
        int n = aSN1Sequence.size();
        PolicyInformation[] policyInformationArray = new PolicyInformation[n];
        for (int k = 0; k != n; ++k) {
            policyInformationArray[k] = PolicyInformation.getInstance(aSN1Sequence.getObjectAt(k));
        }
        return policyInformationArray;
    }

    public static PathProcInput getInstance(Object object) {
        if (object instanceof PathProcInput) {
            return (PathProcInput)object;
        }
        if (object != null) {
            PathProcInput pathProcInput;
            object = ASN1Sequence.getInstance(object);
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(((ASN1Sequence)object).getObjectAt(0));
            PathProcInput pathProcInput2 = pathProcInput;
            pathProcInput = new PathProcInput(PathProcInput.fromSequence(aSN1Sequence));
            for (int k = 1; k < ((ASN1Sequence)object).size(); ++k) {
                ASN1Encodable aSN1Encodable = ((ASN1Sequence)object).getObjectAt(k);
                if (aSN1Encodable instanceof ASN1Boolean) {
                    pathProcInput2.setInhibitPolicyMapping(ASN1Boolean.getInstance(aSN1Encodable).isTrue());
                    continue;
                }
                if (!(aSN1Encodable instanceof ASN1TaggedObject)) continue;
                int n = ((ASN1TaggedObject)(aSN1Encodable = ASN1TaggedObject.getInstance(aSN1Encodable))).getTagNo();
                if (n != 0) {
                    if (n == 1) {
                        pathProcInput2.setInhibitAnyPolicy(ASN1Boolean.getInstance((ASN1TaggedObject)aSN1Encodable, false).isTrue());
                        continue;
                    }
                    throw new IllegalArgumentException(b.a((ASN1TaggedObject)aSN1Encodable, a.a("Unknown tag encountered: ")));
                }
                pathProcInput2.setExplicitPolicyReqd(ASN1Boolean.getInstance((ASN1TaggedObject)aSN1Encodable, false).isTrue());
            }
            return pathProcInput2;
        }
        return null;
    }

    public static PathProcInput getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return PathProcInput.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    private void setInhibitPolicyMapping(boolean bl) {
        this.inhibitPolicyMapping = bl;
    }

    private void setExplicitPolicyReqd(boolean bl) {
        this.explicitPolicyReqd = bl;
    }

    private void setInhibitAnyPolicy(boolean bl) {
        this.inhibitAnyPolicy = bl;
    }

    private PolicyInformation[] copy(PolicyInformation[] policyInformationArray) {
        int n = policyInformationArray.length;
        PolicyInformation[] policyInformationArray2 = new PolicyInformation[n];
        System.arraycopy(policyInformationArray, 0, policyInformationArray2, 0, n);
        return policyInformationArray2;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        boolean bl;
        DERSequence dERSequence;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2;
        aSN1EncodableVector2 = new ASN1EncodableVector(4);
        ASN1EncodableVector aSN1EncodableVector4 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(this.acceptablePolicySet.length);
        int n = 0;
        while (true) {
            PolicyInformation[] policyInformationArray = this.acceptablePolicySet;
            if (n == this.acceptablePolicySet.length) break;
            aSN1EncodableVector4.add(policyInformationArray[n]);
            ++n;
        }
        ASN1Primitive aSN1Primitive = dERSequence;
        dERSequence = new DERSequence(aSN1EncodableVector4);
        aSN1EncodableVector3.add(aSN1Primitive);
        boolean bl2 = this.inhibitPolicyMapping;
        if (bl2) {
            aSN1EncodableVector3.add(ASN1Boolean.getInstance(bl2));
        }
        if (bl2 = this.explicitPolicyReqd) {
            DERTaggedObject dERTaggedObject;
            aSN1Primitive = dERTaggedObject;
            ASN1Boolean aSN1Boolean = ASN1Boolean.getInstance(bl2);
            dERTaggedObject = new DERTaggedObject(false, 0, aSN1Boolean);
            aSN1EncodableVector3.add(aSN1Primitive);
        }
        if (bl = this.inhibitAnyPolicy) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            ASN1Boolean aSN1Boolean = ASN1Boolean.getInstance(bl);
            dERTaggedObject = new DERTaggedObject(false, 1, aSN1Boolean);
            aSN1EncodableVector3.add(dERTaggedObject2);
        }
        return new DERSequence(aSN1EncodableVector3);
    }

    public String toString() {
        return a.a("PathProcInput: {\nacceptablePolicySet: ").append(Arrays.asList(this.acceptablePolicySet)).append("\ninhibitPolicyMapping: ").append(this.inhibitPolicyMapping).append("\nexplicitPolicyReqd: ").append(this.explicitPolicyReqd).append("\ninhibitAnyPolicy: ").append(this.inhibitAnyPolicy).append("\n}\n").toString();
    }

    public PolicyInformation[] getAcceptablePolicySet() {
        PathProcInput pathProcInput = this;
        return pathProcInput.copy(pathProcInput.acceptablePolicySet);
    }

    public boolean isInhibitPolicyMapping() {
        return this.inhibitPolicyMapping;
    }

    public boolean isExplicitPolicyReqd() {
        return this.explicitPolicyReqd;
    }

    public boolean isInhibitAnyPolicy() {
        return this.inhibitAnyPolicy;
    }
}

