/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ApplicationSpecific;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ParsingException;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERApplicationSpecific;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.CertificateBody;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.CertificateHolderReference;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.CertificationAuthorityReference;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.Flags;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.PackedDate;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.InputStream;

public class CVCertificate
extends ASN1Object {
    private static int bodyValid = 1;
    private static int signValid = 2;
    private CertificateBody certificateBody;
    private byte[] signature;
    private int valid;

    private void setPrivateData(ASN1ApplicationSpecific aSN1ApplicationSpecific) {
        this.valid = 0;
        if (aSN1ApplicationSpecific.getApplicationTag() == 33) {
            ASN1Primitive aSN1Primitive;
            ASN1InputStream aSN1InputStream;
            ASN1InputStream aSN1InputStream2 = aSN1InputStream;
            aSN1InputStream = new ASN1InputStream(aSN1ApplicationSpecific.getContents());
            while ((aSN1Primitive = aSN1InputStream2.readObject()) != null) {
                if (aSN1Primitive instanceof ASN1ApplicationSpecific) {
                    int n = ((ASN1ApplicationSpecific)(aSN1Primitive = (ASN1ApplicationSpecific)aSN1Primitive)).getApplicationTag();
                    if (n != 55) {
                        if (n == 78) {
                            this.certificateBody = CertificateBody.getInstance(aSN1Primitive);
                            this.valid |= bodyValid;
                            continue;
                        }
                        throw new IOException(a.a("Invalid tag, not an Iso7816CertificateStructure :").append(((ASN1ApplicationSpecific)aSN1Primitive).getApplicationTag()).toString());
                    }
                    this.signature = ((ASN1ApplicationSpecific)aSN1Primitive).getContents();
                    this.valid |= signValid;
                    continue;
                }
                throw new IOException("Invalid Object, not an Iso7816CertificateStructure");
            }
            ((InputStream)aSN1InputStream2).close();
            if (this.valid == (signValid | bodyValid)) {
                return;
            }
            throw new IOException(a.a("invalid CARDHOLDER_CERTIFICATE :").append(aSN1ApplicationSpecific.getApplicationTag()).toString());
        }
        throw new IOException(a.a("not a CARDHOLDER_CERTIFICATE :").append(aSN1ApplicationSpecific.getApplicationTag()).toString());
    }

    public CVCertificate(ASN1InputStream aSN1InputStream) {
        CVCertificate cVCertificate = this;
        cVCertificate.initFrom(aSN1InputStream);
    }

    private void initFrom(ASN1InputStream aSN1InputStream) {
        ASN1Primitive aSN1Primitive;
        while ((aSN1Primitive = aSN1InputStream.readObject()) != null) {
            if (aSN1Primitive instanceof ASN1ApplicationSpecific) {
                this.setPrivateData((ASN1ApplicationSpecific)aSN1Primitive);
                continue;
            }
            throw new IOException("Invalid Input Stream for creating an Iso7816CertificateStructure");
        }
    }

    private CVCertificate(ASN1ApplicationSpecific aSN1ApplicationSpecific) {
        CVCertificate cVCertificate = this;
        cVCertificate.setPrivateData(aSN1ApplicationSpecific);
    }

    public CVCertificate(CertificateBody certificateBody, byte[] byArray) {
        this.certificateBody = certificateBody;
        this.signature = Arrays.clone(byArray);
        this.valid = this.valid | bodyValid | signValid;
    }

    public static CVCertificate getInstance(Object object) {
        if (object instanceof CVCertificate) {
            return (CVCertificate)object;
        }
        if (object != null) {
            try {
                return new CVCertificate(ASN1ApplicationSpecific.getInstance(object));
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException(b.a(iOException, a.a("unable to parse data: ")), iOException);
            }
        }
        return null;
    }

    public byte[] getSignature() {
        return Arrays.clone(this.signature);
    }

    public CertificateBody getBody() {
        return this.certificateBody;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(2);
        aSN1EncodableVector.add(this.certificateBody);
        try {
            aSN1EncodableVector.add(new DERApplicationSpecific(false, 55, new DEROctetString(this.signature)));
            return new DERApplicationSpecific(33, aSN1EncodableVector2);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to convert signature!");
        }
    }

    public ASN1ObjectIdentifier getHolderAuthorization() {
        return this.certificateBody.getCertificateHolderAuthorization().getOid();
    }

    public PackedDate getEffectiveDate() {
        return this.certificateBody.getCertificateEffectiveDate();
    }

    public int getCertificateType() {
        return this.certificateBody.getCertificateType();
    }

    public PackedDate getExpirationDate() {
        return this.certificateBody.getCertificateExpirationDate();
    }

    public int getRole() {
        return this.certificateBody.getCertificateHolderAuthorization().getAccessRights();
    }

    public CertificationAuthorityReference getAuthorityReference() {
        return this.certificateBody.getCertificationAuthorityReference();
    }

    public CertificateHolderReference getHolderReference() {
        return this.certificateBody.getCertificateHolderReference();
    }

    public int getHolderAuthorizationRole() {
        return this.certificateBody.getCertificateHolderAuthorization().getAccessRights() & 0xC0;
    }

    public Flags getHolderAuthorizationRights() {
        return new Flags(this.certificateBody.getCertificateHolderAuthorization().getAccessRights() & 0x1F);
    }
}

