/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ApplicationSpecific;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERApplicationSpecific;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.CertificateHolderReference;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.CertificationAuthorityReference;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.EACTags;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.PackedDate;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.eac.PublicKeyDataObject;
import java.io.IOException;
import java.io.InputStream;

public class CertificateBody
extends ASN1Object {
    private static final int CPI = 1;
    private static final int CAR = 2;
    private static final int PK = 4;
    private static final int CHR = 8;
    private static final int CHA = 16;
    private static final int CEfD = 32;
    private static final int CExD = 64;
    public static final int profileType = 127;
    public static final int requestType = 13;
    public ASN1InputStream seq;
    private ASN1ApplicationSpecific certificateProfileIdentifier;
    private ASN1ApplicationSpecific certificationAuthorityReference;
    private PublicKeyDataObject publicKey;
    private ASN1ApplicationSpecific certificateHolderReference;
    private CertificateHolderAuthorization certificateHolderAuthorization;
    private ASN1ApplicationSpecific certificateEffectiveDate;
    private ASN1ApplicationSpecific certificateExpirationDate;
    private int certificateType;

    private void setIso7816CertificateBody(ASN1ApplicationSpecific aSN1ApplicationSpecific) {
        if (aSN1ApplicationSpecific.getApplicationTag() == 78) {
            ASN1InputStream aSN1InputStream;
            block9: {
                ASN1InputStream aSN1InputStream2;
                Object object = aSN1ApplicationSpecific.getContents();
                aSN1InputStream = aSN1InputStream2;
                aSN1InputStream2 = new ASN1InputStream((byte[])object);
                while (true) {
                    ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
                    object = aSN1Primitive;
                    if (aSN1Primitive == null) break block9;
                    if (!(object instanceof ASN1ApplicationSpecific)) break;
                    ASN1ApplicationSpecific aSN1ApplicationSpecific2 = (ASN1ApplicationSpecific)object;
                    object = aSN1ApplicationSpecific2;
                    int n = aSN1ApplicationSpecific2.getApplicationTag();
                    if (n != 2) {
                        if (n != 32) {
                            if (n != 41) {
                                if (n != 73) {
                                    CertificateHolderAuthorization certificateHolderAuthorization;
                                    if (n != 76) {
                                        if (n != 36) {
                                            if (n == 37) {
                                                this.setCertificateEffectiveDate((ASN1ApplicationSpecific)object);
                                                continue;
                                            }
                                            this.certificateType = 0;
                                            throw new IOException(a.a("Not a valid iso7816 ASN1ApplicationSpecific tag ").append(((ASN1ApplicationSpecific)object).getApplicationTag()).toString());
                                        }
                                        this.setCertificateExpirationDate((ASN1ApplicationSpecific)object);
                                        continue;
                                    }
                                    CertificateHolderAuthorization certificateHolderAuthorization2 = certificateHolderAuthorization;
                                    certificateHolderAuthorization = new CertificateHolderAuthorization((ASN1ApplicationSpecific)object);
                                    this.setCertificateHolderAuthorization(certificateHolderAuthorization2);
                                    continue;
                                }
                                this.setPublicKey(PublicKeyDataObject.getInstance(((ASN1ApplicationSpecific)object).getObject(16)));
                                continue;
                            }
                            this.setCertificateProfileIdentifier((ASN1ApplicationSpecific)object);
                            continue;
                        }
                        this.setCertificateHolderReference((ASN1ApplicationSpecific)object);
                        continue;
                    }
                    this.setCertificationAuthorityReference((ASN1ApplicationSpecific)object);
                }
                throw new IOException(a.a("Not a valid iso7816 content : not a ASN1ApplicationSpecific Object :").append(EACTags.encodeTag(aSN1ApplicationSpecific)).append(object.getClass()).toString());
            }
            ((InputStream)aSN1InputStream).close();
            return;
        }
        throw new IOException("Bad tag : not an iso7816 CERTIFICATE_CONTENT_TEMPLATE");
    }

    public CertificateBody(ASN1ApplicationSpecific aSN1ApplicationSpecific, CertificationAuthorityReference certificationAuthorityReference, PublicKeyDataObject publicKeyDataObject, CertificateHolderReference certificateHolderReference, CertificateHolderAuthorization certificateHolderAuthorization, PackedDate packedDate, PackedDate packedDate2) {
        CertificateBody certificateBody = this;
        CertificateBody certificateBody2 = this;
        CertificateBody certificateBody3 = this;
        this.certificateType = 0;
        certificateBody3.setCertificateProfileIdentifier(aSN1ApplicationSpecific);
        certificateBody3.setCertificationAuthorityReference(new DERApplicationSpecific(2, certificationAuthorityReference.getEncoded()));
        certificateBody2.setPublicKey(publicKeyDataObject);
        certificateBody2.setCertificateHolderReference(new DERApplicationSpecific(32, certificateHolderReference.getEncoded()));
        certificateBody.setCertificateHolderAuthorization(certificateHolderAuthorization);
        try {
            certificateBody.setCertificateEffectiveDate(new DERApplicationSpecific(false, 37, new DEROctetString(packedDate.getEncoding())));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(b.a(iOException, a.a("unable to encode dates: ")));
        }
        certificateBody.setCertificateExpirationDate(new DERApplicationSpecific(false, 36, new DEROctetString(packedDate2.getEncoding())));
    }

    private CertificateBody(ASN1ApplicationSpecific aSN1ApplicationSpecific) {
        CertificateBody certificateBody = this;
        certificateBody.certificateType = 0;
        certificateBody.setIso7816CertificateBody(aSN1ApplicationSpecific);
    }

    private ASN1Primitive profileToASN1Object() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        CertificateBody certificateBody = aSN1Object;
        CertificateBody certificateBody2 = aSN1Object;
        CertificateBody certificateBody3 = aSN1Object;
        CertificateBody certificateBody4 = aSN1Object;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2;
        aSN1EncodableVector2(7);
        aSN1EncodableVector2.add(aSN1Object.certificateProfileIdentifier);
        aSN1EncodableVector3.add(aSN1Object.certificationAuthorityReference);
        ASN1Object aSN1Object = aSN1Object.publicKey;
        aSN1EncodableVector3.add(new DERApplicationSpecific(false, 73, aSN1Object));
        aSN1EncodableVector2.add(certificateBody4.certificateHolderReference);
        aSN1EncodableVector2.add(certificateBody3.certificateHolderAuthorization);
        aSN1EncodableVector2.add(certificateBody2.certificateEffectiveDate);
        aSN1EncodableVector.add(certificateBody.certificateExpirationDate);
        return new DERApplicationSpecific(78, aSN1EncodableVector2);
    }

    private void setCertificateProfileIdentifier(ASN1ApplicationSpecific aSN1ApplicationSpecific) {
        if (aSN1ApplicationSpecific.getApplicationTag() == 41) {
            this.certificateProfileIdentifier = aSN1ApplicationSpecific;
            this.certificateType |= 1;
            return;
        }
        throw new IllegalArgumentException(a.a("Not an Iso7816Tags.INTERCHANGE_PROFILE tag :").append(EACTags.encodeTag(aSN1ApplicationSpecific)).toString());
    }

    private void setCertificateHolderReference(ASN1ApplicationSpecific aSN1ApplicationSpecific) {
        if (aSN1ApplicationSpecific.getApplicationTag() == 32) {
            this.certificateHolderReference = aSN1ApplicationSpecific;
            this.certificateType |= 8;
            return;
        }
        throw new IllegalArgumentException("Not an Iso7816Tags.CARDHOLDER_NAME tag");
    }

    private void setCertificationAuthorityReference(ASN1ApplicationSpecific aSN1ApplicationSpecific) {
        if (aSN1ApplicationSpecific.getApplicationTag() == 2) {
            this.certificationAuthorityReference = aSN1ApplicationSpecific;
            this.certificateType |= 2;
            return;
        }
        throw new IllegalArgumentException("Not an Iso7816Tags.ISSUER_IDENTIFICATION_NUMBER tag");
    }

    private void setPublicKey(PublicKeyDataObject publicKeyDataObject) {
        this.publicKey = PublicKeyDataObject.getInstance(publicKeyDataObject);
        this.certificateType |= 4;
    }

    private ASN1Primitive requestToASN1Object() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        CertificateBody certificateBody = aSN1Object;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2;
        aSN1EncodableVector2(3);
        aSN1EncodableVector3.add(aSN1Object.certificateProfileIdentifier);
        ASN1Object aSN1Object = aSN1Object.publicKey;
        aSN1EncodableVector3.add(new DERApplicationSpecific(false, 73, aSN1Object));
        aSN1EncodableVector.add(certificateBody.certificateHolderReference);
        return new DERApplicationSpecific(78, aSN1EncodableVector2);
    }

    public static CertificateBody getInstance(Object object) {
        if (object instanceof CertificateBody) {
            return (CertificateBody)object;
        }
        if (object != null) {
            return new CertificateBody(ASN1ApplicationSpecific.getInstance(object));
        }
        return null;
    }

    private void setCertificateEffectiveDate(ASN1ApplicationSpecific aSN1ApplicationSpecific) {
        if (aSN1ApplicationSpecific.getApplicationTag() == 37) {
            this.certificateEffectiveDate = aSN1ApplicationSpecific;
            this.certificateType |= 0x20;
            return;
        }
        throw new IllegalArgumentException(a.a("Not an Iso7816Tags.APPLICATION_EFFECTIVE_DATE tag :").append(EACTags.encodeTag(aSN1ApplicationSpecific)).toString());
    }

    private void setCertificateExpirationDate(ASN1ApplicationSpecific aSN1ApplicationSpecific) {
        if (aSN1ApplicationSpecific.getApplicationTag() == 36) {
            this.certificateExpirationDate = aSN1ApplicationSpecific;
            this.certificateType |= 0x40;
            return;
        }
        throw new IllegalArgumentException("Not an Iso7816Tags.APPLICATION_EXPIRATION_DATE tag");
    }

    private void setCertificateHolderAuthorization(CertificateHolderAuthorization certificateHolderAuthorization) {
        this.certificateHolderAuthorization = certificateHolderAuthorization;
        this.certificateType |= 0x10;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        int n;
        block5: {
            try {
                n = this.certificateType;
                if (n != 127) break block5;
            }
            catch (IOException iOException) {
                return null;
            }
            return this.profileToASN1Object();
        }
        if (n == 13) {
            return this.requestToASN1Object();
        }
        return null;
    }

    public int getCertificateType() {
        return this.certificateType;
    }

    public PackedDate getCertificateEffectiveDate() {
        if ((this.certificateType & 0x20) == 32) {
            return new PackedDate(this.certificateEffectiveDate.getContents());
        }
        return null;
    }

    public PackedDate getCertificateExpirationDate() {
        if ((this.certificateType & 0x40) == 64) {
            return new PackedDate(this.certificateExpirationDate.getContents());
        }
        throw new IOException("certificate Expiration Date not set");
    }

    public CertificateHolderAuthorization getCertificateHolderAuthorization() {
        if ((this.certificateType & 0x10) == 16) {
            return this.certificateHolderAuthorization;
        }
        throw new IOException("Certificate Holder Authorisation not set");
    }

    public CertificateHolderReference getCertificateHolderReference() {
        return new CertificateHolderReference(this.certificateHolderReference.getContents());
    }

    public ASN1ApplicationSpecific getCertificateProfileIdentifier() {
        return this.certificateProfileIdentifier;
    }

    public CertificationAuthorityReference getCertificationAuthorityReference() {
        if ((this.certificateType & 2) == 2) {
            return new CertificationAuthorityReference(this.certificationAuthorityReference.getContents());
        }
        throw new IOException("Certification authority reference not set");
    }

    public PublicKeyDataObject getPublicKey() {
        return this.publicKey;
    }
}

