/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.esf;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.esf.CrlListID;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.esf.OcspListID;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.esf.OtherRevRefs;

public class CrlOcspRef
extends ASN1Object {
    private CrlListID crlids;
    private OcspListID ocspids;
    private OtherRevRefs otherRev;

    public static CrlOcspRef getInstance(Object object) {
        if (object instanceof CrlOcspRef) {
            return (CrlOcspRef)object;
        }
        if (object != null) {
            return new CrlOcspRef(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private CrlOcspRef(ASN1Sequence object) {
        object = ((ASN1Sequence)object).getObjects();
        while (object.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object.nextElement();
            int n = aSN1TaggedObject.getTagNo();
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        this.otherRev = OtherRevRefs.getInstance(aSN1TaggedObject.getObject());
                        continue;
                    }
                    throw new IllegalArgumentException("illegal tag");
                }
                this.ocspids = OcspListID.getInstance(aSN1TaggedObject.getObject());
                continue;
            }
            this.crlids = CrlListID.getInstance(aSN1TaggedObject.getObject());
        }
    }

    public CrlOcspRef(CrlListID crlListID, OcspListID ocspListID, OtherRevRefs otherRevRefs) {
        this.crlids = crlListID;
        this.ocspids = ocspListID;
        this.otherRev = otherRevRefs;
    }

    public CrlListID getCrlids() {
        return this.crlids;
    }

    public OcspListID getOcspids() {
        return this.ocspids;
    }

    public OtherRevRefs getOtherRev() {
        return this.otherRev;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(3);
        ASN1Object aSN1Object = ((CrlOcspRef)aSN1Object2).crlids;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            aSN1Object = ((CrlListID)aSN1Object).toASN1Primitive();
            dERTaggedObject2 = new DERTaggedObject(true, 0, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Object = ((CrlOcspRef)aSN1Object2).ocspids) != null) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            aSN1Object = ((OcspListID)aSN1Object).toASN1Primitive();
            dERTaggedObject3 = new DERTaggedObject(true, 1, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Object2 = ((CrlOcspRef)aSN1Object2).otherRev) != null) {
            DERTaggedObject dERTaggedObject4;
            aSN1Object = dERTaggedObject4;
            ASN1Object aSN1Object2 = ((OtherRevRefs)aSN1Object2).toASN1Primitive();
            dERTaggedObject4 = new DERTaggedObject(true, 2, aSN1Object2);
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

