/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.esf;

import b.a;
import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.esf.CrlIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.esf.OtherHash;

public class CrlValidatedID
extends ASN1Object {
    private OtherHash crlHash;
    private CrlIdentifier crlIdentifier;

    public static CrlValidatedID getInstance(Object object) {
        if (object instanceof CrlValidatedID) {
            return (CrlValidatedID)object;
        }
        if (object != null) {
            return new CrlValidatedID(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private CrlValidatedID(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() >= 1 && aSN1Sequence.size() <= 2) {
            this.crlHash = OtherHash.getInstance(aSN1Sequence.getObjectAt(0));
            if (aSN1Sequence.size() > 1) {
                this.crlIdentifier = CrlIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
            }
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, a.a("Bad sequence size: ")));
    }

    public CrlValidatedID(OtherHash otherHash) {
        this(otherHash, null);
    }

    public CrlValidatedID(OtherHash otherHash, CrlIdentifier crlIdentifier) {
        this.crlHash = otherHash;
        this.crlIdentifier = crlIdentifier;
    }

    public OtherHash getCrlHash() {
        return this.crlHash;
    }

    public CrlIdentifier getCrlIdentifier() {
        return this.crlIdentifier;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(2);
        aSN1EncodableVector.add(((CrlValidatedID)aSN1Object).crlHash.toASN1Primitive());
        ASN1Object aSN1Object = ((CrlValidatedID)aSN1Object).crlIdentifier;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(((CrlIdentifier)aSN1Object).toASN1Primitive());
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

