/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.icao;

import b.a;
import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSet;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate;

public class CscaMasterList
extends ASN1Object {
    private ASN1Integer version;
    private Certificate[] certList;

    public static CscaMasterList getInstance(Object object) {
        if (object instanceof CscaMasterList) {
            return (CscaMasterList)object;
        }
        if (object != null) {
            return new CscaMasterList(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private CscaMasterList(ASN1Sequence aSN1Primitive) {
        ASN1Integer aSN1Integer;
        ASN1Integer aSN1Integer2 = aSN1Integer;
        aSN1Integer = new ASN1Integer(0L);
        this.version = aSN1Integer2;
        if (aSN1Primitive != null && ((ASN1Sequence)aSN1Primitive).size() != 0) {
            if (((ASN1Sequence)aSN1Primitive).size() == 2) {
                this.version = ASN1Integer.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(0));
                aSN1Primitive = ASN1Set.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(1));
                this.certList = new Certificate[((ASN1Set)aSN1Primitive).size()];
                int n = 0;
                while (true) {
                    Certificate[] certificateArray = this.certList;
                    if (n >= this.certList.length) break;
                    certificateArray[n] = Certificate.getInstance(((ASN1Set)aSN1Primitive).getObjectAt(n));
                    ++n;
                }
                return;
            }
            throw new IllegalArgumentException(b.a((ASN1Sequence)aSN1Primitive, a.a("Incorrect sequence size: ")));
        }
        throw new IllegalArgumentException("null or empty sequence passed.");
    }

    public CscaMasterList(Certificate[] certificateArray) {
        this.version = new ASN1Integer(0L);
        this.certList = this.copyCertList(certificateArray);
    }

    private Certificate[] copyCertList(Certificate[] certificateArray) {
        int n = certificateArray.length;
        Certificate[] certificateArray2 = new Certificate[n];
        for (int k = 0; k != n; ++k) {
            certificateArray2[k] = certificateArray[k];
        }
        return certificateArray2;
    }

    public int getVersion() {
        return this.version.intValueExact();
    }

    public Certificate[] getCertStructs() {
        CscaMasterList cscaMasterList = this;
        return cscaMasterList.copyCertList(cscaMasterList.certList);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(2);
        aSN1EncodableVector.add(this.version);
        aSN1EncodableVector.add(new DERSet(this.certList));
        return new DERSequence(aSN1EncodableVector2);
    }
}

