/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.isismtt.x509;

import b.a;
import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.isismtt.x509.Admissions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import java.util.Enumeration;

public class AdmissionSyntax
extends ASN1Object {
    private GeneralName admissionAuthority;
    private ASN1Sequence contentsOfAdmissions;

    public static AdmissionSyntax getInstance(Object object) {
        if (object != null && !(object instanceof AdmissionSyntax)) {
            if (object instanceof ASN1Sequence) {
                return new AdmissionSyntax((ASN1Sequence)object);
            }
            throw new IllegalArgumentException(c.a(object, a.a("illegal object in getInstance: ")));
        }
        return (AdmissionSyntax)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AdmissionSyntax(ASN1Sequence aSN1Sequence) {
        int n = aSN1Sequence.size();
        if (n != 1) {
            if (n != 2) throw new IllegalArgumentException(b.a(aSN1Sequence, a.a("Bad sequence size: ")));
            this.admissionAuthority = GeneralName.getInstance(aSN1Sequence.getObjectAt(0));
            this.contentsOfAdmissions = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
            return;
        } else {
            this.contentsOfAdmissions = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(0));
        }
    }

    public AdmissionSyntax(GeneralName generalName, ASN1Sequence aSN1Sequence) {
        this.admissionAuthority = generalName;
        this.contentsOfAdmissions = aSN1Sequence;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(2);
        GeneralName generalName = this.admissionAuthority;
        if (generalName != null) {
            aSN1EncodableVector2.add(generalName);
        }
        aSN1EncodableVector2.add(this.contentsOfAdmissions);
        return new DERSequence(aSN1EncodableVector2);
    }

    public GeneralName getAdmissionAuthority() {
        return this.admissionAuthority;
    }

    public Admissions[] getContentsOfAdmissions() {
        Admissions[] admissionsArray = new Admissions[admissionsArray.contentsOfAdmissions.size()];
        int n = 0;
        Enumeration enumeration = admissionsArray.contentsOfAdmissions.getObjects();
        while (enumeration.hasMoreElements()) {
            admissionsArray[n++] = Admissions.getInstance(enumeration.nextElement());
        }
        return admissionsArray;
    }
}

