/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ocsp;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERIA5String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b;

public class CrlID
extends ASN1Object {
    private DERIA5String crlUrl;
    private ASN1Integer crlNum;
    private ASN1GeneralizedTime crlTime;

    private CrlID(ASN1Sequence object) {
        object = ((ASN1Sequence)object).getObjects();
        while (object.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object.nextElement();
            int n = aSN1TaggedObject.getTagNo();
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        this.crlTime = ASN1GeneralizedTime.getInstance(aSN1TaggedObject, true);
                        continue;
                    }
                    throw new IllegalArgumentException(b.a(aSN1TaggedObject, a.a("unknown tag number: ")));
                }
                this.crlNum = ASN1Integer.getInstance(aSN1TaggedObject, true);
                continue;
            }
            this.crlUrl = DERIA5String.getInstance(aSN1TaggedObject, true);
        }
    }

    public static CrlID getInstance(Object object) {
        if (object instanceof CrlID) {
            return (CrlID)object;
        }
        if (object != null) {
            return new CrlID(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public DERIA5String getCrlUrl() {
        return this.crlUrl;
    }

    public ASN1Integer getCrlNum() {
        return this.crlNum;
    }

    public ASN1GeneralizedTime getCrlTime() {
        return this.crlTime;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1GeneralizedTime aSN1GeneralizedTime;
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(3);
        ASN1Primitive aSN1Primitive = this.crlUrl;
        if (aSN1Primitive != null) {
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            dERTaggedObject2 = new DERTaggedObject(true, 0, aSN1Primitive);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Primitive = this.crlNum) != null) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            dERTaggedObject3 = new DERTaggedObject(true, 1, aSN1Primitive);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1GeneralizedTime = this.crlTime) != null) {
            DERTaggedObject dERTaggedObject4;
            aSN1Primitive = dERTaggedObject4;
            dERTaggedObject4 = new DERTaggedObject(true, 2, aSN1GeneralizedTime);
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

