/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Boolean;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp.Accuracy;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.tsp.MessageImprint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;

public class TSTInfo
extends ASN1Object {
    private ASN1Integer version;
    private ASN1ObjectIdentifier tsaPolicyId;
    private MessageImprint messageImprint;
    private ASN1Integer serialNumber;
    private ASN1GeneralizedTime genTime;
    private Accuracy accuracy;
    private ASN1Boolean ordering;
    private ASN1Integer nonce;
    private GeneralName tsa;
    private Extensions extensions;

    public static TSTInfo getInstance(Object object) {
        if (object instanceof TSTInfo) {
            return (TSTInfo)object;
        }
        if (object != null) {
            return new TSTInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private TSTInfo(ASN1Sequence object) {
        TSTInfo tSTInfo = this;
        object = ((ASN1Sequence)object).getObjects();
        tSTInfo.version = ASN1Integer.getInstance(object.nextElement());
        tSTInfo.tsaPolicyId = ASN1ObjectIdentifier.getInstance(object.nextElement());
        tSTInfo.messageImprint = MessageImprint.getInstance(object.nextElement());
        tSTInfo.serialNumber = ASN1Integer.getInstance(object.nextElement());
        tSTInfo.genTime = ASN1GeneralizedTime.getInstance(object.nextElement());
        tSTInfo.ordering = ASN1Boolean.getInstance(false);
        while (object.hasMoreElements()) {
            ASN1Object aSN1Object = (ASN1Object)object.nextElement();
            if (aSN1Object instanceof ASN1TaggedObject) {
                int n = ((ASN1TaggedObject)(aSN1Object = (ASN1TaggedObject)aSN1Object)).getTagNo();
                if (n != 0) {
                    if (n == 1) {
                        this.extensions = Extensions.getInstance((ASN1TaggedObject)aSN1Object, false);
                        continue;
                    }
                    throw new IllegalArgumentException(b.a((ASN1TaggedObject)aSN1Object, a.a("Unknown tag value ")));
                }
                this.tsa = GeneralName.getInstance((ASN1TaggedObject)aSN1Object, true);
                continue;
            }
            if (!(aSN1Object instanceof ASN1Sequence) && !(aSN1Object instanceof Accuracy)) {
                if (aSN1Object instanceof ASN1Boolean) {
                    this.ordering = ASN1Boolean.getInstance(aSN1Object);
                    continue;
                }
                if (!(aSN1Object instanceof ASN1Integer)) continue;
                this.nonce = ASN1Integer.getInstance(aSN1Object);
                continue;
            }
            this.accuracy = Accuracy.getInstance(aSN1Object);
        }
    }

    public TSTInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier, MessageImprint messageImprint, ASN1Integer aSN1Integer, ASN1GeneralizedTime aSN1GeneralizedTime, Accuracy accuracy, ASN1Boolean aSN1Boolean, ASN1Integer aSN1Integer2, GeneralName generalName, Extensions extensions) {
        ASN1Integer aSN1Integer3;
        ASN1Object aSN1Object = aSN1Integer3;
        aSN1Integer3 = new ASN1Integer(1L);
        v1.version = aSN1Object;
        v1.tsaPolicyId = aSN1ObjectIdentifier;
        v1.messageImprint = messageImprint;
        v1.serialNumber = aSN1Integer;
        v1.genTime = aSN1GeneralizedTime;
        v1.accuracy = accuracy;
        v1.ordering = aSN1Boolean;
        v1.nonce = aSN1Integer2;
        v1.tsa = generalName;
        v1.extensions = extensions;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public ASN1ObjectIdentifier getPolicy() {
        return this.tsaPolicyId;
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public Accuracy getAccuracy() {
        return this.accuracy;
    }

    public ASN1GeneralizedTime getGenTime() {
        return this.genTime;
    }

    public ASN1Boolean getOrdering() {
        return this.ordering;
    }

    public ASN1Integer getNonce() {
        return this.nonce;
    }

    public GeneralName getTsa() {
        return this.tsa;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        Extensions extensions;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(10);
        aSN1EncodableVector2.add(this.version);
        aSN1EncodableVector2.add(this.tsaPolicyId);
        aSN1EncodableVector2.add(this.messageImprint);
        aSN1EncodableVector2.add(this.serialNumber);
        aSN1EncodableVector.add(this.genTime);
        ASN1Object aSN1Object = this.accuracy;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        if ((aSN1Object = this.ordering) != null && ((ASN1Boolean)aSN1Object).isTrue()) {
            aSN1EncodableVector2.add(this.ordering);
        }
        if ((aSN1Object = this.nonce) != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        if ((aSN1Object = this.tsa) != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, 0, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        if ((extensions = this.extensions) != null) {
            DERTaggedObject dERTaggedObject;
            aSN1Object = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(false, 1, extensions);
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

