/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1BitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DistributionPointName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.ReasonFlags;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;

public class DistributionPoint
extends ASN1Object {
    public DistributionPointName distributionPoint;
    public ReasonFlags reasons;
    public GeneralNames cRLIssuer;

    public static DistributionPoint getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DistributionPoint.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static DistributionPoint getInstance(Object object) {
        if (object != null && !(object instanceof DistributionPoint)) {
            if (object instanceof ASN1Sequence) {
                return new DistributionPoint((ASN1Sequence)object);
            }
            throw new IllegalArgumentException(c.a(object, a.a("Invalid DistributionPoint: ")));
        }
        return (DistributionPoint)object;
    }

    public DistributionPoint(ASN1Sequence aSN1Sequence) {
        for (int k = 0; k != aSN1Sequence.size(); ++k) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(k));
            int n = aSN1TaggedObject.getTagNo();
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        this.cRLIssuer = GeneralNames.getInstance(aSN1TaggedObject, false);
                        continue;
                    }
                    throw new IllegalArgumentException(b.a(aSN1TaggedObject, a.a("Unknown tag encountered in structure: ")));
                }
                this.reasons = new ReasonFlags(DERBitString.getInstance(aSN1TaggedObject, false));
                continue;
            }
            this.distributionPoint = DistributionPointName.getInstance(aSN1TaggedObject, true);
        }
    }

    public DistributionPoint(DistributionPointName distributionPointName, ReasonFlags reasonFlags, GeneralNames generalNames) {
        this.distributionPoint = distributionPointName;
        this.reasons = reasonFlags;
        this.cRLIssuer = generalNames;
    }

    private void appendObject(StringBuffer stringBuffer, String string, String string2, String string3) {
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer2.append("    ");
        stringBuffer2.append(string2);
        stringBuffer2.append(":");
        stringBuffer2.append(string);
        stringBuffer2.append("    ");
        stringBuffer2.append("    ");
        stringBuffer2.append(string3);
        stringBuffer2.append(string);
    }

    public DistributionPointName getDistributionPoint() {
        return this.distributionPoint;
    }

    public ReasonFlags getReasons() {
        return this.reasons;
    }

    public GeneralNames getCRLIssuer() {
        return this.cRLIssuer;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        GeneralNames generalNames;
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(3);
        ASN1Object aSN1Object = this.distributionPoint;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            dERTaggedObject2 = new DERTaggedObject(0, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((aSN1Object = this.reasons) != null) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            dERTaggedObject3 = new DERTaggedObject(false, 1, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((generalNames = this.cRLIssuer) != null) {
            DERTaggedObject dERTaggedObject4;
            aSN1Object = dERTaggedObject4;
            dERTaggedObject4 = new DERTaggedObject(false, 2, generalNames);
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }

    public String toString() {
        StringBuffer stringBuffer;
        String string = Strings.lineSeparator();
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append("DistributionPoint: [");
        stringBuffer2.append(string);
        Object object = ((DistributionPoint)((Object)string2)).distributionPoint;
        if (object != null) {
            object = ((DistributionPointName)object).toString();
            ((DistributionPoint)((Object)string2)).appendObject(stringBuffer2, string, "distributionPoint", (String)object);
        }
        if ((object = ((DistributionPoint)((Object)string2)).reasons) != null) {
            object = ((ASN1BitString)object).toString();
            ((DistributionPoint)((Object)string2)).appendObject(stringBuffer2, string, "reasons", (String)object);
        }
        if ((object = ((DistributionPoint)((Object)string2)).cRLIssuer) != null) {
            DistributionPoint distributionPoint = string2;
            String string2 = ((GeneralNames)object).toString();
            distributionPoint.appendObject(stringBuffer2, string, "cRLIssuer", string2);
        }
        StringBuffer stringBuffer3 = stringBuffer2;
        stringBuffer2.append("]");
        stringBuffer3.append(string);
        return stringBuffer3.toString();
    }
}

