/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import b.a;
import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Boolean;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.j;
import java.io.IOException;

public class Extension
extends ASN1Object {
    public static final ASN1ObjectIdentifier subjectDirectoryAttributes = e.a.a("2.5.29.9");
    public static final ASN1ObjectIdentifier subjectKeyIdentifier = e.a.a("2.5.29.14");
    public static final ASN1ObjectIdentifier keyUsage = e.a.a("2.5.29.15");
    public static final ASN1ObjectIdentifier privateKeyUsagePeriod = e.a.a("2.5.29.16");
    public static final ASN1ObjectIdentifier subjectAlternativeName = e.a.a("2.5.29.17");
    public static final ASN1ObjectIdentifier issuerAlternativeName = e.a.a("2.5.29.18");
    public static final ASN1ObjectIdentifier basicConstraints = e.a.a("2.5.29.19");
    public static final ASN1ObjectIdentifier cRLNumber = e.a.a("2.5.29.20");
    public static final ASN1ObjectIdentifier reasonCode = e.a.a("2.5.29.21");
    public static final ASN1ObjectIdentifier instructionCode = e.a.a("2.5.29.23");
    public static final ASN1ObjectIdentifier invalidityDate = e.a.a("2.5.29.24");
    public static final ASN1ObjectIdentifier deltaCRLIndicator = e.a.a("2.5.29.27");
    public static final ASN1ObjectIdentifier issuingDistributionPoint = e.a.a("2.5.29.28");
    public static final ASN1ObjectIdentifier certificateIssuer = e.a.a("2.5.29.29");
    public static final ASN1ObjectIdentifier nameConstraints = e.a.a("2.5.29.30");
    public static final ASN1ObjectIdentifier cRLDistributionPoints = e.a.a("2.5.29.31");
    public static final ASN1ObjectIdentifier certificatePolicies = e.a.a("2.5.29.32");
    public static final ASN1ObjectIdentifier policyMappings = e.a.a("2.5.29.33");
    public static final ASN1ObjectIdentifier authorityKeyIdentifier = e.a.a("2.5.29.35");
    public static final ASN1ObjectIdentifier policyConstraints = e.a.a("2.5.29.36");
    public static final ASN1ObjectIdentifier extendedKeyUsage = e.a.a("2.5.29.37");
    public static final ASN1ObjectIdentifier freshestCRL = e.a.a("2.5.29.46");
    public static final ASN1ObjectIdentifier inhibitAnyPolicy = e.a.a("2.5.29.54");
    public static final ASN1ObjectIdentifier authorityInfoAccess = e.a.a("1.3.6.1.5.5.7.1.1");
    public static final ASN1ObjectIdentifier subjectInfoAccess = e.a.a("1.3.6.1.5.5.7.1.11");
    public static final ASN1ObjectIdentifier logoType = e.a.a("1.3.6.1.5.5.7.1.12");
    public static final ASN1ObjectIdentifier biometricInfo = e.a.a("1.3.6.1.5.5.7.1.2");
    public static final ASN1ObjectIdentifier qCStatements = e.a.a("1.3.6.1.5.5.7.1.3");
    public static final ASN1ObjectIdentifier auditIdentity = e.a.a("1.3.6.1.5.5.7.1.4");
    public static final ASN1ObjectIdentifier noRevAvail = e.a.a("2.5.29.56");
    public static final ASN1ObjectIdentifier targetInformation = e.a.a("2.5.29.55");
    public static final ASN1ObjectIdentifier expiredCertsOnCRL = e.a.a("2.5.29.60");
    private ASN1ObjectIdentifier extnId;
    private boolean critical;
    private ASN1OctetString value;

    public Extension(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Boolean aSN1Boolean, ASN1OctetString aSN1OctetString) {
        this(aSN1ObjectIdentifier, aSN1Boolean.isTrue(), aSN1OctetString);
    }

    public Extension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, byte[] byArray) {
        DEROctetString dEROctetString;
        Extension extension = aSN1Object;
        ASN1Object aSN1Object = dEROctetString;
        dEROctetString = new DEROctetString(byArray);
        extension(aSN1ObjectIdentifier, bl, (ASN1OctetString)aSN1Object);
    }

    public Extension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, ASN1OctetString aSN1OctetString) {
        this.extnId = aSN1ObjectIdentifier;
        this.critical = bl;
        this.value = aSN1OctetString;
    }

    public static Extension create(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, ASN1Encodable aSN1Encodable) {
        return new Extension(aSN1ObjectIdentifier, bl, aSN1Encodable.toASN1Primitive().getEncoded());
    }

    private Extension(ASN1Sequence aSN1Sequence) {
        block4: {
            block3: {
                block2: {
                    if (aSN1Sequence.size() != 2) break block2;
                    Extension extension = this;
                    extension.extnId = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
                    extension.critical = false;
                    this.value = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1));
                    break block3;
                }
                if (aSN1Sequence.size() != 3) break block4;
                this.extnId = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
                this.critical = ASN1Boolean.getInstance(aSN1Sequence.getObjectAt(1)).isTrue();
                this.value = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(2));
            }
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, a.a("Bad sequence size: ")));
    }

    public static Extension getInstance(Object object) {
        if (object instanceof Extension) {
            return (Extension)object;
        }
        if (object != null) {
            return new Extension(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private static ASN1Primitive convertValueToObject(Extension extension) {
        try {
            return ASN1Primitive.fromByteArray(extension.getExtnValue().getOctets());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(j.a("can't convert extension: ", iOException));
        }
    }

    public ASN1ObjectIdentifier getExtnId() {
        return this.extnId;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public ASN1OctetString getExtnValue() {
        return this.value;
    }

    public ASN1Encodable getParsedValue() {
        return Extension.convertValueToObject(this);
    }

    @Override
    public int hashCode() {
        if (this.isCritical()) {
            return this.getExtnValue().hashCode() ^ this.getExtnId().hashCode();
        }
        return ~(this.getExtnValue().hashCode() ^ this.getExtnId().hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Extension)) {
            return false;
        }
        return ((Extension)(object = (Extension)object)).getExtnId().equals(this.getExtnId()) && ((Extension)object).getExtnValue().equals(this.getExtnValue()) && ((Extension)object).isCritical() == this.isCritical();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector.add(this.extnId);
        if (this.critical) {
            aSN1EncodableVector2.add(ASN1Boolean.getInstance(true));
        }
        aSN1EncodableVector2.add(this.value);
        return new DERSequence(aSN1EncodableVector2);
    }
}

