/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import b.a;
import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.IssuerSerial;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.ObjectDigestInfo;

public class Holder
extends ASN1Object {
    public static final int V1_CERTIFICATE_HOLDER = 0;
    public static final int V2_CERTIFICATE_HOLDER = 1;
    public IssuerSerial baseCertificateID;
    public GeneralNames entityName;
    public ObjectDigestInfo objectDigestInfo;
    private int version;

    public static Holder getInstance(Object object) {
        if (object instanceof Holder) {
            return (Holder)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return new Holder(ASN1TaggedObject.getInstance(object));
        }
        if (object != null) {
            return new Holder(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Holder(ASN1TaggedObject aSN1TaggedObject) {
        this.version = 1;
        int n = aSN1TaggedObject.getTagNo();
        if (n != 0) {
            if (n != 1) throw new IllegalArgumentException("unknown tag in Holder");
            this.entityName = GeneralNames.getInstance(aSN1TaggedObject, true);
        } else {
            this.baseCertificateID = IssuerSerial.getInstance(aSN1TaggedObject, true);
        }
        this.version = 0;
    }

    private Holder(ASN1Sequence aSN1Sequence) {
        this.version = 1;
        if (aSN1Sequence.size() <= 3) {
            for (int k = 0; k != aSN1Sequence.size(); ++k) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(k));
                int n = aSN1TaggedObject.getTagNo();
                if (n != 0) {
                    if (n != 1) {
                        if (n == 2) {
                            this.objectDigestInfo = ObjectDigestInfo.getInstance(aSN1TaggedObject, false);
                            continue;
                        }
                        throw new IllegalArgumentException("unknown tag in Holder");
                    }
                    this.entityName = GeneralNames.getInstance(aSN1TaggedObject, false);
                    continue;
                }
                this.baseCertificateID = IssuerSerial.getInstance(aSN1TaggedObject, false);
            }
            this.version = 1;
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, a.a("Bad sequence size: ")));
    }

    public Holder(IssuerSerial issuerSerial) {
        this(issuerSerial, 1);
    }

    public Holder(IssuerSerial issuerSerial, int n) {
        this.baseCertificateID = issuerSerial;
        this.version = n;
    }

    public Holder(GeneralNames generalNames) {
        this(generalNames, 1);
    }

    public Holder(GeneralNames generalNames, int n) {
        this.entityName = generalNames;
        this.version = n;
    }

    public Holder(ObjectDigestInfo objectDigestInfo) {
        this.version = 1;
        this.objectDigestInfo = objectDigestInfo;
    }

    public int getVersion() {
        return this.version;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.baseCertificateID;
    }

    public GeneralNames getEntityName() {
        return this.entityName;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.objectDigestInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (aSN1Object.version == 1) {
            DERTaggedObject dERTaggedObject;
            ASN1EncodableVector aSN1EncodableVector;
            ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
            aSN1EncodableVector = new ASN1EncodableVector(3);
            ASN1Object aSN1Object = aSN1Object.baseCertificateID;
            if (aSN1Object != null) {
                DERTaggedObject dERTaggedObject2;
                dERTaggedObject = dERTaggedObject2;
                dERTaggedObject2 = new DERTaggedObject(false, 0, aSN1Object);
                aSN1EncodableVector2.add(dERTaggedObject);
            }
            if ((aSN1Object = aSN1Object.entityName) != null) {
                DERTaggedObject dERTaggedObject3;
                dERTaggedObject = dERTaggedObject3;
                dERTaggedObject3 = new DERTaggedObject(false, 1, aSN1Object);
                aSN1EncodableVector2.add(dERTaggedObject);
            }
            if ((aSN1Object = aSN1Object.objectDigestInfo) != null) {
                DERTaggedObject dERTaggedObject4;
                aSN1Object = dERTaggedObject4;
                dERTaggedObject4 = new DERTaggedObject(false, 2, aSN1Object);
                aSN1EncodableVector2.add(aSN1Object);
            }
            return new DERSequence(aSN1EncodableVector2);
        }
        GeneralNames generalNames = aSN1Object.entityName;
        if (generalNames != null) {
            return new DERTaggedObject(true, 1, generalNames);
        }
        ASN1Object aSN1Object = aSN1Object.baseCertificateID;
        return new DERTaggedObject(true, 0, aSN1Object);
    }
}

