/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import b.a;
import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import java.math.BigInteger;
import java.util.Enumeration;

public class RSAPublicKeyStructure
extends ASN1Object {
    private BigInteger modulus;
    private BigInteger publicExponent;

    public static RSAPublicKeyStructure getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RSAPublicKeyStructure.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static RSAPublicKeyStructure getInstance(Object object) {
        if (object != null && !(object instanceof RSAPublicKeyStructure)) {
            if (object instanceof ASN1Sequence) {
                return new RSAPublicKeyStructure((ASN1Sequence)object);
            }
            throw new IllegalArgumentException(c.a(object, a.a("Invalid RSAPublicKeyStructure: ")));
        }
        return (RSAPublicKeyStructure)object;
    }

    public RSAPublicKeyStructure(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
    }

    public RSAPublicKeyStructure(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 2) {
            RSAPublicKeyStructure rSAPublicKeyStructure = enumeration;
            Enumeration enumeration = aSN1Sequence.getObjects();
            rSAPublicKeyStructure.modulus = ASN1Integer.getInstance(enumeration.nextElement()).getPositiveValue();
            rSAPublicKeyStructure.publicExponent = ASN1Integer.getInstance(enumeration.nextElement()).getPositiveValue();
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, a.a("Bad sequence size: ")));
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        new ASN1EncodableVector(2).add(new ASN1Integer(this.getModulus()));
        aSN1EncodableVector2.add(new ASN1Integer(this.getPublicExponent()));
        return new DERSequence(aSN1EncodableVector2);
    }
}

