/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import b.a;
import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;

public class RoleSyntax
extends ASN1Object {
    private GeneralNames roleAuthority;
    private GeneralName roleName;

    public static RoleSyntax getInstance(Object object) {
        if (object instanceof RoleSyntax) {
            return (RoleSyntax)object;
        }
        if (object != null) {
            return new RoleSyntax(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public RoleSyntax(GeneralNames generalNames, GeneralName generalName) {
        if (generalName != null && generalName.getTagNo() == 6 && !((ASN1String)((Object)generalName.getName())).getString().equals("")) {
            RoleSyntax roleSyntax = this;
            roleSyntax.roleAuthority = generalNames;
            roleSyntax.roleName = generalName;
            return;
        }
        throw new IllegalArgumentException("the role name MUST be non empty and MUST use the URI option of GeneralName");
    }

    public RoleSyntax(GeneralName generalName) {
        this(null, generalName);
    }

    public RoleSyntax(String string) {
        int n = 6;
        if (string == null) {
            string = "";
        }
        GeneralName generalName = new GeneralName(n, string);
        this(generalName);
    }

    private RoleSyntax(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() >= 1 && aSN1Sequence.size() <= 2) {
            for (int k = 0; k != aSN1Sequence.size(); ++k) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(k));
                int n = aSN1TaggedObject.getTagNo();
                if (n != 0) {
                    if (n == 1) {
                        this.roleName = GeneralName.getInstance(aSN1TaggedObject, true);
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown tag in RoleSyntax");
                }
                this.roleAuthority = GeneralNames.getInstance(aSN1TaggedObject, false);
            }
            return;
        }
        throw new IllegalArgumentException(b.a(aSN1Sequence, a.a("Bad sequence size: ")));
    }

    public GeneralNames getRoleAuthority() {
        return this.roleAuthority;
    }

    public GeneralName getRoleName() {
        return this.roleName;
    }

    public String getRoleNameAsString() {
        return ((ASN1String)((Object)this.roleName.getName())).getString();
    }

    public String[] getRoleAuthorityAsString() {
        ASN1Object aSN1Object = ((RoleSyntax)aSN1Object).roleAuthority;
        if (aSN1Object == null) {
            return new String[0];
        }
        aSN1Object = ((GeneralNames)aSN1Object).getNames();
        String[] stringArray = new String[((GeneralName[])aSN1Object).length];
        for (int k = 0; k < ((ASN1Object)aSN1Object).length; ++k) {
            ASN1Encodable aSN1Encodable = ((GeneralName)aSN1Object[k]).getName();
            stringArray[k] = aSN1Encodable instanceof ASN1String ? ((ASN1String)((Object)aSN1Encodable)).getString() : aSN1Encodable.toString();
        }
        return stringArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(2);
        ASN1Object aSN1Object = aSN1Object2.roleAuthority;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject2;
            DERTaggedObject dERTaggedObject3 = dERTaggedObject2;
            dERTaggedObject2 = new DERTaggedObject(false, 0, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject3);
        }
        aSN1Object = dERTaggedObject;
        ASN1Object aSN1Object2 = aSN1Object2.roleName;
        dERTaggedObject = new DERTaggedObject(true, 1, aSN1Object2);
        aSN1EncodableVector2.add(aSN1Object);
        return new DERSequence(aSN1EncodableVector2);
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer(a.a("Name: ").append(stringArray.getRoleNameAsString()).append(" - Auth: ").toString());
        GeneralNames generalNames = stringArray.roleAuthority;
        if (generalNames != null && generalNames.getNames().length != 0) {
            String[] stringArray = stringArray.getRoleAuthorityAsString();
            stringBuffer2.append('[').append(stringArray[0]);
            for (int k = 1; k < stringArray.length; ++k) {
                stringBuffer2.append(", ").append(stringArray[k]);
            }
            stringBuffer2.append(']');
        } else {
            stringBuffer2.append("N/A");
        }
        return stringBuffer2.toString();
    }
}

