/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BasicAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import java.math.BigInteger;

public class DHBasicAgreement
implements BasicAgreement {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DHPrivateKeyParameters key;
    private DHParameters dhParams;

    @Override
    public void init(CipherParameters cipherParameters) {
        if ((cipherParameters = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters) instanceof DHPrivateKeyParameters) {
            DHBasicAgreement dHBasicAgreement = dHPrivateKeyParameters;
            DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)cipherParameters;
            dHBasicAgreement.key = dHPrivateKeyParameters;
            dHBasicAgreement.dhParams = dHPrivateKeyParameters.getParameters();
            return;
        }
        throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getP().bitLength() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters object) {
        if (((DHKeyParameters)(object = (DHPublicKeyParameters)object)).getParameters().equals(((DHBasicAgreement)((Object)bigInteger3)).dhParams)) {
            BigInteger bigInteger;
            CipherParameters cipherParameters = object;
            object = ((DHBasicAgreement)((Object)bigInteger3)).dhParams.getP();
            BigInteger bigInteger2 = ((DHPublicKeyParameters)cipherParameters).getY();
            if (bigInteger2 != null && bigInteger2.compareTo(bigInteger = ONE) > 0 && bigInteger2.compareTo(((BigInteger)object).subtract(bigInteger)) < 0) {
                BigInteger bigInteger3 = bigInteger2.modPow(((DHBasicAgreement)((Object)bigInteger3)).key.getX(), (BigInteger)object);
                if (!bigInteger3.equals(bigInteger)) {
                    return bigInteger3;
                }
                throw new IllegalStateException("Shared key can't be 1");
            }
            throw new IllegalArgumentException("Diffie-Hellman public key is weak");
        }
        throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
    }
}

