/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BasicAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.MQVPrivateParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.MQVPublicParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Properties;
import java.math.BigInteger;

public class ECMQVBasicAgreement
implements BasicAgreement {
    public MQVPrivateParameters privParams;

    private ECPoint calculateMqvAgreement(ECDomainParameters object, ECPrivateKeyParameters object2, ECPrivateKeyParameters eCPrivateKeyParameters, ECPublicKeyParameters object3, ECPublicKeyParameters object4, ECPublicKeyParameters eCPublicKeyParameters) {
        ECDomainParameters eCDomainParameters = object;
        BigInteger bigInteger = eCDomainParameters.getN();
        int n = (bigInteger.bitLength() + 1) / 2;
        BigInteger bigInteger2 = ECConstants.ONE.shiftLeft(n);
        ECCurve eCCurve = eCDomainParameters.getCurve();
        object3 = ECAlgorithms.cleanPoint(eCCurve, ((ECPublicKeyParameters)object3).getQ());
        ECPoint eCPoint = ECAlgorithms.cleanPoint(eCCurve, ((ECPublicKeyParameters)object4).getQ());
        object4 = ECAlgorithms.cleanPoint(eCCurve, eCPublicKeyParameters.getQ());
        ECPrivateKeyParameters eCPrivateKeyParameters2 = object2;
        object2 = ((ECPoint)object3).getAffineXCoord().toBigInteger().mod(bigInteger2).setBit(n);
        object2 = eCPrivateKeyParameters2.getD().multiply((BigInteger)object2).add(eCPrivateKeyParameters.getD()).mod(bigInteger);
        object = ((ECDomainParameters)object).getH().multiply((BigInteger)object2).mod(bigInteger);
        return ECAlgorithms.sumOfTwoMultiplies(eCPoint, ((ECPoint)object4).getAffineXCoord().toBigInteger().mod(bigInteger2).setBit(n).multiply((BigInteger)object).mod(bigInteger), (ECPoint)object4, (BigInteger)object);
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        this.privParams = (MQVPrivateParameters)cipherParameters;
    }

    @Override
    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        if (!Properties.isOverrideSet("com.fis.ekyc.nfc.build_in.bouncycastle.ec.disable_mqv")) {
            cipherParameters = (MQVPublicParameters)cipherParameters;
            ECPrivateKeyParameters eCPrivateKeyParameters = ((ECMQVBasicAgreement)object2).privParams.getStaticPrivateKey();
            Object object = eCPrivateKeyParameters.getParameters();
            if (((ECDomainParameters)object).equals(((MQVPublicParameters)cipherParameters).getStaticPublicKey().getParameters())) {
                ECPublicKeyParameters eCPublicKeyParameters;
                ECMQVBasicAgreement eCMQVBasicAgreement = object2;
                CipherParameters cipherParameters2 = cipherParameters;
                ECMQVBasicAgreement eCMQVBasicAgreement2 = object2;
                Object object2 = eCMQVBasicAgreement2.privParams.getEphemeralPrivateKey();
                cipherParameters = eCMQVBasicAgreement2.privParams.getEphemeralPublicKey();
                if (!((ECPoint)(object2 = eCMQVBasicAgreement.calculateMqvAgreement((ECDomainParameters)object, eCPrivateKeyParameters, (ECPrivateKeyParameters)object2, (ECPublicKeyParameters)cipherParameters, (ECPublicKeyParameters)(object = ((MQVPublicParameters)cipherParameters2).getStaticPublicKey()), eCPublicKeyParameters = ((MQVPublicParameters)cipherParameters2).getEphemeralPublicKey()).normalize())).isInfinity()) {
                    return ((ECPoint)object2).getAffineXCoord().toBigInteger();
                }
                throw new IllegalStateException("Infinity is not a valid agreement value for MQV");
            }
            throw new IllegalStateException("ECMQV public key components have wrong domain parameters");
        }
        throw new IllegalStateException("ECMQV explicitly disabled");
    }
}

