/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DigestDerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.KDF2BytesGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.io.IOException;

public class ECDHKEKGenerator
implements DigestDerivationFunction {
    private DigestDerivationFunction kdf;
    private ASN1ObjectIdentifier algorithm;
    private int keySize;
    private byte[] z;

    public ECDHKEKGenerator(Digest digest) {
        KDF2BytesGenerator kDF2BytesGenerator;
        DigestDerivationFunction digestDerivationFunction = kDF2BytesGenerator;
        kDF2BytesGenerator = new KDF2BytesGenerator(digest);
        v1.kdf = digestDerivationFunction;
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        ECDHKEKGenerator eCDHKEKGenerator = dHKDFParameters;
        DHKDFParameters dHKDFParameters = (DHKDFParameters)derivationParameters;
        eCDHKEKGenerator.algorithm = dHKDFParameters.getAlgorithm();
        eCDHKEKGenerator.keySize = dHKDFParameters.getKeySize();
        eCDHKEKGenerator.z = dHKDFParameters.getZ();
    }

    @Override
    public Digest getDigest() {
        return this.kdf.getDigest();
    }

    @Override
    public int generateBytes(byte[] byArray, int n, int n2) {
        if (n + n2 <= byArray.length) {
            DEROctetString dEROctetString;
            ASN1EncodableVector aSN1EncodableVector;
            ECDHKEKGenerator eCDHKEKGenerator = this;
            ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
            new ASN1EncodableVector().add(new AlgorithmIdentifier(this.algorithm, DERNull.INSTANCE));
            DEROctetString dEROctetString2 = dEROctetString;
            dEROctetString = new DEROctetString(Pack.intToBigEndian(this.keySize));
            aSN1EncodableVector2.add(new DERTaggedObject(true, 2, dEROctetString2));
            try {
                eCDHKEKGenerator.kdf.init(new KDFParameters(this.z, new DERSequence(aSN1EncodableVector2).getEncoded("DER")));
                return eCDHKEKGenerator.kdf.generateBytes(byArray, n, n2);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(b.a(iOException, a.a("unable to initialise kdf: ")));
            }
        }
        throw new DataLengthException("output buffer too small");
    }
}

