/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.KeccakDigest;

public class SHA3Digest
extends KeccakDigest {
    private static int checkBitLength(int n) {
        if (n != 224 && n != 256 && n != 384 && n != 512) {
            throw new IllegalArgumentException(f.a("'bitLength' ", n, " not supported for SHA-3"));
        }
        return n;
    }

    public SHA3Digest() {
        this(256);
    }

    public SHA3Digest(int n) {
        super(SHA3Digest.checkBitLength(n));
    }

    public SHA3Digest(SHA3Digest sHA3Digest) {
        super(sHA3Digest);
    }

    @Override
    public String getAlgorithmName() {
        return a.a("SHA3-").append(this.fixedOutputLength).toString();
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        this.absorbBits(2, 2);
        return super.doFinal(byArray, n);
    }

    @Override
    public int doFinal(byte[] byArray, int n, byte by, int n2) {
        if (n2 >= 0 && n2 <= 7) {
            by = (byte)(by & (1 << n2) - 1 | 2 << n2);
            if ((n2 += 2) >= 8) {
                this.absorb(by);
                n2 -= 8;
                by = (byte)(by >>> 8);
            }
            return super.doFinal(byArray, n, by, n2);
        }
        throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
    }
}

