/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.LongDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Memoable;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.MemoableResetException;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class SHA512tDigest
extends LongDigest {
    private int digestLength;
    private long H1t;
    private long H2t;
    private long H3t;
    private long H4t;
    private long H5t;
    private long H6t;
    private long H7t;
    private long H8t;

    public SHA512tDigest(int n) {
        if (n < 512) {
            if (n % 8 == 0) {
                if (n != 384) {
                    SHA512tDigest sHA512tDigest = this;
                    this.digestLength = n / 8;
                    sHA512tDigest.tIvGenerate(this.digestLength * 8);
                    sHA512tDigest.reset();
                    return;
                }
                throw new IllegalArgumentException("bitLength cannot be 384 use SHA384 instead");
            }
            throw new IllegalArgumentException("bitLength needs to be a multiple of 8");
        }
        throw new IllegalArgumentException("bitLength cannot be >= 512");
    }

    public SHA512tDigest(SHA512tDigest sHA512tDigest) {
        super(sHA512tDigest);
        this.digestLength = sHA512tDigest.digestLength;
        this.reset(sHA512tDigest);
    }

    public SHA512tDigest(byte[] byArray) {
        this(SHA512tDigest.readDigestLength(byArray));
        this.restoreState(byArray);
    }

    private static int readDigestLength(byte[] byArray) {
        return Pack.bigEndianToInt(byArray, byArray.length - 4);
    }

    private void tIvGenerate(int n) {
        SHA512tDigest sHA512tDigest = this;
        sHA512tDigest.H1 = -3482333909917012819L;
        sHA512tDigest.H2 = 2216346199247487646L;
        sHA512tDigest.H3 = -7364697282686394994L;
        sHA512tDigest.H4 = 65953792586715988L;
        sHA512tDigest.H5 = -816286391624063116L;
        sHA512tDigest.H6 = 4512832404995164602L;
        sHA512tDigest.H7 = -5033199132376557362L;
        sHA512tDigest.H8 = -124578254951840548L;
        sHA512tDigest.update((byte)83);
        sHA512tDigest.update((byte)72);
        sHA512tDigest.update((byte)65);
        sHA512tDigest.update((byte)45);
        sHA512tDigest.update((byte)53);
        sHA512tDigest.update((byte)49);
        sHA512tDigest.update((byte)50);
        sHA512tDigest.update((byte)47);
        if (n > 100) {
            this.update((byte)(n / 100 + 48));
            int n2 = n % 100;
            this.update((byte)(n2 / 10 + 48));
            this.update((byte)(n2 % 10 + 48));
        } else if (n > 10) {
            this.update((byte)(n / 10 + 48));
            this.update((byte)(n % 10 + 48));
        } else {
            this.update((byte)(n + 48));
        }
        SHA512tDigest sHA512tDigest2 = this;
        sHA512tDigest2.finish();
        sHA512tDigest2.H1t = sHA512tDigest2.H1;
        sHA512tDigest2.H2t = sHA512tDigest2.H2;
        sHA512tDigest2.H3t = sHA512tDigest2.H3;
        sHA512tDigest2.H4t = sHA512tDigest2.H4;
        sHA512tDigest2.H5t = sHA512tDigest2.H5;
        sHA512tDigest2.H6t = sHA512tDigest2.H6;
        sHA512tDigest2.H7t = sHA512tDigest2.H7;
        sHA512tDigest2.H8t = sHA512tDigest2.H8;
    }

    private static void longToBigEndian(long l, byte[] byArray, int n, int n2) {
        if (n2 > 0) {
            SHA512tDigest.intToBigEndian((int)(l >>> 32), byArray, n, n2);
            if (n2 > 4) {
                int n3 = n + 4;
                SHA512tDigest.intToBigEndian((int)(l & 0xFFFFFFFFL), byArray, n3, n2 - 4);
            }
        }
    }

    private static void intToBigEndian(int n, byte[] byArray, int n2, int n3) {
        n3 = Math.min(4, n3);
        while ((n3 += -1) >= 0) {
            int n4 = (3 - n3) * 8;
            int n5 = n2 + n3;
            byArray[n5] = (byte)(n >>> n4);
        }
    }

    @Override
    public String getAlgorithmName() {
        return a.a("SHA-512/").append(Integer.toString(this.digestLength * 8)).toString();
    }

    @Override
    public int getDigestSize() {
        return this.digestLength;
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        SHA512tDigest sHA512tDigest = this;
        sHA512tDigest.finish();
        SHA512tDigest.longToBigEndian(sHA512tDigest.H1, byArray, n, this.digestLength);
        int n2 = n + 8;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H2, byArray, n2, this.digestLength - 8);
        n2 = n + 16;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H3, byArray, n2, this.digestLength - 16);
        n2 = n + 24;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H4, byArray, n2, this.digestLength - 24);
        n2 = n + 32;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H5, byArray, n2, this.digestLength - 32);
        n2 = n + 40;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H6, byArray, n2, this.digestLength - 40);
        n2 = n + 48;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H7, byArray, n2, this.digestLength - 48);
        int n3 = n + 56;
        SHA512tDigest.longToBigEndian(sHA512tDigest.H8, byArray, n3, this.digestLength - 56);
        sHA512tDigest.reset();
        return sHA512tDigest.digestLength;
    }

    @Override
    public void reset() {
        SHA512tDigest sHA512tDigest = this;
        super.reset();
        sHA512tDigest.H1 = sHA512tDigest.H1t;
        sHA512tDigest.H2 = sHA512tDigest.H2t;
        sHA512tDigest.H3 = sHA512tDigest.H3t;
        sHA512tDigest.H4 = sHA512tDigest.H4t;
        sHA512tDigest.H5 = sHA512tDigest.H5t;
        sHA512tDigest.H6 = sHA512tDigest.H6t;
        sHA512tDigest.H7 = sHA512tDigest.H7t;
        sHA512tDigest.H8 = sHA512tDigest.H8t;
    }

    @Override
    public Memoable copy() {
        return new SHA512tDigest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        memoable = (SHA512tDigest)memoable;
        if (this.digestLength == ((SHA512tDigest)memoable).digestLength) {
            super.copyIn((LongDigest)memoable);
            this.H1t = ((SHA512tDigest)memoable).H1t;
            this.H2t = ((SHA512tDigest)memoable).H2t;
            this.H3t = ((SHA512tDigest)memoable).H3t;
            this.H4t = ((SHA512tDigest)memoable).H4t;
            this.H5t = ((SHA512tDigest)memoable).H5t;
            this.H6t = ((SHA512tDigest)memoable).H6t;
            this.H7t = ((SHA512tDigest)memoable).H7t;
            this.H8t = ((SHA512tDigest)memoable).H8t;
            return;
        }
        throw new MemoableResetException("digestLength inappropriate in other");
    }

    @Override
    public byte[] getEncodedState() {
        int n = this.getEncodedStateSize();
        byte[] byArray = new byte[n + 4];
        SHA512tDigest sHA512tDigest = this;
        sHA512tDigest.populateState(byArray);
        Pack.intToBigEndian(sHA512tDigest.digestLength * 8, byArray, n);
        return byArray;
    }
}

