/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Xof;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.KeccakDigest;

public class SHAKEDigest
extends KeccakDigest
implements Xof {
    private static int checkBitLength(int n) {
        if (n != 128 && n != 256) {
            throw new IllegalArgumentException(f.a("'bitLength' ", n, " not supported for SHAKE"));
        }
        return n;
    }

    public SHAKEDigest() {
        this(128);
    }

    public SHAKEDigest(int n) {
        super(SHAKEDigest.checkBitLength(n));
    }

    public SHAKEDigest(SHAKEDigest sHAKEDigest) {
        super(sHAKEDigest);
    }

    @Override
    public String getAlgorithmName() {
        return a.a("SHAKE").append(this.fixedOutputLength).toString();
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        return this.doFinal(byArray, n, this.getDigestSize());
    }

    @Override
    public int doFinal(byte[] byArray, int n, int n2) {
        int n3 = this.doOutput(byArray, n, n2);
        this.reset();
        return n3;
    }

    @Override
    public int doOutput(byte[] byArray, int n, int n2) {
        if (!this.squeezing) {
            this.absorbBits(15, 4);
        }
        long l = (long)n2 * 8L;
        this.squeeze(byArray, n, l);
        return n2;
    }

    @Override
    public int doFinal(byte[] byArray, int n, byte by, int n2) {
        return this.doFinal(byArray, n, this.getDigestSize(), by, n2);
    }

    public int doFinal(byte[] byArray, int n, int n2, byte by, int n3) {
        if (n3 >= 0 && n3 <= 7) {
            by = (byte)(by & (1 << n3) - 1 | 15 << n3);
            if ((n3 += 4) >= 8) {
                this.absorb(by);
                n3 -= 8;
                by = (byte)(by >>> 8);
            }
            if (n3 > 0) {
                this.absorbBits(by, n3);
            }
            SHAKEDigest sHAKEDigest = this;
            long l = (long)n2 * 8L;
            sHAKEDigest.squeeze(byArray, n, l);
            sHAKEDigest.reset();
            return n2;
        }
        throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
    }
}

