/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class AESLightEngine
implements BlockCipher {
    private static final byte[] S = new byte[]{99, 124, 119, 123, -14, 107, 111, -59, 48, 1, 103, 43, -2, -41, -85, 118, -54, -126, -55, 125, -6, 89, 71, -16, -83, -44, -94, -81, -100, -92, 114, -64, -73, -3, -109, 38, 54, 63, -9, -52, 52, -91, -27, -15, 113, -40, 49, 21, 4, -57, 35, -61, 24, -106, 5, -102, 7, 18, -128, -30, -21, 39, -78, 117, 9, -125, 44, 26, 27, 110, 90, -96, 82, 59, -42, -77, 41, -29, 47, -124, 83, -47, 0, -19, 32, -4, -79, 91, 106, -53, -66, 57, 74, 76, 88, -49, -48, -17, -86, -5, 67, 77, 51, -123, 69, -7, 2, 127, 80, 60, -97, -88, 81, -93, 64, -113, -110, -99, 56, -11, -68, -74, -38, 33, 16, -1, -13, -46, -51, 12, 19, -20, 95, -105, 68, 23, -60, -89, 126, 61, 100, 93, 25, 115, 96, -127, 79, -36, 34, 42, -112, -120, 70, -18, -72, 20, -34, 94, 11, -37, -32, 50, 58, 10, 73, 6, 36, 92, -62, -45, -84, 98, -111, -107, -28, 121, -25, -56, 55, 109, -115, -43, 78, -87, 108, 86, -12, -22, 101, 122, -82, 8, -70, 120, 37, 46, 28, -90, -76, -58, -24, -35, 116, 31, 75, -67, -117, -118, 112, 62, -75, 102, 72, 3, -10, 14, 97, 53, 87, -71, -122, -63, 29, -98, -31, -8, -104, 17, 105, -39, -114, -108, -101, 30, -121, -23, -50, 85, 40, -33, -116, -95, -119, 13, -65, -26, 66, 104, 65, -103, 45, 15, -80, 84, -69, 22};
    private static final byte[] Si = new byte[]{82, 9, 106, -43, 48, 54, -91, 56, -65, 64, -93, -98, -127, -13, -41, -5, 124, -29, 57, -126, -101, 47, -1, -121, 52, -114, 67, 68, -60, -34, -23, -53, 84, 123, -108, 50, -90, -62, 35, 61, -18, 76, -107, 11, 66, -6, -61, 78, 8, 46, -95, 102, 40, -39, 36, -78, 118, 91, -94, 73, 109, -117, -47, 37, 114, -8, -10, 100, -122, 104, -104, 22, -44, -92, 92, -52, 93, 101, -74, -110, 108, 112, 72, 80, -3, -19, -71, -38, 94, 21, 70, 87, -89, -115, -99, -124, -112, -40, -85, 0, -116, -68, -45, 10, -9, -28, 88, 5, -72, -77, 69, 6, -48, 44, 30, -113, -54, 63, 15, 2, -63, -81, -67, 3, 1, 19, -118, 107, 58, -111, 17, 65, 79, 103, -36, -22, -105, -14, -49, -50, -16, -76, -26, 115, -106, -84, 116, 34, -25, -83, 53, -123, -30, -7, 55, -24, 28, 117, -33, 110, 71, -15, 26, 113, 29, 41, -59, -119, 111, -73, 98, 14, -86, 24, -66, 27, -4, 86, 62, 75, -58, -46, 121, 32, -102, -37, -64, -2, 120, -51, 90, -12, 31, -35, -88, 51, -120, 7, -57, 49, -79, 18, 16, 89, 39, -128, -20, 95, 96, 81, 127, -87, 25, -75, 74, 13, 45, -27, 122, -97, -109, -55, -100, -17, -96, -32, 59, 77, -82, 42, -11, -80, -56, -21, -69, 60, -125, 83, -103, 97, 23, 43, 4, 126, -70, 119, -42, 38, -31, 105, 20, 99, 85, 33, 12, 125};
    private static final int[] rcon = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145};
    private static final int m1 = -2139062144;
    private static final int m2 = 0x7F7F7F7F;
    private static final int m3 = 27;
    private static final int m4 = -1061109568;
    private static final int m5 = 0x3F3F3F3F;
    private static final int BLOCK_SIZE = 16;
    private int ROUNDS;
    private int[][] WorkingKey = null;
    private int C0;
    private int C1;
    private int C2;
    private int C3;
    private boolean forEncryption;

    private static int shift(int n, int n2) {
        return n >>> n2 | n << -n2;
    }

    private static int FFmulX(int n) {
        return (n & 0x7F7F7F7F) << 1 ^ ((n & 0x80808080) >>> 7) * 27;
    }

    private static int FFmulX2(int n) {
        int n2 = (n & 0x3F3F3F3F) << 2;
        int n3 = n & 0xC0C0C0C0;
        n = n3 ^ n3 >>> 1;
        return n2 ^ n >>> 2 ^ n >>> 5;
    }

    private static int mcol(int n) {
        int n2 = n;
        n = AESLightEngine.shift(n2, 8);
        int n3 = n2 ^ n;
        return AESLightEngine.shift(n3, 16) ^ n ^ AESLightEngine.FFmulX(n3);
    }

    private static int inv_mcol(int n) {
        int n2 = n;
        n = n2 ^ AESLightEngine.shift(n2, 8);
        int n3 = n2 ^ AESLightEngine.FFmulX(n);
        int n4 = n ^ AESLightEngine.FFmulX2(n3);
        return n3 ^ (n4 ^ AESLightEngine.shift(n4, 16));
    }

    private static int subWord(int n) {
        byte[] byArray = S;
        return S[n & 0xFF] & 0xFF | (byArray[n >> 8 & 0xFF] & 0xFF) << 8 | (byArray[n >> 16 & 0xFF] & 0xFF) << 16 | byArray[n >> 24 & 0xFF] << 24;
    }

    private int[][] generateWorkingKey(byte[] byArray, boolean n) {
        int n2 = byArray.length;
        if (n2 >= 16 && n2 <= 32 && (n2 & 7) == 0) {
            int n3;
            int[][] nArray;
            block12: {
                int n4;
                int n5;
                int n6;
                this.ROUNDS = (n2 >>>= 2) + 6;
                nArray = new int[this.ROUNDS + 1][4];
                if (n2 != 4) {
                    int n7;
                    int n8;
                    if (n2 != 6) {
                        if (n2 == 8) {
                            int n9;
                            nArray[0][0] = n3 = Pack.littleEndianToInt(byArray, 0);
                            nArray[0][1] = n2 = Pack.littleEndianToInt(byArray, 4);
                            nArray[0][2] = n6 = Pack.littleEndianToInt(byArray, 8);
                            nArray[0][3] = n5 = Pack.littleEndianToInt(byArray, 12);
                            nArray[1][0] = n4 = Pack.littleEndianToInt(byArray, 16);
                            nArray[1][1] = n9 = Pack.littleEndianToInt(byArray, 20);
                            nArray[1][2] = n8 = Pack.littleEndianToInt(byArray, 24);
                            nArray[1][3] = n7 = Pack.littleEndianToInt(byArray, 28);
                            int n10 = 2;
                            int n11 = 1;
                            while (true) {
                                int n12 = n3;
                                n3 = AESLightEngine.subWord(AESLightEngine.shift(n7, 8)) ^ n11;
                                n11 <<= 1;
                                n3 = n12 ^ n3;
                                int[] nArray2 = nArray[n10];
                                int[] nArray3 = nArray2;
                                nArray3[0] = n3;
                                nArray3[1] = n2 ^= n3;
                                nArray3[2] = n6 ^= n2;
                                nArray2[3] = n5 ^= n6;
                                if (++n10 < 15) {
                                    int[] nArray4 = nArray[n10];
                                    nArray3 = nArray4;
                                    nArray3[0] = n4 ^= AESLightEngine.subWord(n5);
                                    nArray3[1] = n9 ^= n4;
                                    nArray3[2] = n8 ^= n9;
                                    nArray4[3] = n7 ^= n8;
                                    ++n10;
                                    continue;
                                }
                                break block12;
                                break;
                            }
                        }
                        throw new IllegalStateException("Should never get here");
                    }
                    nArray[0][0] = n3 = Pack.littleEndianToInt(byArray, 0);
                    nArray[0][1] = n2 = Pack.littleEndianToInt(byArray, 4);
                    nArray[0][2] = n6 = Pack.littleEndianToInt(byArray, 8);
                    nArray[0][3] = n5 = Pack.littleEndianToInt(byArray, 12);
                    n4 = Pack.littleEndianToInt(byArray, 16);
                    int n13 = Pack.littleEndianToInt(byArray, 20);
                    n8 = 1;
                    n7 = 1;
                    while (true) {
                        int n14 = n3;
                        int[] nArray5 = nArray[n8];
                        nArray5[0] = n4;
                        nArray5[1] = n13;
                        n3 = AESLightEngine.subWord(AESLightEngine.shift(n13, 8)) ^ n7;
                        n7 <<= 1;
                        int n15 = n14 ^ n3;
                        n3 = n15;
                        int[] nArray6 = nArray[n8];
                        int[] nArray7 = nArray6;
                        nArray7[2] = n3;
                        nArray6[3] = n3 = n2 ^ n3;
                        n2 = n6 ^ n3;
                        int[] nArray8 = nArray[n8 + 1];
                        nArray7 = nArray8;
                        nArray7[0] = n2;
                        nArray7[1] = n5 ^= n2;
                        nArray8[2] = n4 ^= n5;
                        nArray7[3] = n13 ^= n4;
                        n6 = AESLightEngine.subWord(AESLightEngine.shift(n13, 8)) ^ n7;
                        n7 <<= 1;
                        n6 = n15 ^ n6;
                        int[] nArray9 = nArray[n8 + 2];
                        int[] nArray10 = nArray9;
                        int n16 = n2;
                        nArray10[0] = n6;
                        nArray10[1] = n2 = n3 ^ n6;
                        nArray10[2] = n3 = n16 ^ n2;
                        nArray9[3] = n5 ^= n3;
                        if ((n8 += 3) < 13) {
                            n13 ^= (n4 ^= n5);
                            int n17 = n6;
                            n6 = n3;
                            n3 = n17;
                            continue;
                        }
                        break block12;
                        break;
                    }
                }
                nArray[0][0] = n3 = Pack.littleEndianToInt(byArray, 0);
                nArray[0][1] = n2 = Pack.littleEndianToInt(byArray, 4);
                nArray[0][2] = n6 = Pack.littleEndianToInt(byArray, 8);
                nArray[0][3] = n5 = Pack.littleEndianToInt(byArray, 12);
                for (n4 = 1; n4 <= 10; ++n4) {
                    int[] nArray11 = nArray[n4];
                    int[] nArray12 = nArray11;
                    nArray12[0] = n3 ^= AESLightEngine.subWord(AESLightEngine.shift(n5, 8)) ^ rcon[n4 - 1];
                    nArray12[1] = n2 ^= n3;
                    nArray12[2] = n6 ^= n2;
                    nArray11[3] = n5 ^= n6;
                }
            }
            if (n == 0) {
                for (n3 = 1; n3 < this.ROUNDS; ++n3) {
                    for (n = 0; n < 4; ++n) {
                        int[] nArray13 = nArray[n3];
                        nArray13[n] = AESLightEngine.inv_mcol(nArray13[n]);
                    }
                }
            }
            return nArray;
        }
        throw new IllegalArgumentException("Key length not 128/192/256 bits.");
    }

    private void unpackBlock(byte[] byArray, int n) {
        int n2 = n;
        int n3 = n2 + 1;
        this.C0 = byArray[n2] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | byArray[n3++] << 24;
        this.C1 = byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | byArray[n3++] << 24;
        this.C2 = byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | byArray[n3++] << 24;
        this.C3 = byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | byArray[n3] << 24;
    }

    private void packBlock(byte[] byArray, int n) {
        int n2 = n + 1;
        int n3 = this.C0;
        byArray[n] = (byte)n3;
        byArray[n2++] = (byte)(n3 >> 8);
        n = n2 + 1;
        byArray[n2] = (byte)(n3 >> 16);
        n2 = n + 1;
        byArray[n] = (byte)(n3 >> 24);
        n = n2 + 1;
        n3 = this.C1;
        byArray[n2] = (byte)n3;
        n2 = n + 1;
        byArray[n] = (byte)(n3 >> 8);
        n = n2 + 1;
        byArray[n2] = (byte)(n3 >> 16);
        n2 = n + 1;
        byArray[n] = (byte)(n3 >> 24);
        n = n2 + 1;
        n3 = this.C2;
        byArray[n2] = (byte)n3;
        n2 = n + 1;
        byArray[n] = (byte)(n3 >> 8);
        n = n2 + 1;
        byArray[n2] = (byte)(n3 >> 16);
        n2 = n + 1;
        byArray[n] = (byte)(n3 >> 24);
        n = n2 + 1;
        n3 = this.C3;
        byArray[n2] = (byte)n3;
        n2 = n + 1;
        byArray[n] = (byte)(n3 >> 8);
        int n4 = n2 + 1;
        byArray[n2] = (byte)(n3 >> 16);
        byArray[n4] = (byte)(n3 >> 24);
    }

    private void encryptBlock(int[][] nArray) {
        int n;
        int n2;
        byte[] byArray;
        AESLightEngine aESLightEngine = object;
        int[] nArray2 = nArray[0];
        int n3 = aESLightEngine.C0 ^ nArray2[0];
        int n4 = aESLightEngine.C1 ^ nArray2[1];
        int n5 = aESLightEngine.C2 ^ nArray2[2];
        int n6 = 1;
        int n7 = aESLightEngine.C3 ^ nArray2[3];
        while (n6 < ((AESLightEngine)object).ROUNDS - 1) {
            byArray = S;
            int n8 = n7;
            n2 = AESLightEngine.mcol(byArray[n3 & 0xFF] & 0xFF ^ (byArray[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n5 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n7 >> 24 & 0xFF] << 24) ^ nArray[n6][0];
            n = AESLightEngine.mcol(byArray[n4 & 0xFF] & 0xFF ^ (byArray[n5 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n3 >> 24 & 0xFF] << 24) ^ nArray[n6][1];
            n7 = AESLightEngine.mcol(byArray[n5 & 0xFF] & 0xFF ^ (byArray[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n4 >> 24 & 0xFF] << 24) ^ nArray[n6][2];
            int n9 = AESLightEngine.mcol(byArray[n8 & 0xFF] & 0xFF ^ (byArray[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n5 >> 24 & 0xFF] << 24);
            int n10 = n6;
            n3 = n10 + 1;
            int n11 = n9 ^ nArray[n10][3];
            n4 = n11;
            n5 = AESLightEngine.mcol(byArray[n2 & 0xFF] & 0xFF ^ (byArray[n >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n4 >> 24 & 0xFF] << 24) ^ nArray[n3][0];
            n6 = AESLightEngine.mcol(byArray[n & 0xFF] & 0xFF ^ (byArray[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n2 >> 24 & 0xFF] << 24) ^ nArray[n3][1];
            n4 = AESLightEngine.mcol(byArray[n7 & 0xFF] & 0xFF ^ (byArray[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n2 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n >> 24 & 0xFF] << 24) ^ nArray[n3][2];
            int n12 = AESLightEngine.mcol(S[n11 & 0xFF] & 0xFF ^ (byArray[n2 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n7 >> 24 & 0xFF] << 24);
            int n13 = n3;
            n7 = n13 + 1;
            n3 = n12 ^ nArray[n13][3];
            int n14 = n7;
            int n15 = n5;
            n7 = n3;
            n5 = n4;
            n4 = n6;
            n3 = n15;
            n6 = n14;
        }
        AESLightEngine aESLightEngine2 = object;
        byArray = S;
        int n16 = n7;
        n2 = AESLightEngine.mcol(byArray[n3 & 0xFF] & 0xFF ^ (byArray[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n5 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n7 >> 24 & 0xFF] << 24) ^ nArray[n6][0];
        n = AESLightEngine.mcol(byArray[n4 & 0xFF] & 0xFF ^ (byArray[n5 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n3 >> 24 & 0xFF] << 24) ^ nArray[n6][1];
        n7 = AESLightEngine.mcol(byArray[n5 & 0xFF] & 0xFF ^ (byArray[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n4 >> 24 & 0xFF] << 24) ^ nArray[n6][2];
        int n17 = AESLightEngine.mcol(byArray[n16 & 0xFF] & 0xFF ^ (byArray[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n5 >> 24 & 0xFF] << 24);
        int n18 = n6;
        n3 = n18 + 1;
        n4 = n17 ^ nArray[n18][3];
        AESLightEngine aESLightEngine3 = object;
        AESLightEngine aESLightEngine4 = object;
        AESLightEngine aESLightEngine5 = object;
        int[] nArray3 = nArray[n3];
        Object object = nArray3;
        aESLightEngine5.C0 = byArray[n2 & 0xFF] & 0xFF ^ (byArray[n >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n4 >> 24 & 0xFF] << 24 ^ nArray3[0];
        aESLightEngine4.C1 = byArray[n & 0xFF] & 0xFF ^ (byArray[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n2 >> 24 & 0xFF] << 24 ^ object[1];
        aESLightEngine3.C2 = byArray[n7 & 0xFF] & 0xFF ^ (byArray[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n2 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n >> 24 & 0xFF] << 24 ^ object[2];
        aESLightEngine2.C3 = S[n4 & 0xFF] & 0xFF ^ (byArray[n2 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n7 >> 24 & 0xFF] << 24 ^ object[3];
    }

    private void decryptBlock(int[][] nArray) {
        int n;
        int n2;
        byte[] byArray;
        AESLightEngine aESLightEngine = object;
        int n3 = aESLightEngine.C0;
        int n4 = aESLightEngine.ROUNDS;
        int n5 = n4;
        AESLightEngine aESLightEngine2 = object;
        int[] nArray2 = nArray[n5];
        n5 = n3 ^ nArray2[0];
        int n6 = aESLightEngine2.C1 ^ nArray2[1];
        int n7 = aESLightEngine2.C2 ^ nArray2[2];
        int n8 = n4 - 1;
        int n9 = aESLightEngine.C3 ^ nArray2[3];
        while (n8 > 1) {
            byArray = Si;
            int n10 = n9;
            n2 = AESLightEngine.inv_mcol(byArray[n5 & 0xFF] & 0xFF ^ (byArray[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n6 >> 24 & 0xFF] << 24) ^ nArray[n8][0];
            n = AESLightEngine.inv_mcol(byArray[n6 & 0xFF] & 0xFF ^ (byArray[n5 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n7 >> 24 & 0xFF] << 24) ^ nArray[n8][1];
            n9 = AESLightEngine.inv_mcol(byArray[n7 & 0xFF] & 0xFF ^ (byArray[n6 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n5 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n9 >> 24 & 0xFF] << 24) ^ nArray[n8][2];
            int n11 = AESLightEngine.inv_mcol(byArray[n10 & 0xFF] & 0xFF ^ (byArray[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n6 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n5 >> 24 & 0xFF] << 24);
            int n12 = n8;
            n5 = n12 + -1;
            int n13 = n11 ^ nArray[n12][3];
            n6 = n13;
            n7 = AESLightEngine.inv_mcol(byArray[n2 & 0xFF] & 0xFF ^ (byArray[n6 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n >> 24 & 0xFF] << 24) ^ nArray[n5][0];
            n8 = AESLightEngine.inv_mcol(byArray[n & 0xFF] & 0xFF ^ (byArray[n2 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n6 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n9 >> 24 & 0xFF] << 24) ^ nArray[n5][1];
            n6 = AESLightEngine.inv_mcol(byArray[n9 & 0xFF] & 0xFF ^ (byArray[n >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n2 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n6 >> 24 & 0xFF] << 24) ^ nArray[n5][2];
            int n14 = AESLightEngine.inv_mcol(Si[n13 & 0xFF] & 0xFF ^ (byArray[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n2 >> 24 & 0xFF] << 24);
            int n15 = n5;
            n9 = n15 + -1;
            n5 = n14 ^ nArray[n15][3];
            int n16 = n9;
            int n17 = n7;
            int n18 = n6;
            n6 = n8;
            n7 = n18;
            n9 = n5;
            n5 = n17;
            n8 = n16;
        }
        AESLightEngine aESLightEngine3 = object;
        byArray = Si;
        int n19 = n9;
        n2 = AESLightEngine.inv_mcol(byArray[n5 & 0xFF] & 0xFF ^ (byArray[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n7 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n6 >> 24 & 0xFF] << 24) ^ nArray[n8][0];
        n = AESLightEngine.inv_mcol(byArray[n6 & 0xFF] & 0xFF ^ (byArray[n5 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n7 >> 24 & 0xFF] << 24) ^ nArray[n8][1];
        n9 = AESLightEngine.inv_mcol(byArray[n7 & 0xFF] & 0xFF ^ (byArray[n6 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n5 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n9 >> 24 & 0xFF] << 24) ^ nArray[n8][2];
        n5 = AESLightEngine.inv_mcol(byArray[n19 & 0xFF] & 0xFF ^ (byArray[n7 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n6 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n5 >> 24 & 0xFF] << 24) ^ nArray[n8][3];
        AESLightEngine aESLightEngine4 = object;
        AESLightEngine aESLightEngine5 = object;
        AESLightEngine aESLightEngine6 = object;
        int[] nArray3 = nArray[0];
        Object object = nArray3;
        aESLightEngine6.C0 = byArray[n2 & 0xFF] & 0xFF ^ (byArray[n5 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n9 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n >> 24 & 0xFF] << 24 ^ nArray3[0];
        aESLightEngine5.C1 = byArray[n & 0xFF] & 0xFF ^ (byArray[n2 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n5 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n9 >> 24 & 0xFF] << 24 ^ object[1];
        aESLightEngine4.C2 = byArray[n9 & 0xFF] & 0xFF ^ (byArray[n >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n2 >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n5 >> 24 & 0xFF] << 24 ^ object[2];
        aESLightEngine3.C3 = Si[n5 & 0xFF] & 0xFF ^ (byArray[n9 >> 8 & 0xFF] & 0xFF) << 8 ^ (byArray[n >> 16 & 0xFF] & 0xFF) << 16 ^ byArray[n2 >> 24 & 0xFF] << 24 ^ object[3];
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.WorkingKey = this.generateWorkingKey(((KeyParameter)cipherParameters).getKey(), bl);
            this.forEncryption = bl;
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a.a("invalid parameter passed to AES init - ")));
    }

    @Override
    public String getAlgorithmName() {
        return "AES";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.WorkingKey != null) {
            if (n + 16 <= byArray.length) {
                if (n2 + 16 <= byArray2.length) {
                    if (this.forEncryption) {
                        AESLightEngine aESLightEngine = this;
                        aESLightEngine.unpackBlock(byArray, n);
                        aESLightEngine.encryptBlock(aESLightEngine.WorkingKey);
                        this.packBlock(byArray2, n2);
                    } else {
                        AESLightEngine aESLightEngine = this;
                        aESLightEngine.unpackBlock(byArray, n);
                        aESLightEngine.decryptBlock(aESLightEngine.WorkingKey);
                        this.packBlock(byArray2, n2);
                    }
                    return 16;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("AES engine not initialised");
    }

    @Override
    public void reset() {
    }
}

