/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;

public class CramerShoupCiphertext {
    public BigInteger u1;
    public BigInteger u2;
    public BigInteger e;
    public BigInteger v;

    public CramerShoupCiphertext() {
    }

    public CramerShoupCiphertext(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.u1 = bigInteger;
        this.u2 = bigInteger2;
        this.e = bigInteger3;
        this.v = bigInteger4;
    }

    public CramerShoupCiphertext(byte[] byArray) {
        int n = Pack.bigEndianToInt(byArray, 0) + 4;
        byArray = Arrays.copyOfRange(byArray, 4, n);
        this.u1 = new BigInteger(byArray);
        int n2 = Pack.bigEndianToInt(byArray, n);
        int n3 = n + 4;
        n = n3 + n2;
        byte[] byArray2 = Arrays.copyOfRange(byArray, n3, n);
        this.u2 = new BigInteger(byArray2);
        int n4 = Pack.bigEndianToInt(byArray, n);
        int n5 = n + 4;
        n = n5 + n4;
        byte[] byArray3 = Arrays.copyOfRange(byArray, n5, n);
        this.e = new BigInteger(byArray3);
        int n6 = Pack.bigEndianToInt(byArray, n);
        int n7 = n + 4;
        byte[] byArray4 = Arrays.copyOfRange(byArray, n7, n7 + n6);
        this.v = new BigInteger(byArray4);
    }

    public BigInteger getU1() {
        return this.u1;
    }

    public void setU1(BigInteger bigInteger) {
        this.u1 = bigInteger;
    }

    public BigInteger getU2() {
        return this.u2;
    }

    public void setU2(BigInteger bigInteger) {
        this.u2 = bigInteger;
    }

    public BigInteger getE() {
        return this.e;
    }

    public void setE(BigInteger bigInteger) {
        this.e = bigInteger;
    }

    public BigInteger getV() {
        return this.v;
    }

    public void setV(BigInteger bigInteger) {
        this.v = bigInteger;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(a.a("u1: ").append(this.u1.toString()).toString());
        stringBuffer.append("\nu2: " + this.u2.toString());
        stringBuffer.append("\ne: " + this.e.toString());
        stringBuffer.append("\nv: " + this.v.toString());
        return stringBuffer.toString();
    }

    public byte[] toByteArray() {
        byte[] byArray = ((CramerShoupCiphertext)object).u1.toByteArray();
        int n = byArray.length;
        byte[] byArray2 = ((CramerShoupCiphertext)object).u2.toByteArray();
        int n2 = byArray2.length;
        CramerShoupCiphertext cramerShoupCiphertext = object;
        byte[] byArray3 = cramerShoupCiphertext.e.toByteArray();
        Object object = byArray3;
        int n3 = byArray3.length;
        byte[] byArray4 = cramerShoupCiphertext.v.toByteArray();
        int n4 = byArray4.length;
        byte[] byArray5 = new byte[n + n2 + n3 + n4 + 16];
        Pack.intToBigEndian(n, byArray5, 0);
        System.arraycopy(byArray, 0, byArray5, 4, n);
        int n5 = 4 + n;
        Pack.intToBigEndian(n2, byArray5, n5);
        System.arraycopy(byArray2, 0, byArray5, n5 += 4, n2);
        Pack.intToBigEndian(n3, byArray5, n5 += n2);
        System.arraycopy(object, 0, byArray5, n5 += 4, n3);
        int n6 = n5 + n3;
        Pack.intToBigEndian(n4, byArray5, n6);
        System.arraycopy(byArray4, 0, byArray5, n6 += 4, n4);
        return byArray5;
    }
}

