/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Wrapper;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.DSTU7624Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.util.ArrayList;

public class DSTU7624WrapEngine
implements Wrapper {
    private static final int BYTES_IN_INTEGER = 4;
    private boolean forWrapping;
    private DSTU7624Engine engine;
    private byte[] B;
    private byte[] intArray;
    private byte[] checkSumArray;
    private byte[] zeroArray;
    private ArrayList<byte[]> Btemp;

    public DSTU7624WrapEngine(int n) {
        DSTU7624Engine dSTU7624Engine;
        DSTU7624WrapEngine dSTU7624WrapEngine = dSTU7624Engine2;
        DSTU7624Engine dSTU7624Engine2 = dSTU7624Engine;
        dSTU7624WrapEngine.engine = new DSTU7624Engine(n);
        dSTU7624WrapEngine.B = new byte[dSTU7624Engine2.getBlockSize() / 2];
        dSTU7624WrapEngine.checkSumArray = new byte[dSTU7624WrapEngine.engine.getBlockSize()];
        dSTU7624WrapEngine.zeroArray = new byte[dSTU7624WrapEngine.engine.getBlockSize()];
        dSTU7624WrapEngine.Btemp = new ArrayList();
        dSTU7624WrapEngine.intArray = new byte[4];
    }

    private void intToBytes(int n, byte[] byArray, int n2) {
        int n3 = n2 + 3;
        byArray[n3] = (byte)(n >> 24);
        n3 = n2 + 2;
        byArray[n3] = (byte)(n >> 16);
        n3 = n2 + 1;
        byArray[n3] = (byte)(n >> 8);
        byArray[n2] = (byte)n;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        this.forWrapping = bl;
        if (cipherParameters instanceof KeyParameter) {
            this.engine.init(bl, cipherParameters);
            return;
        }
        throw new IllegalArgumentException("invalid parameters passed to DSTU7624WrapEngine");
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7624WrapEngine";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2) {
        if (this.forWrapping) {
            if (n2 % this.engine.getBlockSize() == 0) {
                if (n + n2 <= byArray.length) {
                    int n3;
                    DSTU7624WrapEngine dSTU7624WrapEngine;
                    DSTU7624WrapEngine dSTU7624WrapEngine2 = this;
                    int n4 = (n2 / this.engine.getBlockSize() + 1) * 2;
                    int n5 = n4 - 1;
                    int n6 = n5 * 6;
                    int n7 = dSTU7624WrapEngine2.engine.getBlockSize() + n2;
                    byte[] byArray2 = new byte[n7];
                    DSTU7624WrapEngine dSTU7624WrapEngine3 = this;
                    System.arraycopy(byArray, n, byArray2, 0, n2);
                    byArray = dSTU7624WrapEngine3.B;
                    n = dSTU7624WrapEngine3.engine.getBlockSize() / 2;
                    System.arraycopy(byArray2, 0, byArray, 0, n);
                    this.Btemp.clear();
                    n = dSTU7624WrapEngine2.engine.getBlockSize() / 2;
                    for (n3 = n7 - (v250435).engine.getBlockSize() / 2; n3 != 0; n3 -= dSTU7624WrapEngine.engine.getBlockSize() / 2) {
                        dSTU7624WrapEngine = this;
                        DSTU7624WrapEngine dSTU7624WrapEngine4 = this;
                        byte[] byArray3 = new byte[dSTU7624WrapEngine4.engine.getBlockSize() / 2];
                        n2 = dSTU7624WrapEngine4.engine.getBlockSize() / 2;
                        System.arraycopy(byArray2, n, byArray3, 0, n2);
                        dSTU7624WrapEngine.Btemp.add(byArray3);
                        n = this.engine.getBlockSize() / 2 + n;
                    }
                    n3 = 0;
                    while (n3 < n6) {
                        DSTU7624WrapEngine dSTU7624WrapEngine5 = this;
                        n = this.engine.getBlockSize() / 2;
                        System.arraycopy(dSTU7624WrapEngine5.B, 0, byArray2, 0, n);
                        DSTU7624WrapEngine dSTU7624WrapEngine6 = this;
                        n = dSTU7624WrapEngine6.engine.getBlockSize() / 2;
                        n2 = dSTU7624WrapEngine6.engine.getBlockSize() / 2;
                        System.arraycopy(dSTU7624WrapEngine5.Btemp.get(0), 0, byArray2, n, n2);
                        dSTU7624WrapEngine5.engine.processBlock(byArray2, 0, byArray2, 0);
                        dSTU7624WrapEngine5.intToBytes(++n3, dSTU7624WrapEngine5.intArray, 0);
                        for (n = 0; n < 4; ++n) {
                            n2 = this.engine.getBlockSize() / 2 + n;
                            byArray2[n2] = (byte)(byArray2[n2] ^ this.intArray[n]);
                        }
                        DSTU7624WrapEngine dSTU7624WrapEngine7 = this;
                        n = dSTU7624WrapEngine7.engine.getBlockSize() / 2;
                        byte[] byArray4 = dSTU7624WrapEngine7.B;
                        int n8 = n;
                        n = this.engine.getBlockSize() / 2;
                        System.arraycopy(byArray2, n8, byArray4, 0, n);
                        for (n = 2; n < n4; ++n) {
                            DSTU7624WrapEngine dSTU7624WrapEngine8 = this;
                            byArray4 = dSTU7624WrapEngine8.Btemp.get(n - 2);
                            int n9 = dSTU7624WrapEngine8.engine.getBlockSize() / 2;
                            System.arraycopy(this.Btemp.get(n - 1), 0, byArray4, 0, n9);
                        }
                        DSTU7624WrapEngine dSTU7624WrapEngine9 = this;
                        byte[] byArray5 = dSTU7624WrapEngine9.Btemp.get(n4 - 2);
                        n2 = dSTU7624WrapEngine9.engine.getBlockSize() / 2;
                        System.arraycopy(byArray2, 0, byArray5, 0, n2);
                    }
                    DSTU7624WrapEngine dSTU7624WrapEngine10 = this;
                    n3 = this.engine.getBlockSize() / 2;
                    System.arraycopy(dSTU7624WrapEngine10.B, 0, byArray2, 0, n3);
                    n3 = dSTU7624WrapEngine10.engine.getBlockSize() / 2;
                    for (n = 0; n < n5; ++n) {
                        DSTU7624WrapEngine dSTU7624WrapEngine11 = this;
                        n2 = this.engine.getBlockSize() / 2;
                        System.arraycopy(dSTU7624WrapEngine11.Btemp.get(n), 0, byArray2, n3, n2);
                        n3 = dSTU7624WrapEngine11.engine.getBlockSize() / 2 + n3;
                    }
                    return byArray2;
                }
                throw new DataLengthException("input buffer too short");
            }
            throw new DataLengthException(a.a("wrap data must be a multiple of ").append(this.engine.getBlockSize()).append(" bytes").toString());
        }
        throw new IllegalStateException("not set for wrapping");
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2) {
        if (!this.forWrapping) {
            if (n2 % this.engine.getBlockSize() == 0) {
                int n3;
                DSTU7624WrapEngine dSTU7624WrapEngine;
                int n4 = n2;
                int n5 = n4 * 2 / this.engine.getBlockSize();
                int n6 = n5 - 1;
                int n7 = n6 * 6;
                byte[] byArray2 = new byte[n4];
                DSTU7624WrapEngine dSTU7624WrapEngine2 = this;
                System.arraycopy(byArray, n, byArray2, 0, n2);
                byArray = new byte[dSTU7624WrapEngine2.engine.getBlockSize() / 2];
                n = dSTU7624WrapEngine2.engine.getBlockSize() / 2;
                System.arraycopy(byArray2, 0, byArray, 0, n);
                this.Btemp.clear();
                int n8 = this.engine.getBlockSize() / 2;
                for (n = n2 - (v250721).engine.getBlockSize() / 2; n != 0; n -= dSTU7624WrapEngine.engine.getBlockSize() / 2) {
                    dSTU7624WrapEngine = this;
                    DSTU7624WrapEngine dSTU7624WrapEngine3 = this;
                    byte[] byArray3 = new byte[dSTU7624WrapEngine3.engine.getBlockSize() / 2];
                    n3 = dSTU7624WrapEngine3.engine.getBlockSize() / 2;
                    System.arraycopy(byArray2, n8, byArray3, 0, n3);
                    dSTU7624WrapEngine.Btemp.add(byArray3);
                    n8 = this.engine.getBlockSize() / 2 + n8;
                }
                for (n = 0; n < n7; ++n) {
                    DSTU7624WrapEngine dSTU7624WrapEngine4 = this;
                    DSTU7624WrapEngine dSTU7624WrapEngine5 = this;
                    n8 = this.engine.getBlockSize() / 2;
                    System.arraycopy(dSTU7624WrapEngine5.Btemp.get(n5 - 2), 0, byArray2, 0, n8);
                    n8 = dSTU7624WrapEngine5.engine.getBlockSize() / 2;
                    n3 = dSTU7624WrapEngine5.engine.getBlockSize() / 2;
                    System.arraycopy(byArray, 0, byArray2, n8, n3);
                    n8 = n7 - n;
                    dSTU7624WrapEngine4.intToBytes(n8, dSTU7624WrapEngine4.intArray, 0);
                    for (n8 = 0; n8 < 4; ++n8) {
                        n3 = this.engine.getBlockSize() / 2 + n8;
                        byArray2[n3] = (byte)(byArray2[n3] ^ this.intArray[n8]);
                    }
                    DSTU7624WrapEngine dSTU7624WrapEngine6 = this;
                    dSTU7624WrapEngine6.engine.processBlock(byArray2, 0, byArray2, 0);
                    n8 = dSTU7624WrapEngine6.engine.getBlockSize() / 2;
                    System.arraycopy(byArray2, 0, byArray, 0, n8);
                    for (n8 = 2; n8 < n5; ++n8) {
                        int n9 = n5 - n8;
                        DSTU7624WrapEngine dSTU7624WrapEngine7 = this;
                        byte[] byArray4 = dSTU7624WrapEngine7.Btemp.get(n9);
                        int n10 = dSTU7624WrapEngine7.engine.getBlockSize() / 2;
                        System.arraycopy(this.Btemp.get(n9 - 1), 0, byArray4, 0, n10);
                    }
                    DSTU7624WrapEngine dSTU7624WrapEngine8 = this;
                    byte[] byArray5 = dSTU7624WrapEngine8.Btemp.get(0);
                    n3 = dSTU7624WrapEngine8.engine.getBlockSize() / 2;
                    System.arraycopy(byArray2, this.engine.getBlockSize() / 2, byArray5, 0, n3);
                }
                int n11 = this.engine.getBlockSize() / 2;
                System.arraycopy(byArray, 0, byArray2, 0, n11);
                n11 = this.engine.getBlockSize() / 2;
                for (n = 0; n < n6; ++n) {
                    DSTU7624WrapEngine dSTU7624WrapEngine9 = this;
                    n5 = this.engine.getBlockSize() / 2;
                    System.arraycopy(dSTU7624WrapEngine9.Btemp.get(n), 0, byArray2, n11, n5);
                    n11 = dSTU7624WrapEngine9.engine.getBlockSize() / 2 + n11;
                }
                n11 = n2 - this.engine.getBlockSize();
                byte[] byArray6 = this.checkSumArray;
                int n12 = n11;
                n11 = this.engine.getBlockSize();
                System.arraycopy(byArray2, n12, byArray6, 0, n11);
                byte[] byArray7 = new byte[n2 - this.engine.getBlockSize()];
                if (Arrays.areEqual(this.checkSumArray, this.zeroArray)) {
                    int n13 = n2 - this.engine.getBlockSize();
                    System.arraycopy(byArray2, 0, byArray7, 0, n13);
                    return byArray7;
                }
                throw new InvalidCipherTextException("checksum failed");
            }
            throw new DataLengthException(a.a("unwrap data must be a multiple of ").append(this.engine.getBlockSize()).append(" bytes").toString());
        }
        throw new IllegalStateException("not set for unwrapping");
    }
}

