/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class IDEAEngine
implements BlockCipher {
    public static final int BLOCK_SIZE = 8;
    private static final int MASK = 65535;
    private static final int BASE = 65537;
    private int[] workingKey = null;

    private int bytesToWord(byte[] byArray, int n) {
        return (byArray[n] << 8 & 0xFF00) + (byArray[n + 1] & 0xFF);
    }

    private void wordToBytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 8);
        int n3 = n2 + 1;
        byArray[n3] = (byte)n;
    }

    private int mul(int n, int n2) {
        int n3;
        if (n == 0) {
            n3 = 65537 - n2;
        } else if (n2 == 0) {
            n3 = 65537 - n;
        } else {
            int n4 = n * n2;
            int n5 = n4 & 0xFFFF;
            n = n5 - (n4 >>>= 16);
            n4 = n5 < n4 ? 1 : 0;
            n3 = n + n4;
        }
        return n3 & 0xFFFF;
    }

    private void ideaFunc(int[] nArray, byte[] byArray, int n, byte[] byArray2, int n2) {
        IDEAEngine iDEAEngine = this;
        int n3 = 0;
        int n4 = iDEAEngine.bytesToWord(byArray, n);
        int n5 = iDEAEngine.bytesToWord(byArray, n + 2);
        int n6 = iDEAEngine.bytesToWord(byArray, n + 4);
        int n7 = iDEAEngine.bytesToWord(byArray, n + 6);
        for (n = 0; n < 8; ++n) {
            n4 = this.mul(n4, nArray[n3++]);
            n5 = n5 + nArray[n3++] & 0xFFFF;
            n6 = n6 + nArray[n3++] & 0xFFFF;
            int n8 = n7;
            int n9 = n3;
            n7 = n9 + 1;
            n3 = this.mul(n8, nArray[n9]);
            int n10 = n6 ^ n4;
            int n11 = n5 ^ n3;
            int n12 = this.mul(n10, nArray[n7++]);
            n10 = n12;
            n10 = n11 + n10 & 0xFFFF;
            n10 = this.mul(n10, nArray[n7++]);
            n11 = n12 + n10 & 0xFFFF;
            int n13 = n5;
            n4 ^= n10;
            n5 = n10 ^ n6;
            n6 = n11 ^ n13;
            int n14 = n7;
            n7 = n3 ^= n11;
            n3 = n14;
        }
        IDEAEngine iDEAEngine2 = this;
        IDEAEngine iDEAEngine3 = this;
        int n15 = n3;
        int n16 = n15 + 1;
        iDEAEngine3.wordToBytes(iDEAEngine3.mul(n4, nArray[n15]), byArray2, n2);
        this.wordToBytes(n6 + nArray[n16++], byArray2, n2 + 2);
        this.wordToBytes(n5 + nArray[n16++], byArray2, n2 + 4);
        iDEAEngine2.wordToBytes(iDEAEngine2.mul(n7, nArray[n16]), byArray2, n2 + 6);
    }

    private int[] expandKey(byte[] byArray) {
        int n;
        int[] nArray = new int[52];
        if (byArray.length < 16) {
            byte[] byArray2 = byArray;
            byArray = new byte[16];
            n = 16 - byArray2.length;
            int n2 = byArray2.length;
            System.arraycopy(byArray, 0, byArray, n, n2);
        }
        for (n = 0; n < 8; ++n) {
            nArray[n] = this.bytesToWord(byArray, n * 2);
        }
        for (int k = 8; k < 52; ++k) {
            int n3 = k & 7;
            nArray[k] = n3 < 6 ? ((nArray[k - 7] & 0x7F) << 9 | nArray[k - 6] >> 7) & 0xFFFF : (n3 == 6 ? ((nArray[k - 7] & 0x7F) << 9 | nArray[k - 14] >> 7) & 0xFFFF : ((nArray[k - 15] & 0x7F) << 9 | nArray[k - 14] >> 7) & 0xFFFF);
        }
        return nArray;
    }

    private int mulInv(int n) {
        int n2;
        if (n < 2) {
            return n;
        }
        int n3 = 1;
        int n4 = 65537 / n;
        for (int k = 65537 % n; k != 1; k %= n2) {
            int n5 = n;
            n2 = n5 % k;
            n3 = n4 * (n /= k) + n3 & 0xFFFF;
            if (n2 == 1) {
                return n3;
            }
            n = k / n2;
            n4 = n3 * n + n4 & 0xFFFF;
            n = n2;
        }
        return 1 - n4 & 0xFFFF;
    }

    private int[] invertKey(int[] nArray) {
        int[] nArray2 = new int[52];
        int[] nArray3 = nArray2;
        int n = this.mulInv(nArray[0]);
        int n2 = this.addInv(nArray[1]);
        int n3 = this.addInv(nArray[2]);
        int n4 = 4;
        nArray2[51] = this.mulInv(nArray[3]);
        nArray2[50] = n3;
        nArray2[49] = n2;
        n2 = 48;
        nArray2[48] = n;
        for (n = 1; n < 8; ++n) {
            int[] nArray4 = nArray3;
            int[] nArray5 = nArray3;
            int n5 = n4;
            n3 = n5 + 1;
            n4 = nArray[n5];
            int n6 = nArray[n3++];
            nArray3[n2 += -1] = n6;
            nArray3[n2 += -1] = n4;
            n4 = this.mulInv(nArray[n3++]);
            n6 = this.addInv(nArray[n3++]);
            int n7 = this.addInv(nArray[n3++]);
            int n8 = this.mulInv(nArray[n3++]);
            nArray4[n2 += -1] = n8;
            nArray5[n2 += -1] = n6;
            nArray4[n2 += -1] = n7;
            nArray5[n2 += -1] = n4;
            n4 = n3;
        }
        int[] nArray6 = nArray3;
        int[] nArray7 = nArray3;
        int n9 = n4;
        int n10 = n9 + 1;
        int n11 = nArray[n9];
        n = nArray[n10++];
        nArray3[n2 += -1] = n;
        n = n2 + -1;
        nArray3[n] = n11;
        n11 = this.mulInv(nArray[n10++]);
        n2 = this.addInv(nArray[n10++]);
        n3 = this.addInv(nArray[n10++]);
        n10 = this.mulInv(nArray[n10]);
        nArray6[n += -1] = n10;
        n10 = n + -1;
        nArray7[n10] = n3;
        int n12 = n10 + -1;
        nArray3[n12] = n2;
        nArray6[n12 + -1] = n11;
        return nArray7;
    }

    private int[] generateWorkingKey(boolean bl, byte[] byArray) {
        if (bl) {
            return this.expandKey(byArray);
        }
        IDEAEngine iDEAEngine = this;
        return iDEAEngine.invertKey(iDEAEngine.expandKey(byArray));
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.workingKey = this.generateWorkingKey(bl, ((KeyParameter)cipherParameters).getKey());
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a.a("invalid parameter passed to IDEA init - ")));
    }

    @Override
    public String getAlgorithmName() {
        return "IDEA";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int[] nArray = this.workingKey;
        if (this.workingKey != null) {
            if (n + 8 <= byArray.length) {
                if (n2 + 8 <= byArray2.length) {
                    this.ideaFunc(nArray, byArray, n, byArray2, n2);
                    return 8;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("IDEA engine not initialised");
    }

    @Override
    public void reset() {
    }

    public int addInv(int n) {
        return 0 - n & 0xFFFF;
    }
}

