/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.StreamCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class ISAACEngine
implements StreamCipher {
    private final int sizeL;
    private final int stateArraySize;
    private int[] engineState = null;
    private int[] results = null;
    private int a = 0;
    private int b = 0;
    private int c = 0;
    private int index = 0;
    private byte[] keyStream = new byte[1024];
    private byte[] workingKey = null;
    private boolean initialised = false;

    public ISAACEngine() {
        this.sizeL = 8;
        this.stateArraySize = 256;
    }

    private void setKey(byte[] byArray) {
        int n;
        int n2;
        this.workingKey = byArray;
        if (this.engineState == null) {
            this.engineState = new int[256];
        }
        if (this.results == null) {
            this.results = new int[256];
        }
        for (int k = 0; k < 256; ++k) {
            this.results[k] = 0;
            this.engineState[k] = 0;
        }
        ISAACEngine iSAACEngine = this;
        iSAACEngine.c = 0;
        iSAACEngine.b = 0;
        iSAACEngine.a = 0;
        iSAACEngine.index = 0;
        int n3 = byArray.length + (byArray.length & 3);
        byte[] byArray2 = new byte[n3];
        int n4 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        for (n4 = 0; n4 < n3; n4 += 4) {
            int n5 = n4;
            n2 = n5 >>> 2;
            this.results[n2] = Pack.littleEndianToInt(byArray2, n5);
        }
        int[] nArray = new int[8];
        for (n = 0; n < 8; ++n) {
            nArray[n] = -1640531527;
        }
        for (n = 0; n < 4; ++n) {
            this.mix(nArray);
        }
        for (n = 0; n < 2; ++n) {
            for (n4 = 0; n4 < 256; n4 += 8) {
                int n6;
                for (n2 = 0; n2 < 8; ++n2) {
                    n6 = nArray[n2];
                    int n7 = n < 1 ? this.results[n4 + n2] : this.engineState[n4 + n2];
                    nArray[n2] = n6 + n7;
                }
                this.mix(nArray);
                for (n2 = 0; n2 < 8; ++n2) {
                    n6 = n4 + n2;
                    this.engineState[n6] = nArray[n2];
                }
            }
        }
        this.isaac();
        this.initialised = true;
    }

    private void isaac() {
        int n;
        this.c = n = this.c + 1;
        this.b += n;
        for (n = 0; n < 256; ++n) {
            int n2;
            int n3;
            int[] nArray = this.engineState;
            int n4 = this.engineState[n];
            switch (n & 3) {
                default: {
                    break;
                }
                case 3: {
                    int n5 = this.a;
                    this.a = n5 ^ n5 >>> 16;
                    break;
                }
                case 2: {
                    int n6 = this.a;
                    this.a = n6 ^ n6 << 2;
                    break;
                }
                case 1: {
                    int n7 = this.a;
                    this.a = n7 ^ n7 >>> 6;
                    break;
                }
                case 0: {
                    int n8 = this.a;
                    this.a = n8 ^ n8 << 13;
                }
            }
            this.a = n3 = this.a + nArray[n + 128 & 0xFF];
            nArray[n] = n3 = nArray[n4 >>> 2 & 0xFF] + n3 + this.b;
            this.b = n2 = nArray[n3 >>> 10 & 0xFF] + n4;
            this.results[n] = n2;
        }
    }

    private void mix(int[] nArray) {
        int n;
        int n2;
        int n3 = nArray[1];
        int n4 = nArray[0] ^ n3 << 11;
        int n5 = n4;
        int[] nArray2 = nArray;
        nArray2[0] = n5;
        nArray2[3] = n5 = nArray2[3] + n5;
        int n6 = nArray2[2];
        int n7 = n6;
        int[] nArray3 = nArray;
        nArray[1] = n3 += n7;
        nArray3[1] = n3 ^= n7 >>> 2;
        nArray[4] = n7 = nArray3[4] + n3;
        nArray[2] = n2 = n6 + n5;
        nArray2[2] = n2 ^= n5 << 8;
        int n8 = nArray2[5] + n2;
        int[] nArray4 = nArray;
        int[] nArray5 = nArray;
        nArray[5] = n8;
        nArray[3] = n5 += n7;
        nArray5[3] = n5 ^= n7 >>> 16;
        nArray[6] = n5 = nArray5[6] + n5;
        nArray[4] = n7 += n8;
        nArray4[4] = n7 ^= n8 << 10;
        nArray[7] = n7 = nArray4[7] + n7;
        nArray[5] = n8 += n5;
        nArray[5] = n8 ^= n5 >>> 4;
        n8 = n4 + n8;
        int n9 = n3;
        nArray[0] = n8;
        nArray[6] = n3 = n5 + n7;
        nArray[6] = n3 ^= n7 << 8;
        nArray[1] = n3 = n9 + n3;
        nArray[7] = n5 = n7 + n8;
        nArray[7] = n = n5 ^ n8 >>> 9;
        nArray[2] = n2 + n;
        nArray[0] = n8 + n3;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.setKey(((KeyParameter)cipherParameters).getKey());
            return;
        }
        throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a.a(cipherParameters, b.a.a("invalid parameter passed to ISAAC init - ")));
    }

    @Override
    public byte returnByte(byte by) {
        if (this.index == 0) {
            ISAACEngine iSAACEngine = this;
            iSAACEngine.isaac();
            iSAACEngine.keyStream = Pack.intToBigEndian(iSAACEngine.results);
        }
        int n = this.index;
        this.index = n + 1 & 0x3FF;
        return (byte)(this.keyStream[n] ^ by);
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.initialised) {
            if (n + n2 <= byArray.length) {
                if (n3 + n2 <= byArray2.length) {
                    for (int k = 0; k < n2; ++k) {
                        if (this.index == 0) {
                            ISAACEngine iSAACEngine = this;
                            iSAACEngine.isaac();
                            iSAACEngine.keyStream = Pack.intToBigEndian(iSAACEngine.results);
                        }
                        ISAACEngine iSAACEngine = this;
                        int n4 = k + n3;
                        byte[] byArray3 = iSAACEngine.keyStream;
                        int n5 = iSAACEngine.index;
                        byArray2[n4] = (byte)(byArray3[n5] ^ byArray[k + n]);
                        iSAACEngine.index = n5 + 1 & 0x3FF;
                    }
                    return n2;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public String getAlgorithmName() {
        return "ISAAC";
    }

    @Override
    public void reset() {
        ISAACEngine iSAACEngine = this;
        iSAACEngine.setKey(iSAACEngine.workingKey);
    }
}

