/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RC2Parameters;

public class RC2Engine
implements BlockCipher {
    private static byte[] piTable = new byte[]{-39, 120, -7, -60, 25, -35, -75, -19, 40, -23, -3, 121, 74, -96, -40, -99, -58, 126, 55, -125, 43, 118, 83, -114, 98, 76, 100, -120, 68, -117, -5, -94, 23, -102, 89, -11, -121, -77, 79, 19, 97, 69, 109, -115, 9, -127, 125, 50, -67, -113, 64, -21, -122, -73, 123, 11, -16, -107, 33, 34, 92, 107, 78, -126, 84, -42, 101, -109, -50, 96, -78, 28, 115, 86, -64, 20, -89, -116, -15, -36, 18, 117, -54, 31, 59, -66, -28, -47, 66, 61, -44, 48, -93, 60, -74, 38, 111, -65, 14, -38, 70, 105, 7, 87, 39, -14, 29, -101, -68, -108, 67, 3, -8, 17, -57, -10, -112, -17, 62, -25, 6, -61, -43, 47, -56, 102, 30, -41, 8, -24, -22, -34, -128, 82, -18, -9, -124, -86, 114, -84, 53, 77, 106, 42, -106, 26, -46, 113, 90, 21, 73, 116, 75, -97, -48, 94, 4, 24, -92, -20, -62, -32, 65, 110, 15, 81, -53, -52, 36, -111, -81, 80, -95, -12, 112, 57, -103, 124, 58, -123, 35, -72, -76, 122, -4, 2, 54, 91, 37, 85, -105, 49, 45, 93, -6, -104, -29, -118, -110, -82, 5, -33, 41, 16, 103, 108, -70, -55, -45, 0, -26, -49, -31, -98, -88, 44, 99, 22, 1, 63, 88, -30, -119, -87, 13, 56, 52, 27, -85, 51, -1, -80, -69, 72, 12, 95, -71, -79, -51, 46, -59, -13, -37, 71, -27, -91, -100, 119, 10, -90, 32, 104, -2, 127, -63, -83};
    private static final int BLOCK_SIZE = 8;
    private int[] workingKey;
    private boolean encrypting;

    private int[] generateWorkingKey(byte[] byArray, int n) {
        int n2;
        Object object;
        int n3;
        Object object2 = new int[128];
        for (n3 = 0; n3 != byArray.length; ++n3) {
            object2[n3] = byArray[n3] & 0xFF;
        }
        int n4 = byArray.length;
        if (n4 < 128) {
            n3 = 0;
            object = object2[n4 - 1];
            while (true) {
                object = piTable[object + object2[n3++] & 0xFF] & 0xFF;
                int n5 = n4 + 1;
                object2[n4] = object;
                if (n5 >= 128) break;
                n4 = n5;
            }
        }
        n4 = n + 7 >> 3;
        byte[] byArray2 = piTable;
        object = 128 - n4;
        n = byArray2[object2[object] & 255 >> (-n & 7)] & 0xFF;
        object2[object] = n;
        for (n2 = (v267774) - 1; n2 >= 0; --n2) {
            n = piTable[n ^ object2[n2 + n4]] & 0xFF;
            object2[n2] = n;
        }
        n4 = 64;
        int[] nArray = new int[64];
        for (n2 = 0; n2 != n4; ++n2) {
            int n6 = n2 * 2;
            object = n6;
            nArray[n2] = (int)(object2[n6] + (object2[object + true] << 8));
        }
        return nArray;
    }

    private int rotateWordLeft(int n, int n2) {
        int n3 = n & 0xFFFF;
        return n3 << n2 | n3 >> 16 - n2;
    }

    private void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ((byArray[n + 7] & 0xFF) << 8) + (byArray[n + 6] & 0xFF);
        int n4 = ((byArray[n + 5] & 0xFF) << 8) + (byArray[n + 4] & 0xFF);
        int n5 = ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
        int n6 = ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 0] & 0xFF);
        for (n = 0; n <= 16; n += 4) {
            n6 = this.rotateWordLeft(n6 + (n5 & ~n3) + (n4 & n3) + this.workingKey[n], 1);
            n5 = this.rotateWordLeft(n5 + (n4 & ~n6) + (n3 & n6) + this.workingKey[n + 1], 2);
            n4 = this.rotateWordLeft(n4 + (n3 & ~n5) + (n6 & n5) + this.workingKey[n + 2], 3);
            n3 = this.rotateWordLeft(n3 + (n6 & ~n4) + (n5 & n4) + this.workingKey[n + 3], 5);
        }
        int n7 = n3;
        int[] nArray = this.workingKey;
        int n8 = n5 + nArray[(n6 += nArray[n3 & 0x3F]) & 0x3F];
        n3 = n4 + nArray[n8 & 0x3F];
        n4 = n7 + this.workingKey[n3 & 0x3F];
        for (n5 = 20; n5 <= 40; n5 += 4) {
            n6 = this.rotateWordLeft(n6 + (n8 & ~n4) + (n3 & n4) + this.workingKey[n5], 1);
            n8 = this.rotateWordLeft(n8 + (n3 & ~n6) + (n4 & n6) + this.workingKey[n5 + 1], 2);
            n3 = this.rotateWordLeft(n3 + (n4 & ~n8) + (n6 & n8) + this.workingKey[n5 + 2], 3);
            n4 = this.rotateWordLeft(n4 + (n6 & ~n3) + (n8 & n3) + this.workingKey[n5 + 3], 5);
        }
        int[] nArray2 = this.workingKey;
        n3 += nArray2[(n8 += nArray2[(n6 += nArray2[n4 & 0x3F]) & 0x3F]) & 0x3F];
        n4 += this.workingKey[n3 & 0x3F];
        for (int k = 44; k < 64; k += 4) {
            n6 = this.rotateWordLeft(n6 + (n8 & ~n4) + (n3 & n4) + this.workingKey[k], 1);
            n8 = this.rotateWordLeft(n8 + (n3 & ~n6) + (n4 & n6) + this.workingKey[k + 1], 2);
            n3 = this.rotateWordLeft(n3 + (n4 & ~n8) + (n6 & n8) + this.workingKey[k + 2], 3);
            n4 = this.rotateWordLeft(n4 + (n6 & ~n3) + (n8 & n3) + this.workingKey[k + 3], 5);
        }
        int n9 = n2 + 0;
        byArray2[n9] = (byte)n6;
        n9 = n2 + 1;
        byArray2[n9] = (byte)(n6 >> 8);
        n9 = n2 + 2;
        byArray2[n9] = (byte)n8;
        n9 = n2 + 3;
        byArray2[n9] = (byte)(n8 >> 8);
        n9 = n2 + 4;
        byArray2[n9] = (byte)n3;
        n9 = n2 + 5;
        byArray2[n9] = (byte)(n3 >> 8);
        n9 = n2 + 6;
        byArray2[n9] = (byte)n4;
        n9 = n2 + 7;
        byArray2[n9] = (byte)(n4 >> 8);
    }

    private void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = ((byArray[n + 7] & 0xFF) << 8) + (byArray[n + 6] & 0xFF);
        int n4 = ((byArray[n + 5] & 0xFF) << 8) + (byArray[n + 4] & 0xFF);
        int n5 = ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
        int n6 = ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 0] & 0xFF);
        for (n = 60; n >= 44; n -= 4) {
            n3 = this.rotateWordLeft(n3, 11) - ((n6 & ~n4) + (n5 & n4) + this.workingKey[n + 3]);
            n4 = this.rotateWordLeft(n4, 13) - ((n3 & ~n5) + (n6 & n5) + this.workingKey[n + 2]);
            n5 = this.rotateWordLeft(n5, 14) - ((n4 & ~n6) + (n3 & n6) + this.workingKey[n + 1]);
            n6 = this.rotateWordLeft(n6, 15) - ((n5 & ~n3) + (n4 & n3) + this.workingKey[n]);
        }
        int n7 = n6;
        int[] nArray = this.workingKey;
        n3 -= nArray[n4 & 0x3F];
        int n8 = n6;
        n6 = n4 - nArray[n5 & 0x3F];
        int n9 = n5 - nArray[n8 & 0x3F];
        n4 = n7 - this.workingKey[n3 & 0x3F];
        for (n5 = 40; n5 >= 20; n5 -= 4) {
            n3 = this.rotateWordLeft(n3, 11) - ((n4 & ~n6) + (n9 & n6) + this.workingKey[n5 + 3]);
            n6 = this.rotateWordLeft(n6, 13) - ((n3 & ~n9) + (n4 & n9) + this.workingKey[n5 + 2]);
            n9 = this.rotateWordLeft(n9, 14) - ((n6 & ~n4) + (n3 & n4) + this.workingKey[n5 + 1]);
            n4 = this.rotateWordLeft(n4, 15) - ((n9 & ~n3) + (n6 & n3) + this.workingKey[n5]);
        }
        int[] nArray2 = this.workingKey;
        n3 -= nArray2[n6 & 0x3F];
        n6 -= nArray2[n9 & 0x3F];
        n9 -= nArray2[n4 & 0x3F];
        n4 -= this.workingKey[n3 & 0x3F];
        for (int k = 16; k >= 0; k -= 4) {
            n3 = this.rotateWordLeft(n3, 11) - ((n4 & ~n6) + (n9 & n6) + this.workingKey[k + 3]);
            n6 = this.rotateWordLeft(n6, 13) - ((n3 & ~n9) + (n4 & n9) + this.workingKey[k + 2]);
            n9 = this.rotateWordLeft(n9, 14) - ((n6 & ~n4) + (n3 & n4) + this.workingKey[k + 1]);
            n4 = this.rotateWordLeft(n4, 15) - ((n9 & ~n3) + (n6 & n3) + this.workingKey[k]);
        }
        int n10 = n2 + 0;
        byArray2[n10] = (byte)n4;
        n10 = n2 + 1;
        byArray2[n10] = (byte)(n4 >> 8);
        n10 = n2 + 2;
        byArray2[n10] = (byte)n9;
        n10 = n2 + 3;
        byArray2[n10] = (byte)(n9 >> 8);
        n10 = n2 + 4;
        byArray2[n10] = (byte)n6;
        n10 = n2 + 5;
        byArray2[n10] = (byte)(n6 >> 8);
        n10 = n2 + 6;
        byArray2[n10] = (byte)n3;
        n10 = n2 + 7;
        byArray2[n10] = (byte)(n3 >> 8);
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        block4: {
            block3: {
                block2: {
                    ((RC2Engine)object).encrypting = bl;
                    if (!(cipherParameters instanceof RC2Parameters)) break block2;
                    RC2Engine rC2Engine = object;
                    RC2Parameters rC2Parameters = (RC2Parameters)cipherParameters;
                    Object object = rC2Parameters.getKey();
                    rC2Engine.workingKey = rC2Engine.generateWorkingKey((byte[])object, rC2Parameters.getEffectiveKeyBits());
                    break block3;
                }
                if (!(cipherParameters instanceof KeyParameter)) break block4;
                byte[] byArray = ((KeyParameter)cipherParameters).getKey();
                ((RC2Engine)object).workingKey = ((RC2Engine)object).generateWorkingKey(byArray, byArray.length * 8);
            }
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a.a("invalid parameter passed to RC2 init - ")));
    }

    @Override
    public void reset() {
    }

    @Override
    public String getAlgorithmName() {
        return "RC2";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public final int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.workingKey != null) {
            if (n + 8 <= byArray.length) {
                if (n2 + 8 <= byArray2.length) {
                    if (this.encrypting) {
                        this.encryptBlock(byArray, n, byArray2, n2);
                    } else {
                        this.decryptBlock(byArray, n, byArray2, n2);
                    }
                    return 8;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("RC2 engine not initialised");
    }
}

