/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RC5Parameters;

public class RC532Engine
implements BlockCipher {
    private static final int P32 = -1209970333;
    private static final int Q32 = -1640531527;
    private int _noRounds = 12;
    private int[] _S = null;
    private boolean forEncryption;

    private void setKey(byte[] byArray) {
        int[] nArray;
        int n;
        int n2 = (byArray.length + 3) / 4;
        int[] nArray2 = new int[n2];
        for (int k = 0; k != byArray.length; ++k) {
            n = k / 4;
            nArray2[n] = nArray2[n] + ((byArray[k] & 0xFF) << k % 4 * 8);
        }
        int[] nArray3 = new int[(this._noRounds + 1) * 2];
        this._S = nArray3;
        nArray3[0] = -1209970333;
        int n3 = 1;
        while (true) {
            nArray = this._S;
            if (n3 >= this._S.length) break;
            nArray[n3] = nArray[n3 - 1] + -1640531527;
            ++n3;
        }
        n3 = n2 > nArray.length ? n2 * 3 : nArray.length * 3;
        int n4 = 0;
        n = 0;
        int n5 = 0;
        int n6 = 0;
        for (int k = 0; k < n3; ++k) {
            RC532Engine rC532Engine = this;
            int[] nArray4 = rC532Engine._S;
            n4 = rC532Engine.rotateLeft(rC532Engine._S[n5] + n4 + n, 3);
            int n7 = n;
            nArray4[n5] = n4;
            n = nArray2[n6] + n4 + n;
            nArray2[n6] = n = rC532Engine.rotateLeft(n, n4 + n7);
            n5 = (n5 + 1) % this._S.length;
            n6 = (n6 + 1) % n2;
        }
    }

    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.bytesToWord(byArray, n) + this._S[0];
        n = this.bytesToWord(byArray, n + 4) + this._S[1];
        for (int k = 1; k <= this._noRounds; ++k) {
            int n4 = n;
            int n5 = this.rotateLeft(n3 ^ n, n);
            n3 = k * 2;
            n = n5 + this._S[n3];
            n3 = this.rotateLeft(n4 ^ n, n) + this._S[n3 + 1];
            int n6 = n;
            n = n3;
            n3 = n6;
        }
        RC532Engine rC532Engine = this;
        rC532Engine.wordToBytes(n3, byArray2, n2);
        int n7 = n2 + 4;
        rC532Engine.wordToBytes(n, byArray2, n7);
        return 8;
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        RC532Engine rC532Engine = this;
        int n3 = rC532Engine.bytesToWord(byArray, n);
        int n4 = rC532Engine.bytesToWord(byArray, n + 4);
        for (n = (v271134)._noRounds; n >= 1; --n) {
            int n5 = n3;
            RC532Engine rC532Engine2 = this;
            int n6 = n4;
            n4 = n * 2;
            n3 = rC532Engine2.rotateRight(n6 - this._S[n4 + 1], n3) ^ n3;
            n4 = this.rotateRight(n5 - rC532Engine2._S[n4], n3) ^ n3;
            int n7 = n4;
            n4 = n3;
            n3 = n7;
        }
        RC532Engine rC532Engine3 = this;
        rC532Engine3.wordToBytes(n3 - this._S[0], byArray2, n2);
        this.wordToBytes(n4 - rC532Engine3._S[1], byArray2, n2 + 4);
        return 8;
    }

    private int rotateLeft(int n, int n2) {
        int n3 = n2 & 0x1F;
        return n << n3 | n >>> 32 - n3;
    }

    private int rotateRight(int n, int n2) {
        int n3 = n2 & 0x1F;
        return n >>> n3 | n << 32 - n3;
    }

    private int bytesToWord(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private void wordToBytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        int n3 = n2 + 1;
        byArray[n3] = (byte)(n >> 8);
        n3 = n2 + 2;
        byArray[n3] = (byte)(n >> 16);
        n3 = n2 + 3;
        byArray[n3] = (byte)(n >> 24);
    }

    @Override
    public String getAlgorithmName() {
        return "RC5-32";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        block4: {
            block3: {
                block2: {
                    if (!(cipherParameters instanceof RC5Parameters)) break block2;
                    cipherParameters = (RC5Parameters)cipherParameters;
                    this._noRounds = ((RC5Parameters)cipherParameters).getRounds();
                    this.setKey(((RC5Parameters)cipherParameters).getKey());
                    break block3;
                }
                if (!(cipherParameters instanceof KeyParameter)) break block4;
                this.setKey(((KeyParameter)cipherParameters).getKey());
            }
            this.forEncryption = bl;
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a.a("invalid parameter passed to RC532 init - ")));
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        return this.forEncryption ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
    }

    @Override
    public void reset() {
    }
}

