/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public abstract class SerpentEngineBase
implements BlockCipher {
    public static final int BLOCK_SIZE = 16;
    public static final int ROUNDS = 32;
    public static final int PHI = -1640531527;
    public boolean encrypting;
    public int[] wKey;
    public int X0;
    public int X1;
    public int X2;
    public int X3;

    public static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    public static int rotateRight(int n, int n2) {
        return n >>> n2 | n << -n2;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.encrypting = bl;
            this.wKey = this.makeWorkingKey(((KeyParameter)cipherParameters).getKey());
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a.a("invalid parameter passed to ").append(this.getAlgorithmName()).append(" init - ")));
    }

    @Override
    public String getAlgorithmName() {
        return "Serpent";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public final int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.wKey != null) {
            if (n + 16 <= byArray.length) {
                if (n2 + 16 <= byArray2.length) {
                    if (this.encrypting) {
                        this.encryptBlock(byArray, n, byArray2, n2);
                    } else {
                        this.decryptBlock(byArray, n, byArray2, n2);
                    }
                    return 16;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
    }

    public final void sb0(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4;
        n4 = n ^ n4;
        int n7 = n3 ^ n4;
        int n8 = n2 ^ n7;
        this.X3 = n5 = n & n6 ^ n8;
        this.X2 = n8 ^ (n3 | (n ^= n2 & n4));
        n2 = n5 & (n7 ^ n);
        this.X1 = ~n7 ^ n2;
        this.X0 = n2 ^ ~n;
    }

    public final void ib0(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n;
        int n7 = ~n;
        n ^= n2;
        n2 = n4 ^ (n7 | n);
        this.X2 = n5 = n ^ (n3 ^= n2);
        n = n7 ^ n4 & n;
        this.X1 = n4 = n2 ^ n5 & n;
        this.X3 = n2 = n6 & n2 ^ (n3 | n4);
        this.X0 = n2 ^ (n3 ^ n);
    }

    public final void sb1(int n, int n2, int n3, int n4) {
        int n5 = n;
        n = n2 ^ ~n;
        n3 ^= n5 | n;
        int n6 = n;
        int n7 = n;
        this.X2 = n = n4 ^ n3;
        int n8 = n6 ^ n;
        this.X3 = n = n8 ^ n3 & (n2 ^= n4 | n7);
        int n9 = n3 ^ n2;
        this.X1 = n ^ n9;
        this.X0 = n3 ^ n8 & n9;
    }

    public final void ib1(int n, int n2, int n3, int n4) {
        n4 = n2 ^ n4;
        int n5 = n4 ^ (n ^= n2 & n4);
        int n6 = n;
        this.X3 = n3 ^= n5;
        n = n2 ^ n4 & n;
        this.X1 = n6 ^ (n3 | n);
        int n7 = ~this.X1;
        int n8 = n3 ^ n;
        this.X0 = n7 ^ n8;
        this.X2 = n5 ^ (n7 | n8);
    }

    public final void sb2(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = ~n;
        int n7 = n2 ^ n4;
        int n8 = n;
        this.X0 = n5 = n7 ^ n3 & n6;
        n = n3 ^ n6;
        n2 &= n3 ^ n5;
        this.X3 = n3 = n ^ n2;
        this.X2 = n5 = n8 ^ (n4 | n2) & (n5 | n);
        this.X1 = n7 ^ n3 ^ (n5 ^ (n4 | n6));
    }

    public final void ib2(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n3;
        int n7 = n3;
        n3 = n2 ^ n4;
        int n8 = ~n3;
        int n9 = n ^ n7;
        int n10 = n6 ^ n3;
        this.X0 = n5 = n9 ^ n2 & n10;
        this.X3 = n = n3 ^ (n9 | n4 ^ (n | n8));
        n2 = ~n10;
        this.X1 = n2 ^ (n5 |= n);
        this.X2 = n4 & n2 ^ (n9 ^ n5);
    }

    public final void sb3(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n2;
        int n7 = n4;
        int n8 = n ^ n2;
        int n9 = n & n3;
        n |= n4;
        n3 ^= n4;
        n4 = n9 | n8 & n;
        int n10 = n;
        this.X2 = n = n3 ^ n4;
        n2 = n4 ^ (n2 ^ n10);
        this.X0 = n5 = n8 ^ n3 & n2;
        n5 = n & n5;
        this.X1 = n2 ^ n5;
        this.X3 = (n6 | n7) ^ (n3 ^ n5);
    }

    public final void ib3(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        n |= n2;
        n2 = n6 ^ n3;
        int n7 = n5 ^ n6 & n2;
        int n8 = n7;
        n3 ^= n8;
        n8 = n4 | n8;
        int n9 = n2 ^ n8;
        int n10 = n;
        this.X0 = n9;
        n = n4 ^ (n2 | n8);
        this.X2 = n3 ^ n;
        n = n10 ^ n;
        this.X3 = n2 = n7 ^ n9 & n;
        this.X1 = n2 ^ (n9 ^ n);
    }

    public final void sb4(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n;
        int n7 = n2 | (n3 ^= n4 & (n ^= n4));
        this.X3 = n ^ n7;
        this.X0 = n4 = n3 ^ (n | (n2 ^= 0xFFFFFFFF));
        int n8 = n7;
        n7 = n ^ n2;
        this.X2 = n = n6 & n4 ^ n8 & n7;
        this.X1 = n5 ^ n3 ^ n7 & n;
    }

    public final void ib4(int n, int n2, int n3, int n4) {
        int n5 = n2 ^ n & (n3 | n4);
        int n6 = n2 = n5;
        int n7 = n3 ^ n & n2;
        n2 = n7;
        int n8 = n;
        this.X1 = n = n4 ^ n2;
        n2 = ~n8;
        this.X3 = n3 = n6 ^ n7 & n;
        int n9 = n4 ^ (n | n2);
        this.X0 = n3 ^ n9;
        this.X2 = n5 & n9 ^ (n ^ n2);
    }

    public final void sb5(int n, int n2, int n3, int n4) {
        int n5 = n2;
        int n6 = n2;
        n2 = ~n;
        int n7 = n ^ n6;
        int n8 = n2;
        int n9 = n ^ n4;
        this.X0 = n = n3 ^ n2 ^ (n7 | n9);
        n2 = n4 & n;
        this.X1 = n3 = n2 ^ (n7 ^ n);
        n = n8 | n;
        this.X2 = (n7 | n2) ^ (n9 ^= n);
        this.X3 = n5 ^ n2 ^ n3 & n9;
    }

    public final void ib5(int n, int n2, int n3, int n4) {
        int n5 = n2;
        int n6 = n4;
        int n7 = n4;
        n4 = ~n3;
        int n8 = n7 ^ n2 & n4;
        int n9 = n2;
        int n10 = n & n8;
        this.X3 = n2 = n10 ^ (n2 ^ n4);
        n2 = n9 | n2;
        this.X1 = n8 ^ n & n2;
        n8 = n | n6;
        this.X0 = n8 ^ (n4 ^ n2);
        this.X2 = n5 & n8 ^ (n10 | n ^ n3);
    }

    public final void sb6(int n, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = ~n;
        n3 = n2 ^ (n ^= n4);
        int n7 = n5 ^ (n6 | n);
        int n8 = n;
        this.X1 = n = n2 ^ n7;
        n = n4 ^ (n8 | n);
        this.X2 = n2 = n3 ^ n7 & n;
        int n9 = n7 ^ n;
        this.X0 = n2 ^ n9;
        this.X3 = ~n7 ^ n3 & n9;
    }

    public final void ib6(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4;
        int n7 = n;
        int n8 = n7 ^ n2;
        int n9 = n3 ^ n8;
        n3 = n4 ^ (n3 | (n ^= 0xFFFFFFFF));
        this.X1 = n9 ^ n3;
        n4 = n8 ^ n9 & n3;
        this.X3 = n5 = n3 ^ (n2 | n4);
        n5 = n2 | n5;
        this.X0 = n4 ^ n5;
        this.X2 = n6 & n ^ (n9 ^ n5);
    }

    public final void sb7(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n3;
        n3 = n2 ^ n3;
        int n7 = n4 ^ n6 & n3;
        int n8 = n ^ n7;
        int n9 = n;
        this.X1 = n = n2 ^ n8 & (n4 | n3);
        n = n7 | n;
        this.X3 = n2 = n3 ^ n9 & n8;
        n = n8 ^ n;
        this.X2 = n5 = n7 ^ n2 & n;
        this.X0 = ~n ^ n2 & n5;
    }

    public final void ib7(int n, int n2, int n3, int n4) {
        int n5 = n3 | n & n2;
        int n6 = n3;
        int n7 = n2;
        int n8 = n4 & (n | n2);
        this.X3 = n2 = n5 ^ n8;
        n3 = ~n4;
        n8 = n7 ^ n8;
        this.X1 = n3 = n ^ (n8 | n2 ^ n3);
        this.X0 = n8 = n6 ^ n8 ^ (n4 | n3);
        this.X2 = n5 ^ n3 ^ (n8 ^ n & n2);
    }

    public final void LT() {
        SerpentEngineBase serpentEngineBase = this;
        int n = SerpentEngineBase.rotateLeft(serpentEngineBase.X0, 13);
        int n2 = SerpentEngineBase.rotateLeft(serpentEngineBase.X2, 3);
        int n3 = n;
        SerpentEngineBase serpentEngineBase2 = this;
        int n4 = serpentEngineBase2.X1 ^ n ^ n2;
        this.X1 = SerpentEngineBase.rotateLeft(n4, 1);
        serpentEngineBase2.X3 = n = SerpentEngineBase.rotateLeft(serpentEngineBase2.X3 ^ n2 ^ n << 3, 7);
        this.X0 = SerpentEngineBase.rotateLeft(n3 ^ serpentEngineBase2.X1 ^ n, 5);
        serpentEngineBase.X2 = SerpentEngineBase.rotateLeft(n2 ^ this.X3 ^ this.X1 << 7, 22);
    }

    public final void inverseLT() {
        SerpentEngineBase serpentEngineBase = this;
        int n = SerpentEngineBase.rotateRight(serpentEngineBase.X2, 22) ^ this.X3 ^ this.X1 << 7;
        int n2 = this.X3;
        int n3 = SerpentEngineBase.rotateRight(serpentEngineBase.X0, 5) ^ this.X1 ^ n2;
        n2 = SerpentEngineBase.rotateRight(n2, 7);
        this.X3 = n2 ^ n ^ n3 << 3;
        this.X1 = SerpentEngineBase.rotateRight(this.X1, 1) ^ n3 ^ n;
        this.X2 = SerpentEngineBase.rotateRight(n, 3);
        serpentEngineBase.X0 = SerpentEngineBase.rotateRight(n3, 13);
    }

    public abstract int[] makeWorkingKey(byte[] var1);

    public abstract void encryptBlock(byte[] var1, int var2, byte[] var3, int var4);

    public abstract void decryptBlock(byte[] var1, int var2, byte[] var3, int var4);
}

