/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class SkipjackEngine
implements BlockCipher {
    public static final int BLOCK_SIZE = 8;
    public static short[] ftable = new short[]{163, 215, 9, 131, 248, 72, 246, 244, 179, 33, 21, 120, 153, 177, 175, 249, 231, 45, 77, 138, 206, 76, 202, 46, 82, 149, 217, 30, 78, 56, 68, 40, 10, 223, 2, 160, 23, 241, 96, 104, 18, 183, 122, 195, 233, 250, 61, 83, 150, 132, 107, 186, 242, 99, 154, 25, 124, 174, 229, 245, 247, 22, 106, 162, 57, 182, 123, 15, 193, 147, 129, 27, 238, 180, 26, 234, 208, 145, 47, 184, 85, 185, 218, 133, 63, 65, 191, 224, 90, 88, 128, 95, 102, 11, 216, 144, 53, 213, 192, 167, 51, 6, 101, 105, 69, 0, 148, 86, 109, 152, 155, 118, 151, 252, 178, 194, 176, 254, 219, 32, 225, 235, 214, 228, 221, 71, 74, 29, 66, 237, 158, 110, 73, 60, 205, 67, 39, 210, 7, 212, 222, 199, 103, 24, 137, 203, 48, 31, 141, 198, 143, 170, 200, 116, 220, 201, 93, 92, 49, 164, 112, 136, 97, 44, 159, 13, 43, 135, 80, 130, 84, 100, 38, 125, 3, 64, 52, 75, 28, 115, 209, 196, 253, 59, 204, 251, 127, 171, 230, 62, 91, 165, 173, 4, 35, 156, 20, 81, 34, 240, 41, 121, 113, 126, 255, 140, 14, 226, 12, 239, 188, 114, 117, 111, 55, 161, 236, 211, 142, 98, 139, 134, 16, 232, 8, 119, 17, 190, 146, 79, 36, 197, 50, 54, 157, 207, 243, 166, 187, 172, 94, 108, 169, 19, 87, 37, 181, 227, 189, 168, 58, 1, 5, 89, 42, 70};
    private int[] key0;
    private int[] key1;
    private int[] key2;
    private int[] key3;
    private boolean encrypting;

    private int g(int n, int n2) {
        int n3 = n2;
        n2 = n3 >> 8 & 0xFF;
        int n4 = n3 & 0xFF;
        short[] sArray = ftable;
        n2 = ftable[n4 ^ this.key0[n]] ^ n2;
        n4 = sArray[n2 ^ this.key1[n]] ^ n4;
        int n5 = ftable[n4 ^ this.key2[n]] ^ n2;
        int n6 = sArray[n5 ^ this.key3[n]] ^ n4;
        return (n5 << 8) + n6;
    }

    private int h(int n, int n2) {
        int n3 = n2;
        n2 = n3 & 0xFF;
        int n4 = n3 >> 8 & 0xFF;
        n2 = ftable[n4 ^ this.key3[n]] ^ n2;
        n4 = ftable[n2 ^ this.key2[n]] ^ n4;
        n2 = ftable[n4 ^ this.key1[n]] ^ n2;
        return ((ftable[n2 ^ this.key0[n]] ^ n4) << 8) + n2;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            SkipjackEngine skipjackEngine = this;
            byte[] byArray = ((KeyParameter)cipherParameters).getKey();
            skipjackEngine.encrypting = bl;
            skipjackEngine.key0 = new int[32];
            skipjackEngine.key1 = new int[32];
            skipjackEngine.key2 = new int[32];
            skipjackEngine.key3 = new int[32];
            for (int k = 0; k < 32; ++k) {
                SkipjackEngine skipjackEngine2 = this;
                int n = k * 4;
                skipjackEngine2.key0[k] = byArray[n % 10] & 0xFF;
                skipjackEngine2.key1[k] = byArray[(n + 1) % 10] & 0xFF;
                skipjackEngine2.key2[k] = byArray[(n + 2) % 10] & 0xFF;
                skipjackEngine2.key3[k] = byArray[(n + 3) % 10] & 0xFF;
            }
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a.a("invalid parameter passed to SKIPJACK init - ")));
    }

    @Override
    public String getAlgorithmName() {
        return "SKIPJACK";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.key1 != null) {
            if (n + 8 <= byArray.length) {
                if (n2 + 8 <= byArray2.length) {
                    if (this.encrypting) {
                        this.encryptBlock(byArray, n, byArray2, n2);
                    } else {
                        this.decryptBlock(byArray, n, byArray2, n2);
                    }
                    return 8;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("SKIPJACK engine not initialised");
    }

    @Override
    public void reset() {
    }

    public int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = (byArray[n + 0] << 8) + (byArray[n + 1] & 0xFF);
        int n4 = (byArray[n + 2] << 8) + (byArray[n + 3] & 0xFF);
        int n5 = (byArray[n + 4] << 8) + (byArray[n + 5] & 0xFF);
        int n6 = (byArray[n + 6] << 8) + (byArray[n + 7] & 0xFF);
        n = 0;
        for (int k = 0; k < 2; ++k) {
            int n7;
            int n8 = n5;
            int n9 = n4;
            n4 = n3;
            n3 = n;
            n5 = n9;
            n = n8;
            for (n7 = 0; n7 < 8; ++n7) {
                n4 = this.g(n3, n4);
                int n10 = n4 ^ n6;
                n6 = n3 + 1;
                n3 = n10 ^ n6;
                int n11 = n;
                int n12 = n5;
                int n13 = n4;
                n4 = n3;
                n3 = n6;
                n5 = n13;
                n = n12;
                n6 = n11;
            }
            int n14 = n4;
            int n15 = n5;
            int n16 = n;
            n = n3;
            n5 = n16;
            n4 = n15;
            n3 = n14;
            for (n7 = 0; n7 < 8; ++n7) {
                int n17 = n++;
                n4 = n3 ^ n4 ^ n;
                n3 = this.g(n17, n3);
                int n18 = n6;
                n6 = n5;
                n5 = n4;
                n4 = n3;
                n3 = n18;
            }
        }
        int n19 = n2 + 0;
        byArray2[n19] = (byte)(n3 >> 8);
        n19 = n2 + 1;
        byArray2[n19] = (byte)n3;
        n19 = n2 + 2;
        byArray2[n19] = (byte)(n4 >> 8);
        n19 = n2 + 3;
        byArray2[n19] = (byte)n4;
        n19 = n2 + 4;
        byArray2[n19] = (byte)(n5 >> 8);
        n19 = n2 + 5;
        byArray2[n19] = (byte)n5;
        n19 = n2 + 6;
        byArray2[n19] = (byte)(n6 >> 8);
        n19 = n2 + 7;
        byArray2[n19] = (byte)n6;
        return 8;
    }

    public int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = (byArray[n + 0] << 8) + (byArray[n + 1] & 0xFF);
        int n4 = (byArray[n + 2] << 8) + (byArray[n + 3] & 0xFF);
        int n5 = (byArray[n + 4] << 8) + (byArray[n + 5] & 0xFF);
        int n6 = (byArray[n + 6] << 8) + (byArray[n + 7] & 0xFF);
        n = 31;
        for (int k = 0; k < 2; ++k) {
            int n7;
            int n8 = n6;
            n6 = n3;
            n3 = n8;
            for (n7 = 0; n7 < 8; ++n7) {
                n4 = this.h(n, n4);
                n5 = n4 ^ n5 ^ n + 1;
                --n;
                int n9 = n3;
                int n10 = n6;
                int n11 = n4;
                n4 = n5;
                n6 = n11;
                n3 = n10;
                n5 = n9;
            }
            int n12 = n6;
            n6 = n3;
            n3 = n12;
            for (n7 = 0; n7 < 8; ++n7) {
                n3 = n4 ^ n3 ^ n + 1;
                n4 = this.h(n, n4);
                --n;
                int n13 = n4;
                int n14 = n5;
                int n15 = n6;
                n6 = n3;
                n5 = n15;
                n4 = n14;
                n3 = n13;
            }
        }
        int n16 = n2 + 0;
        byArray2[n16] = (byte)(n3 >> 8);
        n16 = n2 + 1;
        byArray2[n16] = (byte)n3;
        n16 = n2 + 2;
        byArray2[n16] = (byte)(n4 >> 8);
        n16 = n2 + 3;
        byArray2[n16] = (byte)n4;
        n16 = n2 + 4;
        byArray2[n16] = (byte)(n5 >> 8);
        n16 = n2 + 5;
        byArray2[n16] = (byte)n5;
        n16 = n2 + 6;
        byArray2[n16] = (byte)(n6 >> 8);
        n16 = n2 + 7;
        byArray2[n16] = (byte)n6;
        return 8;
    }
}

