/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public final class TwofishEngine
implements BlockCipher {
    private static final byte[][] P;
    private static final int P_00 = 1;
    private static final int P_01 = 0;
    private static final int P_02 = 0;
    private static final int P_03 = 1;
    private static final int P_04 = 1;
    private static final int P_10 = 0;
    private static final int P_11 = 0;
    private static final int P_12 = 1;
    private static final int P_13 = 1;
    private static final int P_14 = 0;
    private static final int P_20 = 1;
    private static final int P_21 = 1;
    private static final int P_22 = 0;
    private static final int P_23 = 0;
    private static final int P_24 = 0;
    private static final int P_30 = 0;
    private static final int P_31 = 1;
    private static final int P_32 = 1;
    private static final int P_33 = 0;
    private static final int P_34 = 1;
    private static final int GF256_FDBK = 361;
    private static final int GF256_FDBK_2 = 180;
    private static final int GF256_FDBK_4 = 90;
    private static final int RS_GF_FDBK = 333;
    private static final int ROUNDS = 16;
    private static final int MAX_ROUNDS = 16;
    private static final int BLOCK_SIZE = 16;
    private static final int MAX_KEY_BITS = 256;
    private static final int INPUT_WHITEN = 0;
    private static final int OUTPUT_WHITEN = 4;
    private static final int ROUND_SUBKEYS = 8;
    private static final int TOTAL_SUBKEYS = 40;
    private static final int SK_STEP = 0x2020202;
    private static final int SK_BUMP = 0x1010101;
    private static final int SK_ROTL = 9;
    private boolean encrypting = false;
    private int[] gMDS0 = new int[256];
    private int[] gMDS1 = new int[256];
    private int[] gMDS2 = new int[256];
    private int[] gMDS3 = new int[256];
    private int[] gSubKeys;
    private int[] gSBox;
    private int k64Cnt = 0;
    private byte[] workingKey = null;

    public TwofishEngine() {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        for (int k = 0; k < 256; ++k) {
            int n;
            TwofishEngine twofishEngine = this;
            byte[][] byArray = P;
            nArray[0] = n = byArray[0][k] & 0xFF;
            nArray2[0] = this.Mx_X(n) & 0xFF;
            nArray3[0] = this.Mx_Y(n) & 0xFF;
            nArray[1] = n = P[1][k] & 0xFF;
            nArray2[1] = this.Mx_X(n) & 0xFF;
            nArray3[1] = n = this.Mx_Y(n) & 0xFF;
            twofishEngine.gMDS0[k] = nArray[1] | nArray2[1] << 8 | n << 16 | n << 24;
            int n2 = nArray3[0];
            twofishEngine.gMDS1[k] = n2 | n2 << 8 | nArray2[0] << 16 | nArray[0] << 24;
            n = nArray3[1];
            twofishEngine.gMDS2[k] = nArray2[1] | n << 8 | nArray[1] << 16 | n << 24;
            n = nArray2[0];
            twofishEngine.gMDS3[k] = n | nArray[0] << 8 | nArray3[0] << 16 | n << 24;
        }
    }

    private void setKey(byte[] byArray) {
        block9: {
            block10: {
                int n;
                int n2;
                int[] nArray = new int[4];
                int[] nArray2 = new int[4];
                int[] nArray3 = new int[4];
                this.gSubKeys = new int[40];
                int n3 = this.k64Cnt;
                if (n3 < 1) break block9;
                if (n3 > 4) break block10;
                for (n3 = 0; n3 < this.k64Cnt; ++n3) {
                    n2 = n3 * 8;
                    nArray[n3] = this.BytesTo32Bits(byArray, n2);
                    nArray2[n3] = n2 = this.BytesTo32Bits(byArray, n2 + 4);
                    int n4 = this.k64Cnt - 1 - n3;
                    nArray3[n4] = this.RS_MDS_Encode(nArray[n3], n2);
                }
                for (n = 0; n < 20; ++n) {
                    TwofishEngine twofishEngine = this;
                    int n5 = n * 0x2020202;
                    n3 = n5;
                    n3 = this.F32(n3 + 0x1010101, nArray2);
                    n3 = n3 << 8 | n3 >>> 24;
                    n2 = twofishEngine.F32(n5, nArray) + n3;
                    int[] nArray4 = twofishEngine.gSubKeys;
                    int n6 = n3;
                    n3 = n * 2;
                    nArray4[n3] = n2;
                    twofishEngine.gSubKeys[++n3] = (n2 += n6) << 9 | n2 >>> 23;
                }
                n = nArray3[0];
                int n7 = nArray3[1];
                int n8 = nArray3[2];
                int n9 = nArray3[3];
                this.gSBox = new int[1024];
                block8: for (n3 = 0; n3 < 256; ++n3) {
                    int n10;
                    int n11;
                    int n12;
                    block11: {
                        switch (this.k64Cnt & 3) {
                            default: {
                                continue block8;
                            }
                            case 3: {
                                n12 = n3;
                                n11 = n3;
                                n10 = n3;
                                n2 = n3;
                                break;
                            }
                            case 2: {
                                n12 = n3;
                                n11 = n3;
                                n10 = n3;
                                n2 = n3;
                                break block11;
                            }
                            case 1: {
                                TwofishEngine twofishEngine = this;
                                n2 = n3 * 2;
                                byte[][] byArray2 = P;
                                twofishEngine.gSBox[n2] = this.gMDS0[P[0][n3] & 0xFF ^ this.b0(n)];
                                twofishEngine.gSBox[n2 + 1] = this.gMDS1[byArray2[0][n3] & 0xFF ^ this.b1(n)];
                                twofishEngine.gSBox[n2 + 512] = this.gMDS2[byArray2[1][n3] & 0xFF ^ this.b2(n)];
                                twofishEngine.gSBox[n2 + 513] = this.gMDS3[byArray2[1][n3] & 0xFF ^ this.b3(n)];
                                continue block8;
                            }
                            case 0: {
                                n2 = P[1][n3] & 0xFF ^ this.b0(n9);
                                n10 = P[0][n3] & 0xFF ^ this.b1(n9);
                                n11 = P[0][n3] & 0xFF ^ this.b2(n9);
                                n12 = P[1][n3] & 0xFF ^ this.b3(n9);
                            }
                        }
                        n2 = P[1][n2] & 0xFF ^ this.b0(n8);
                        n10 = P[1][n10] & 0xFF ^ this.b1(n8);
                        n11 = P[0][n11] & 0xFF ^ this.b2(n8);
                        n12 = P[0][n12] & 0xFF ^ this.b3(n8);
                    }
                    TwofishEngine twofishEngine = this;
                    int n13 = n3 * 2;
                    byte[][] byArray3 = P;
                    byte[] byArray4 = P[0];
                    twofishEngine.gSBox[n13] = this.gMDS0[byArray4[byArray4[n2] & 0xFF ^ this.b0(n7)] & 0xFF ^ this.b0(n)];
                    twofishEngine.gSBox[n13 + 1] = this.gMDS1[byArray3[0][byArray3[1][n10] & 0xFF ^ this.b1(n7)] & 0xFF ^ this.b1(n)];
                    twofishEngine.gSBox[n13 + 512] = this.gMDS2[byArray3[1][byArray3[0][n11] & 0xFF ^ this.b2(n7)] & 0xFF ^ this.b2(n)];
                    byte[] byArray5 = byArray3[1];
                    twofishEngine.gSBox[n13 + 513] = this.gMDS3[byArray5[byArray5[n12] & 0xFF ^ this.b3(n7)] & 0xFF ^ this.b3(n)];
                }
                return;
            }
            throw new IllegalArgumentException("Key size larger than 256 bits");
        }
        throw new IllegalArgumentException("Key size less than 64 bits");
    }

    private void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = this.BytesTo32Bits(byArray, n) ^ this.gSubKeys[0];
        n = this.BytesTo32Bits(byArray, n + 4) ^ this.gSubKeys[1];
        int n6 = this.BytesTo32Bits(byArray, n4 + 8) ^ this.gSubKeys[2];
        int n7 = this.BytesTo32Bits(byArray, n3 + 12) ^ this.gSubKeys[3];
        int n8 = 8;
        for (int k = 0; k < 16; k += 2) {
            int n9 = n5;
            int n10 = n6;
            n5 = this.Fe32_0(n5);
            n6 = this.Fe32_3(n);
            int[] nArray = this.gSubKeys;
            int n11 = n10 ^ n5 + n6 + this.gSubKeys[n8++];
            n11 = n11 >>> 1 | n11 << 31;
            int n12 = n6 * 2 + n5;
            int n13 = n8;
            n5 = n13 + 1;
            n7 = (n7 << 1 | n7 >>> 31) ^ n12 + nArray[n13];
            n6 = this.Fe32_0(n11);
            n8 = this.Fe32_3(n7);
            nArray = this.gSubKeys;
            int n14 = n9 ^ n6 + n8 + this.gSubKeys[n5++];
            n14 = n14 >>> 1 | n14 << 31;
            int n15 = n8 * 2 + n6;
            int n16 = n5;
            n8 = n16 + 1;
            n = (n << 1 | n >>> 31) ^ n15 + nArray[n16];
            n5 = n14;
            n6 = n11;
        }
        TwofishEngine twofishEngine = this;
        TwofishEngine twofishEngine2 = this;
        TwofishEngine twofishEngine3 = this;
        twofishEngine3.Bits32ToBytes(n6 ^ this.gSubKeys[4], byArray2, n2);
        twofishEngine2.Bits32ToBytes(n7 ^ twofishEngine3.gSubKeys[5], byArray2, n2 + 4);
        twofishEngine.Bits32ToBytes(n5 ^ twofishEngine2.gSubKeys[6], byArray2, n2 + 8);
        this.Bits32ToBytes(n ^ twofishEngine.gSubKeys[7], byArray2, n2 + 12);
    }

    private void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = this.BytesTo32Bits(byArray, n) ^ this.gSubKeys[4];
        n = this.BytesTo32Bits(byArray, n + 4) ^ this.gSubKeys[5];
        int n6 = this.BytesTo32Bits(byArray, n4 + 8) ^ this.gSubKeys[6];
        int n7 = this.BytesTo32Bits(byArray, n3 + 12) ^ this.gSubKeys[7];
        int n8 = 39;
        for (int k = 0; k < 16; k += 2) {
            int n9 = n;
            TwofishEngine twofishEngine = this;
            int n10 = n7;
            int n11 = n;
            n = this.Fe32_0(n5);
            n7 = this.Fe32_3(n11);
            int[] nArray = this.gSubKeys;
            int n12 = n8;
            n8 = n12 + -1;
            int n13 = n10 ^ n7 * 2 + n + this.gSubKeys[n12];
            int n14 = n + n7;
            int n15 = n8;
            n = n15 + -1;
            n6 = (n6 << 1 | n6 >>> 31) ^ n14 + nArray[n15];
            n7 = n13 >>> 1 | n13 << 31;
            n8 = twofishEngine.Fe32_0(n6);
            int n16 = twofishEngine.Fe32_3(n7);
            int[] nArray2 = this.gSubKeys;
            int n17 = n;
            n = n17 + -1;
            int n18 = n9 ^ n16 * 2 + n8 + this.gSubKeys[n17];
            int n19 = n8 + n16;
            int n20 = n;
            n8 = n20 + -1;
            n5 = (n5 << 1 | n5 >>> 31) ^ n19 + nArray2[n20];
            n = n18 >>> 1 | n18 << 31;
        }
        TwofishEngine twofishEngine = this;
        TwofishEngine twofishEngine2 = this;
        TwofishEngine twofishEngine3 = this;
        twofishEngine3.Bits32ToBytes(n6 ^ this.gSubKeys[0], byArray2, n2);
        twofishEngine2.Bits32ToBytes(n7 ^ twofishEngine3.gSubKeys[1], byArray2, n2 + 4);
        twofishEngine.Bits32ToBytes(n5 ^ twofishEngine2.gSubKeys[2], byArray2, n2 + 8);
        this.Bits32ToBytes(n ^ twofishEngine.gSubKeys[3], byArray2, n2 + 12);
    }

    private int F32(int n, int[] nArray) {
        int n2 = n;
        int n3 = n;
        int n4 = n;
        n = this.b0(n);
        int n5 = this.b1(n4);
        int n6 = this.b2(n3);
        int n7 = this.b3(n2);
        int n8 = nArray[0];
        int n9 = nArray[1];
        int n10 = nArray[2];
        int n11 = nArray[3];
        int n12 = 0;
        switch (this.k64Cnt & 3) {
            default: {
                break;
            }
            case 1: {
                byte[][] byArray = P;
                n12 = this.gMDS0[P[0][n] & 0xFF ^ this.b0(n8)] ^ this.gMDS1[byArray[0][n5] & 0xFF ^ this.b1(n8)] ^ this.gMDS2[byArray[1][n6] & 0xFF ^ this.b2(n8)] ^ this.gMDS3[byArray[1][n7] & 0xFF ^ this.b3(n8)];
                break;
            }
            case 0: {
                n = P[1][n] & 0xFF ^ this.b0(n11);
                n5 = P[0][n5] & 0xFF ^ this.b1(n11);
                n6 = P[0][n6] & 0xFF ^ this.b2(n11);
                n7 = P[1][n7] & 0xFF ^ this.b3(n11);
            }
            case 3: {
                n = P[1][n] & 0xFF ^ this.b0(n10);
                n5 = P[1][n5] & 0xFF ^ this.b1(n10);
                n6 = P[0][n6] & 0xFF ^ this.b2(n10);
                n7 = P[0][n7] & 0xFF ^ this.b3(n10);
            }
            case 2: {
                byte[][] byArray = P;
                byte[] byArray2 = P[0];
                byte[] byArray3 = byArray[1];
                n12 = this.gMDS0[byArray2[byArray2[n] & 0xFF ^ this.b0(n9)] & 0xFF ^ this.b0(n8)] ^ this.gMDS1[byArray[0][byArray[1][n5] & 0xFF ^ this.b1(n9)] & 0xFF ^ this.b1(n8)] ^ this.gMDS2[byArray[1][byArray[0][n6] & 0xFF ^ this.b2(n9)] & 0xFF ^ this.b2(n8)] ^ this.gMDS3[byArray3[byArray3[n7] & 0xFF ^ this.b3(n9)] & 0xFF ^ this.b3(n8)];
            }
        }
        return n12;
    }

    private int RS_MDS_Encode(int n, int n2) {
        for (int k = 0; k < 4; ++k) {
            n2 = this.RS_rem(n2);
        }
        n = n2 ^ n;
        for (n2 = 0; n2 < 4; ++n2) {
            n = this.RS_rem(n);
        }
        return n;
    }

    private int RS_rem(int n) {
        int n2 = n >>> 24 & 0xFF;
        int n3 = n2 << 1;
        int n4 = (n2 & 0x80) != 0 ? 333 : 0;
        int n5 = n2;
        n3 = (n3 ^ n4) & 0xFF;
        n4 = n5 >>> 1;
        int n6 = (n5 & 1) != 0 ? 166 : 0;
        int n7 = n;
        n = n4 ^ n6 ^ n3;
        return n7 << 8 ^ n << 24 ^ n3 << 16 ^ n << 8 ^ n2;
    }

    private int LFSR1(int n) {
        int n2 = n;
        int n3 = n2 >> 1;
        n = (n2 & 1) != 0 ? 180 : 0;
        return n3 ^ n;
    }

    private int LFSR2(int n) {
        int n2 = n;
        int n3 = n2 >> 2;
        int n4 = (n2 & 2) != 0 ? 180 : 0;
        n = (n & 1) != 0 ? 90 : 0;
        return (n3 ^= n4) ^ n;
    }

    private int Mx_X(int n) {
        return n ^ this.LFSR2(n);
    }

    private int Mx_Y(int n) {
        return n ^ this.LFSR1(n) ^ this.LFSR2(n);
    }

    private int b0(int n) {
        return n & 0xFF;
    }

    private int b1(int n) {
        return n >>> 8 & 0xFF;
    }

    private int b2(int n) {
        return n >>> 16 & 0xFF;
    }

    private int b3(int n) {
        return n >>> 24 & 0xFF;
    }

    private int Fe32_0(int n) {
        Object object = ((TwofishEngine)object).gSBox;
        return ((TwofishEngine)object).gSBox[(n & 0xFF) * 2 + 0] ^ object[(n >>> 8 & 0xFF) * 2 + 1] ^ object[(n >>> 16 & 0xFF) * 2 + 512] ^ object[(n >>> 24 & 0xFF) * 2 + 513];
    }

    private int Fe32_3(int n) {
        Object object = ((TwofishEngine)object).gSBox;
        return ((TwofishEngine)object).gSBox[(n >>> 24 & 0xFF) * 2 + 0] ^ object[(n & 0xFF) * 2 + 1] ^ object[(n >>> 8 & 0xFF) * 2 + 512] ^ object[(n >>> 16 & 0xFF) * 2 + 513];
    }

    private int BytesTo32Bits(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private void Bits32ToBytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        int n3 = n2 + 1;
        byArray[n3] = (byte)(n >> 8);
        n3 = n2 + 2;
        byArray[n3] = (byte)(n >> 16);
        n3 = n2 + 3;
        byArray[n3] = (byte)(n >> 24);
    }

    static {
        byte[][] byArrayArray = new byte[2][];
        byte[] byArray = new byte[256];
        byte[] byArray2 = byArray;
        byArray[0] = -87;
        byArray[1] = 103;
        byArray[2] = -77;
        byArray[3] = -24;
        byArray[4] = 4;
        byArray[5] = -3;
        byArray[6] = -93;
        byArray[7] = 118;
        byArray[8] = -102;
        byArray[9] = -110;
        byArray[10] = -128;
        byArray[11] = 120;
        byArray[12] = -28;
        byArray[13] = -35;
        byArray[14] = -47;
        byArray[15] = 56;
        byArray[16] = 13;
        byArray[17] = -58;
        byArray[18] = 53;
        byArray[19] = -104;
        byArray[20] = 24;
        byArray[21] = -9;
        byArray[22] = -20;
        byArray[23] = 108;
        byArray[24] = 67;
        byArray[25] = 117;
        byArray[26] = 55;
        byArray[27] = 38;
        byArray[28] = -6;
        byArray[29] = 19;
        byArray[30] = -108;
        byArray[31] = 72;
        byArray[32] = -14;
        byArray[33] = -48;
        byArray[34] = -117;
        byArray[35] = 48;
        byArray[36] = -124;
        byArray[37] = 84;
        byArray[38] = -33;
        byArray[39] = 35;
        byArray[40] = 25;
        byArray[41] = 91;
        byArray[42] = 61;
        byArray[43] = 89;
        byArray[44] = -13;
        byArray[45] = -82;
        byArray[46] = -94;
        byArray[47] = -126;
        byArray[48] = 99;
        byArray[49] = 1;
        byArray[50] = -125;
        byArray[51] = 46;
        byArray[52] = -39;
        byArray[53] = 81;
        byArray[54] = -101;
        byArray[55] = 124;
        byArray[56] = -90;
        byArray[57] = -21;
        byArray[58] = -91;
        byArray[59] = -66;
        byArray[60] = 22;
        byArray[61] = 12;
        byArray[62] = -29;
        byArray[63] = 97;
        byArray[64] = -64;
        byArray[65] = -116;
        byArray[66] = 58;
        byArray[67] = -11;
        byArray[68] = 115;
        byArray[69] = 44;
        byArray[70] = 37;
        byArray[71] = 11;
        byArray[72] = -69;
        byArray[73] = 78;
        byArray[74] = -119;
        byArray[75] = 107;
        byArray[76] = 83;
        byArray[77] = 106;
        byArray[78] = -76;
        byArray[79] = -15;
        byArray[80] = -31;
        byArray[81] = -26;
        byArray[82] = -67;
        byArray[83] = 69;
        byArray[84] = -30;
        byArray[85] = -12;
        byArray[86] = -74;
        byArray[87] = 102;
        byArray[88] = -52;
        byArray[89] = -107;
        byArray[90] = 3;
        byArray[91] = 86;
        byArray[92] = -44;
        byArray[93] = 28;
        byArray[94] = 30;
        byArray[95] = -41;
        byArray[96] = -5;
        byArray[97] = -61;
        byArray[98] = -114;
        byArray[99] = -75;
        byArray[100] = -23;
        byArray[101] = -49;
        byArray[102] = -65;
        byArray[103] = -70;
        byArray[104] = -22;
        byArray[105] = 119;
        byArray[106] = 57;
        byArray[107] = -81;
        byArray[108] = 51;
        byArray[109] = -55;
        byArray[110] = 98;
        byArray[111] = 113;
        byArray[112] = -127;
        byArray[113] = 121;
        byArray[114] = 9;
        byArray[115] = -83;
        byArray[116] = 36;
        byArray[117] = -51;
        byArray[118] = -7;
        byArray[119] = -40;
        byArray[120] = -27;
        byArray[121] = -59;
        byArray[122] = -71;
        byArray[123] = 77;
        byArray[124] = 68;
        byArray[125] = 8;
        byArray[126] = -122;
        byArray[127] = -25;
        byArray[128] = -95;
        byArray[129] = 29;
        byArray[130] = -86;
        byArray[131] = -19;
        byArray[132] = 6;
        byArray[133] = 112;
        byArray[134] = -78;
        byArray[135] = -46;
        byArray[136] = 65;
        byArray[137] = 123;
        byArray[138] = -96;
        byArray[139] = 17;
        byArray[140] = 49;
        byArray[141] = -62;
        byArray[142] = 39;
        byArray[143] = -112;
        byArray[144] = 32;
        byArray[145] = -10;
        byArray[146] = 96;
        byArray[147] = -1;
        byArray[148] = -106;
        byArray[149] = 92;
        byArray[150] = -79;
        byArray[151] = -85;
        byArray[152] = -98;
        byArray[153] = -100;
        byArray[154] = 82;
        byArray[155] = 27;
        byArray[156] = 95;
        byArray[157] = -109;
        byArray[158] = 10;
        byArray[159] = -17;
        byArray[160] = -111;
        byArray[161] = -123;
        byArray[162] = 73;
        byArray[163] = -18;
        byArray[164] = 45;
        byArray[165] = 79;
        byArray[166] = -113;
        byArray[167] = 59;
        byArray[168] = 71;
        byArray[169] = -121;
        byArray[170] = 109;
        byArray[171] = 70;
        byArray[172] = -42;
        byArray[173] = 62;
        byArray[174] = 105;
        byArray[175] = 100;
        byArray[176] = 42;
        byArray[177] = -50;
        byArray[178] = -53;
        byArray[179] = 47;
        byArray[180] = -4;
        byArray[181] = -105;
        byArray[182] = 5;
        byArray[183] = 122;
        byArray[184] = -84;
        byArray[185] = 127;
        byArray[186] = -43;
        byArray[187] = 26;
        byArray[188] = 75;
        byArray[189] = 14;
        byArray[190] = -89;
        byArray[191] = 90;
        byArray[192] = 40;
        byArray[193] = 20;
        byArray[194] = 63;
        byArray[195] = 41;
        byArray[196] = -120;
        byArray[197] = 60;
        byArray[198] = 76;
        byArray[199] = 2;
        byArray[200] = -72;
        byArray[201] = -38;
        byArray[202] = -80;
        byArray[203] = 23;
        byArray[204] = 85;
        byArray[205] = 31;
        byArray[206] = -118;
        byArray[207] = 125;
        byArray[208] = 87;
        byArray[209] = -57;
        byArray[210] = -115;
        byArray[211] = 116;
        byArray[212] = -73;
        byArray[213] = -60;
        byArray[214] = -97;
        byArray[215] = 114;
        byArray[216] = 126;
        byArray[217] = 21;
        byArray[218] = 34;
        byArray[219] = 18;
        byArray[220] = 88;
        byArray[221] = 7;
        byArray[222] = -103;
        byArray[223] = 52;
        byArray[224] = 110;
        byArray[225] = 80;
        byArray[226] = -34;
        byArray[227] = 104;
        byArray[228] = 101;
        byArray[229] = -68;
        byArray[230] = -37;
        byArray[231] = -8;
        byArray[232] = -56;
        byArray[233] = -88;
        byArray[234] = 43;
        byArray[235] = 64;
        byArray[236] = -36;
        byArray[237] = -2;
        byArray[238] = 50;
        byArray[239] = -92;
        byArray[240] = -54;
        byArray[241] = 16;
        byArray[242] = 33;
        byArray[243] = -16;
        byArray[244] = -45;
        byArray[245] = 93;
        byArray[246] = 15;
        byArray[247] = 0;
        byArray[248] = 111;
        byArray[249] = -99;
        byArray[250] = 54;
        byArray[251] = 66;
        byArray[252] = 74;
        byArray[253] = 94;
        byArray[254] = -63;
        byArray[255] = -32;
        byArrayArray[0] = byArray2;
        byte[] byArray3 = new byte[256];
        byArray2 = byArray3;
        byArray3[0] = 117;
        byArray3[1] = -13;
        byArray3[2] = -58;
        byArray3[3] = -12;
        byArray3[4] = -37;
        byArray3[5] = 123;
        byArray3[6] = -5;
        byArray3[7] = -56;
        byArray3[8] = 74;
        byArray3[9] = -45;
        byArray3[10] = -26;
        byArray3[11] = 107;
        byArray3[12] = 69;
        byArray3[13] = 125;
        byArray3[14] = -24;
        byArray3[15] = 75;
        byArray3[16] = -42;
        byArray3[17] = 50;
        byArray3[18] = -40;
        byArray3[19] = -3;
        byArray3[20] = 55;
        byArray3[21] = 113;
        byArray3[22] = -15;
        byArray3[23] = -31;
        byArray3[24] = 48;
        byArray3[25] = 15;
        byArray3[26] = -8;
        byArray3[27] = 27;
        byArray3[28] = -121;
        byArray3[29] = -6;
        byArray3[30] = 6;
        byArray3[31] = 63;
        byArray3[32] = 94;
        byArray3[33] = -70;
        byArray3[34] = -82;
        byArray3[35] = 91;
        byArray3[36] = -118;
        byArray3[37] = 0;
        byArray3[38] = -68;
        byArray3[39] = -99;
        byArray3[40] = 109;
        byArray3[41] = -63;
        byArray3[42] = -79;
        byArray3[43] = 14;
        byArray3[44] = -128;
        byArray3[45] = 93;
        byArray3[46] = -46;
        byArray3[47] = -43;
        byArray3[48] = -96;
        byArray3[49] = -124;
        byArray3[50] = 7;
        byArray3[51] = 20;
        byArray3[52] = -75;
        byArray3[53] = -112;
        byArray3[54] = 44;
        byArray3[55] = -93;
        byArray3[56] = -78;
        byArray3[57] = 115;
        byArray3[58] = 76;
        byArray3[59] = 84;
        byArray3[60] = -110;
        byArray3[61] = 116;
        byArray3[62] = 54;
        byArray3[63] = 81;
        byArray3[64] = 56;
        byArray3[65] = -80;
        byArray3[66] = -67;
        byArray3[67] = 90;
        byArray3[68] = -4;
        byArray3[69] = 96;
        byArray3[70] = 98;
        byArray3[71] = -106;
        byArray3[72] = 108;
        byArray3[73] = 66;
        byArray3[74] = -9;
        byArray3[75] = 16;
        byArray3[76] = 124;
        byArray3[77] = 40;
        byArray3[78] = 39;
        byArray3[79] = -116;
        byArray3[80] = 19;
        byArray3[81] = -107;
        byArray3[82] = -100;
        byArray3[83] = -57;
        byArray3[84] = 36;
        byArray3[85] = 70;
        byArray3[86] = 59;
        byArray3[87] = 112;
        byArray3[88] = -54;
        byArray3[89] = -29;
        byArray3[90] = -123;
        byArray3[91] = -53;
        byArray3[92] = 17;
        byArray3[93] = -48;
        byArray3[94] = -109;
        byArray3[95] = -72;
        byArray3[96] = -90;
        byArray3[97] = -125;
        byArray3[98] = 32;
        byArray3[99] = -1;
        byArray3[100] = -97;
        byArray3[101] = 119;
        byArray3[102] = -61;
        byArray3[103] = -52;
        byArray3[104] = 3;
        byArray3[105] = 111;
        byArray3[106] = 8;
        byArray3[107] = -65;
        byArray3[108] = 64;
        byArray3[109] = -25;
        byArray3[110] = 43;
        byArray3[111] = -30;
        byArray3[112] = 121;
        byArray3[113] = 12;
        byArray3[114] = -86;
        byArray3[115] = -126;
        byArray3[116] = 65;
        byArray3[117] = 58;
        byArray3[118] = -22;
        byArray3[119] = -71;
        byArray3[120] = -28;
        byArray3[121] = -102;
        byArray3[122] = -92;
        byArray3[123] = -105;
        byArray3[124] = 126;
        byArray3[125] = -38;
        byArray3[126] = 122;
        byArray3[127] = 23;
        byArray3[128] = 102;
        byArray3[129] = -108;
        byArray3[130] = -95;
        byArray3[131] = 29;
        byArray3[132] = 61;
        byArray3[133] = -16;
        byArray3[134] = -34;
        byArray3[135] = -77;
        byArray3[136] = 11;
        byArray3[137] = 114;
        byArray3[138] = -89;
        byArray3[139] = 28;
        byArray3[140] = -17;
        byArray3[141] = -47;
        byArray3[142] = 83;
        byArray3[143] = 62;
        byArray3[144] = -113;
        byArray3[145] = 51;
        byArray3[146] = 38;
        byArray3[147] = 95;
        byArray3[148] = -20;
        byArray3[149] = 118;
        byArray3[150] = 42;
        byArray3[151] = 73;
        byArray3[152] = -127;
        byArray3[153] = -120;
        byArray3[154] = -18;
        byArray3[155] = 33;
        byArray3[156] = -60;
        byArray3[157] = 26;
        byArray3[158] = -21;
        byArray3[159] = -39;
        byArray3[160] = -59;
        byArray3[161] = 57;
        byArray3[162] = -103;
        byArray3[163] = -51;
        byArray3[164] = -83;
        byArray3[165] = 49;
        byArray3[166] = -117;
        byArray3[167] = 1;
        byArray3[168] = 24;
        byArray3[169] = 35;
        byArray3[170] = -35;
        byArray3[171] = 31;
        byArray3[172] = 78;
        byArray3[173] = 45;
        byArray3[174] = -7;
        byArray3[175] = 72;
        byArray3[176] = 79;
        byArray3[177] = -14;
        byArray3[178] = 101;
        byArray3[179] = -114;
        byArray3[180] = 120;
        byArray3[181] = 92;
        byArray3[182] = 88;
        byArray3[183] = 25;
        byArray3[184] = -115;
        byArray3[185] = -27;
        byArray3[186] = -104;
        byArray3[187] = 87;
        byArray3[188] = 103;
        byArray3[189] = 127;
        byArray3[190] = 5;
        byArray3[191] = 100;
        byArray3[192] = -81;
        byArray3[193] = 99;
        byArray3[194] = -74;
        byArray3[195] = -2;
        byArray3[196] = -11;
        byArray3[197] = -73;
        byArray3[198] = 60;
        byArray3[199] = -91;
        byArray3[200] = -50;
        byArray3[201] = -23;
        byArray3[202] = 104;
        byArray3[203] = 68;
        byArray3[204] = -32;
        byArray3[205] = 77;
        byArray3[206] = 67;
        byArray3[207] = 105;
        byArray3[208] = 41;
        byArray3[209] = 46;
        byArray3[210] = -84;
        byArray3[211] = 21;
        byArray3[212] = 89;
        byArray3[213] = -88;
        byArray3[214] = 10;
        byArray3[215] = -98;
        byArray3[216] = 110;
        byArray3[217] = 71;
        byArray3[218] = -33;
        byArray3[219] = 52;
        byArray3[220] = 53;
        byArray3[221] = 106;
        byArray3[222] = -49;
        byArray3[223] = -36;
        byArray3[224] = 34;
        byArray3[225] = -55;
        byArray3[226] = -64;
        byArray3[227] = -101;
        byArray3[228] = -119;
        byArray3[229] = -44;
        byArray3[230] = -19;
        byArray3[231] = -85;
        byArray3[232] = 18;
        byArray3[233] = -94;
        byArray3[234] = 13;
        byArray3[235] = 82;
        byArray3[236] = -69;
        byArray3[237] = 2;
        byArray3[238] = 47;
        byArray3[239] = -87;
        byArray3[240] = -41;
        byArray3[241] = 97;
        byArray3[242] = 30;
        byArray3[243] = -76;
        byArray3[244] = 80;
        byArray3[245] = 4;
        byArray3[246] = -10;
        byArray3[247] = -62;
        byArray3[248] = 22;
        byArray3[249] = 37;
        byArray3[250] = -122;
        byArray3[251] = 86;
        byArray3[252] = 85;
        byArray3[253] = 9;
        byArray3[254] = -66;
        byArray3[255] = -111;
        byArrayArray[1] = byArray2;
        P = byArrayArray;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            TwofishEngine twofishEngine = object;
            ((TwofishEngine)object).encrypting = bl;
            byte[] byArray = ((KeyParameter)cipherParameters).getKey();
            Object object = byArray;
            twofishEngine.workingKey = byArray;
            twofishEngine.k64Cnt = ((Object)object).length / 8;
            twofishEngine.setKey((byte[])object);
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a.a("invalid parameter passed to Twofish init - ")));
    }

    @Override
    public String getAlgorithmName() {
        return "Twofish";
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.workingKey != null) {
            if (n + 16 <= byArray.length) {
                if (n2 + 16 <= byArray2.length) {
                    if (this.encrypting) {
                        this.encryptBlock(byArray, n, byArray2, n2);
                    } else {
                        this.decryptBlock(byArray, n, byArray2, n2);
                    }
                    return 16;
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException("Twofish not initialised");
    }

    @Override
    public void reset() {
        byte[] byArray = this.workingKey;
        if (this.workingKey != null) {
            this.setKey(byArray);
        }
    }

    @Override
    public int getBlockSize() {
        return 16;
    }
}

