/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;

public class XTEAEngine
implements BlockCipher {
    private static final int rounds = 32;
    private static final int block_size = 8;
    private static final int delta = -1640531527;
    private int[] _S = new int[4];
    private int[] _sum0 = new int[32];
    private int[] _sum1 = new int[32];
    private boolean _initialised = false;
    private boolean _forEncryption;

    private void setKey(byte[] byArray) {
        if (byArray.length == 16) {
            int n;
            int n2;
            int n3 = n2 = 0;
            while (n2 < 4) {
                this._S[n2] = this.bytesToInt(byArray, n3);
                ++n2;
                n3 += 4;
            }
            n2 = n = 0;
            while (n < 32) {
                int[] nArray = this._S;
                this._sum0[n] = n2 + this._S[n2 & 3];
                this._sum1[n] = (n2 -= 1640531527) + nArray[n2 >>> 11 & 3];
                ++n;
            }
            return;
        }
        throw new IllegalArgumentException("Key size must be 128 bits.");
    }

    private int encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        XTEAEngine xTEAEngine = this;
        int n3 = xTEAEngine.bytesToInt(byArray, n);
        int n4 = xTEAEngine.bytesToInt(byArray, n + 4);
        for (n = 0; n < 32; ++n) {
            n4 += ((n3 += (n4 << 4 ^ n4 >>> 5) + n4 ^ this._sum0[n]) << 4 ^ n3 >>> 5) + n3 ^ this._sum1[n];
        }
        XTEAEngine xTEAEngine2 = this;
        xTEAEngine2.unpackInt(n3, byArray2, n2);
        int n5 = n2 + 4;
        xTEAEngine2.unpackInt(n4, byArray2, n5);
        return 8;
    }

    private int decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        XTEAEngine xTEAEngine = this;
        int n3 = xTEAEngine.bytesToInt(byArray, n);
        int n4 = xTEAEngine.bytesToInt(byArray, n + 4);
        for (n = 31; n >= 0; --n) {
            n3 -= ((n4 -= (n3 << 4 ^ n3 >>> 5) + n3 ^ this._sum1[n]) << 4 ^ n4 >>> 5) + n4 ^ this._sum0[n];
        }
        XTEAEngine xTEAEngine2 = this;
        xTEAEngine2.unpackInt(n3, byArray2, n2);
        int n5 = n2 + 4;
        xTEAEngine2.unpackInt(n4, byArray2, n5);
        return 8;
    }

    private int bytesToInt(byte[] byArray, int n) {
        int n2 = n;
        int n3 = n2 + 1;
        return byArray[n2] << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3] & 0xFF;
    }

    private void unpackInt(int n, byte[] byArray, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = n;
        int n6 = n2 + 1;
        byArray[n2] = (byte)(n >>> 24);
        n = n6 + 1;
        byArray[n6] = (byte)(n5 >>> 16);
        n6 = n + 1;
        byArray[n] = (byte)(n4 >>> 8);
        byArray[n6] = (byte)n3;
    }

    @Override
    public String getAlgorithmName() {
        return "XTEA";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            XTEAEngine xTEAEngine = this;
            xTEAEngine._forEncryption = bl;
            xTEAEngine._initialised = true;
            this.setKey(((KeyParameter)cipherParameters).getKey());
            return;
        }
        throw new IllegalArgumentException(a.a(cipherParameters, b.a.a("invalid parameter passed to TEA init - ")));
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this._initialised) {
            if (n + 8 <= byArray.length) {
                if (n2 + 8 <= byArray2.length) {
                    return this._forEncryption ? this.encryptBlock(byArray, n, byArray2, n2) : this.decryptBlock(byArray, n, byArray2, n2);
                }
                throw new OutputLengthException("output buffer too short");
            }
            throw new DataLengthException("input buffer too short");
        }
        throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
    }

    @Override
    public void reset() {
    }
}

