/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.examples;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKEParticipant;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKEPrimeOrderGroup;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKEPrimeOrderGroups;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKERound1Payload;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKERound2Payload;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.jpake.JPAKERound3Payload;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA256Digest;
import java.math.BigInteger;
import java.security.SecureRandom;

public class JPAKEExample {
    public static void main(String[] object) {
        JPAKEParticipant jPAKEParticipant;
        JPAKEParticipant jPAKEParticipant2;
        SecureRandom secureRandom;
        SHA256Digest sHA256Digest;
        object = JPAKEPrimeOrderGroups.NIST_3072;
        Object object2 = ((JPAKEPrimeOrderGroup)object).getP();
        Object object3 = ((JPAKEPrimeOrderGroup)object).getQ();
        Object object4 = ((JPAKEPrimeOrderGroup)object).getG();
        System.out.println("********* Initialization **********");
        System.out.println("Public parameters for the cyclic group:");
        System.out.println(a.a("p (").append(((BigInteger)object2).bitLength()).append(" bits): ").append(((BigInteger)object2).toString(16)).toString());
        System.out.println(a.a("q (").append(((BigInteger)object3).bitLength()).append(" bits): ").append(((BigInteger)object3).toString(16)).toString());
        System.out.println(a.a("g (").append(((BigInteger)object2).bitLength()).append(" bits): ").append(((BigInteger)object4).toString(16)).toString());
        System.out.println(a.a("p mod q = ").append(((BigInteger)object2).mod((BigInteger)object3).toString(16)).toString());
        System.out.println(a.a("g^{q} mod p = ").append(((BigInteger)object4).modPow((BigInteger)object3, (BigInteger)object2).toString(16)).toString());
        System.out.println("");
        System.out.println("(Secret passwords used by Alice and Bob: \"" + "password" + "\" and \"" + "password" + "\")\n");
        object2 = sHA256Digest;
        sHA256Digest = new SHA256Digest();
        object3 = secureRandom;
        secureRandom = new SecureRandom();
        object4 = jPAKEParticipant2;
        jPAKEParticipant2 = new JPAKEParticipant("alice", "password".toCharArray(), (JPAKEPrimeOrderGroup)object, (Digest)object2, (SecureRandom)object3);
        JPAKEParticipant jPAKEParticipant3 = jPAKEParticipant;
        Object object5 = object4;
        jPAKEParticipant3("bob", "password".toCharArray(), (JPAKEPrimeOrderGroup)object, (Digest)object2, (SecureRandom)object3);
        object = ((JPAKEParticipant)object4).createRound1PayloadToSend();
        object2 = jPAKEParticipant3.createRound1PayloadToSend();
        System.out.println("************ Round 1 **************");
        System.out.println("Alice sends to Bob: ");
        System.out.println(a.a("g^{x1}=").append(((JPAKERound1Payload)object).getGx1().toString(16)).toString());
        System.out.println(a.a("g^{x2}=").append(((JPAKERound1Payload)object).getGx2().toString(16)).toString());
        System.out.println(a.a("KP{x1}={").append(((JPAKERound1Payload)object).getKnowledgeProofForX1()[0].toString(16)).append("};{").append(((JPAKERound1Payload)object).getKnowledgeProofForX1()[1].toString(16)).append("}").toString());
        System.out.println(a.a("KP{x2}={").append(((JPAKERound1Payload)object).getKnowledgeProofForX2()[0].toString(16)).append("};{").append(((JPAKERound1Payload)object).getKnowledgeProofForX2()[1].toString(16)).append("}").toString());
        System.out.println("");
        System.out.println("Bob sends to Alice: ");
        System.out.println(a.a("g^{x3}=").append(((JPAKERound1Payload)object2).getGx1().toString(16)).toString());
        System.out.println(a.a("g^{x4}=").append(((JPAKERound1Payload)object2).getGx2().toString(16)).toString());
        System.out.println(a.a("KP{x3}={").append(((JPAKERound1Payload)object2).getKnowledgeProofForX1()[0].toString(16)).append("};{").append(((JPAKERound1Payload)object2).getKnowledgeProofForX1()[1].toString(16)).append("}").toString());
        System.out.println(a.a("KP{x4}={").append(((JPAKERound1Payload)object2).getKnowledgeProofForX2()[0].toString(16)).append("};{").append(((JPAKERound1Payload)object2).getKnowledgeProofForX2()[1].toString(16)).append("}").toString());
        System.out.println("");
        ((JPAKEParticipant)object4).validateRound1PayloadReceived((JPAKERound1Payload)object2);
        System.out.println("Alice checks g^{x4}!=1: OK");
        System.out.println("Alice checks KP{x3}: OK");
        System.out.println("Alice checks KP{x4}: OK");
        System.out.println("");
        jPAKEParticipant3.validateRound1PayloadReceived((JPAKERound1Payload)object);
        System.out.println("Bob checks g^{x2}!=1: OK");
        System.out.println("Bob checks KP{x1},: OK");
        System.out.println("Bob checks KP{x2},: OK");
        System.out.println("");
        object = ((JPAKEParticipant)object4).createRound2PayloadToSend();
        object2 = jPAKEParticipant3.createRound2PayloadToSend();
        System.out.println("************ Round 2 **************");
        System.out.println("Alice sends to Bob: ");
        System.out.println(a.a("A=").append(((JPAKERound2Payload)object).getA().toString(16)).toString());
        System.out.println(a.a("KP{x2*s}={").append(((JPAKERound2Payload)object).getKnowledgeProofForX2s()[0].toString(16)).append("},{").append(((JPAKERound2Payload)object).getKnowledgeProofForX2s()[1].toString(16)).append("}").toString());
        System.out.println("");
        System.out.println("Bob sends to Alice");
        System.out.println(a.a("B=").append(((JPAKERound2Payload)object2).getA().toString(16)).toString());
        System.out.println(a.a("KP{x4*s}={").append(((JPAKERound2Payload)object2).getKnowledgeProofForX2s()[0].toString(16)).append("},{").append(((JPAKERound2Payload)object2).getKnowledgeProofForX2s()[1].toString(16)).append("}").toString());
        System.out.println("");
        ((JPAKEParticipant)object4).validateRound2PayloadReceived((JPAKERound2Payload)object2);
        System.out.println("Alice checks KP{x4*s}: OK\n");
        jPAKEParticipant3.validateRound2PayloadReceived((JPAKERound2Payload)object);
        System.out.println("Bob checks KP{x2*s}: OK\n");
        object = ((JPAKEParticipant)object4).calculateKeyingMaterial();
        object2 = jPAKEParticipant3.calculateKeyingMaterial();
        System.out.println("********* After round 2 ***********");
        System.out.println(a.a("Alice computes key material \t K=").append(((BigInteger)object).toString(16)).toString());
        System.out.println(a.a("Bob computes key material \t K=").append(((BigInteger)object2).toString(16)).toString());
        System.out.println();
        JPAKEExample.deriveSessionKey((BigInteger)object);
        JPAKEExample.deriveSessionKey((BigInteger)object2);
        object3 = ((JPAKEParticipant)object4).createRound3PayloadToSend((BigInteger)object);
        object4 = jPAKEParticipant3.createRound3PayloadToSend((BigInteger)object2);
        System.out.println("************ Round 3 **************");
        System.out.println("Alice sends to Bob: ");
        System.out.println(a.a("MacTag=").append(((JPAKERound3Payload)object3).getMacTag().toString(16)).toString());
        System.out.println("");
        System.out.println("Bob sends to Alice: ");
        System.out.println(a.a("MacTag=").append(((JPAKERound3Payload)object4).getMacTag().toString(16)).toString());
        System.out.println("");
        ((JPAKEParticipant)object5).validateRound3PayloadReceived((JPAKERound3Payload)object4, (BigInteger)object);
        System.out.println("Alice checks MacTag: OK\n");
        jPAKEParticipant.validateRound3PayloadReceived((JPAKERound3Payload)object3, (BigInteger)object2);
        System.out.println("Bob checks MacTag: OK\n");
        System.out.println();
        System.out.println("MacTags validated, therefore the keying material matches.");
    }

    private static BigInteger deriveSessionKey(BigInteger object) {
        SHA256Digest sHA256Digest;
        SHA256Digest sHA256Digest2 = sHA256Digest;
        sHA256Digest2();
        byte[] byArray = ((BigInteger)object).toByteArray();
        object = new byte[sHA256Digest2.getDigestSize()];
        sHA256Digest.update(byArray, 0, byArray.length);
        sHA256Digest.doFinal((byte[])object, 0);
        return new BigInteger((byte[])object);
    }
}

