/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.Blake2bDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Argon2Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Longs;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class Argon2BytesGenerator {
    private static final int ARGON2_BLOCK_SIZE = 1024;
    private static final int ARGON2_QWORDS_IN_BLOCK = 128;
    private static final int ARGON2_ADDRESSES_IN_BLOCK = 128;
    private static final int ARGON2_PREHASH_DIGEST_LENGTH = 64;
    private static final int ARGON2_PREHASH_SEED_LENGTH = 72;
    private static final int ARGON2_SYNC_POINTS = 4;
    private static final int MIN_PARALLELISM = 1;
    private static final int MAX_PARALLELISM = 0x1000000;
    private static final int MIN_OUTLEN = 4;
    private static final int MIN_ITERATIONS = 1;
    private static final long M32L = 0xFFFFFFFFL;
    private static final byte[] ZERO_BYTES = new byte[4];
    private Argon2Parameters parameters;
    private Block[] memory;
    private int segmentLength;
    private int laneLength;

    private void reset() {
        if (this.memory != null) {
            int n = 0;
            while (true) {
                Object object = this.memory;
                if (n >= this.memory.length) break;
                if ((object = object[n]) != null) {
                    ((Block)object).clear();
                }
                ++n;
            }
        }
    }

    private void doInit(Argon2Parameters argon2Parameters) {
        int n;
        int n2 = argon2Parameters.getMemory();
        if (n2 < argon2Parameters.getLanes() * 8) {
            n2 = argon2Parameters.getLanes() * 8;
        }
        this.segmentLength = n = n2 / (argon2Parameters.getLanes() * 4);
        this.laneLength = n * 4;
        this.initMemory(argon2Parameters.getLanes() * 4 * n);
    }

    private void initMemory(int n) {
        this.memory = new Block[n];
        n = 0;
        while (true) {
            Block block;
            Object object = this.memory;
            if (n >= this.memory.length) break;
            Block[] blockArray = object;
            object = block;
            block = new Block(null);
            blockArray[n] = object;
            ++n;
        }
    }

    private void fillMemoryBlocks() {
        Position position;
        FillBlock fillBlock;
        FillBlock fillBlock2 = fillBlock;
        fillBlock = new FillBlock(null);
        Position position2 = position;
        position = new Position();
        for (int k = 0; k < this.parameters.getIterations(); ++k) {
            position2.pass = k;
            for (int i2 = 0; i2 < 4; ++i2) {
                position2.slice = i2;
                int n = 0;
                while (n < this.parameters.getLanes()) {
                    position2.lane = n++;
                    this.fillSegment(fillBlock2, position2);
                }
            }
        }
    }

    private void fillSegment(FillBlock fillBlock, Position position) {
        Block block = null;
        Block block2 = null;
        boolean bl = this.isDataIndependentAddressing(position);
        Position position2 = position;
        int n = Argon2BytesGenerator.getStartingIndex(position2);
        int n2 = position2.lane * this.laneLength;
        n2 = position2.slice * this.segmentLength + n2 + n;
        int n3 = this.getPrevOffset(n2);
        if (bl) {
            FillBlock fillBlock2 = fillBlock;
            block = fillBlock2.addressBlock.clear();
            block2 = fillBlock2.inputBlock.clear();
            this.initAddressBlocks(fillBlock2, position, block2, block);
        }
        boolean bl2 = this.isWithXor(position);
        while (n < this.segmentLength) {
            long l = this.getPseudoRandom(fillBlock, n, block, block2, n3, bl);
            int n4 = this.getRefLane(position, l);
            boolean bl3 = n4 == position.lane;
            Argon2BytesGenerator argon2BytesGenerator = this;
            int n5 = argon2BytesGenerator.getRefColumn(position, n, l, bl3);
            Object object = argon2BytesGenerator.memory;
            Block block3 = object[n3];
            Block block4 = object[this.laneLength * n4 + n5];
            object = argon2BytesGenerator.memory[n2];
            if (bl2) {
                fillBlock.fillBlockWithXor(block3, block4, (Block)object);
            } else {
                fillBlock.fillBlock(block3, block4, (Block)object);
            }
            n3 = n2 + 1;
            ++n;
            int n6 = n2;
            n2 = n3;
            n3 = n6;
        }
    }

    private boolean isDataIndependentAddressing(Position position) {
        return this.parameters.getType() == 1 || this.parameters.getType() == 2 && position.pass == 0 && position.slice < 2;
    }

    private void initAddressBlocks(FillBlock fillBlock, Position position, Block block, Block block2) {
        long l;
        Block block3 = block;
        ((Block)block3).v[0] = l = this.intToLong(position.pass);
        ((Block)block3).v[1] = l = this.intToLong(position.lane);
        ((Block)block3).v[2] = l = this.intToLong(position.slice);
        Argon2BytesGenerator argon2BytesGenerator = this;
        ((Block)block3).v[3] = l = argon2BytesGenerator.intToLong(argon2BytesGenerator.memory.length);
        Argon2BytesGenerator argon2BytesGenerator2 = this;
        ((Block)block3).v[4] = l = argon2BytesGenerator2.intToLong(argon2BytesGenerator2.parameters.getIterations());
        Argon2BytesGenerator argon2BytesGenerator3 = this;
        ((Block)block3).v[5] = l = argon2BytesGenerator3.intToLong(argon2BytesGenerator3.parameters.getType());
        if (position.pass == 0 && position.slice == 0) {
            this.nextAddresses(fillBlock, block, block2);
        }
    }

    private boolean isWithXor(Position position) {
        return position.pass != 0 && this.parameters.getVersion() != 16;
    }

    private int getPrevOffset(int n) {
        int n2 = this.laneLength;
        if (n % n2 == 0) {
            return n + n2 - 1;
        }
        return n - 1;
    }

    private static int getStartingIndex(Position position) {
        if (position.pass == 0 && position.slice == 0) {
            return 2;
        }
        return 0;
    }

    private void nextAddresses(FillBlock fillBlock, Block block, Block block2) {
        long l;
        Block block3 = block;
        long[] lArray = block3.v;
        lArray[6] = l = lArray[6] + 1L;
        fillBlock.fillBlock(block3, block2);
        fillBlock.fillBlock(block2, block2);
    }

    private long getPseudoRandom(FillBlock fillBlock, int n, Block block, Block block2, int n2, boolean bl) {
        if (bl) {
            if ((n %= 128) == 0) {
                this.nextAddresses(fillBlock, block2, block);
            }
            return block.v[n];
        }
        return this.memory[n2].v[0];
    }

    private int getRefLane(Position position, long l) {
        int n = (int)((l >>> 32) % (long)this.parameters.getLanes());
        if (position.pass == 0 && position.slice == 0) {
            n = position.lane;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private int getRefColumn(Position position, int n, long l, boolean bl) {
        void var5_12;
        int n2;
        if (position.pass == 0) {
            boolean bl2 = false;
            if (bl) {
                n2 = position.slice * this.segmentLength + n - 1;
            } else {
                n2 = position.slice * this.segmentLength;
                n = n == 0 ? -1 : 0;
                n2 += n;
            }
        } else {
            n2 = this.segmentLength;
            int n3 = this.laneLength;
            int n4 = (position.slice + 1) * n2 % n3;
            if (bl) {
                n2 = n3 - n2 + n - 1;
                int n5 = n4;
            } else {
                n2 = n3 - n2;
                n = n == 0 ? -1 : 0;
                n2 += n;
                int n6 = n4;
            }
        }
        long l2 = l & 0xFFFFFFFFL;
        long l3 = l2 * l2 >>> 32;
        long l4 = (long)(n2 - 1) - ((long)n2 * l3 >>> 32);
        return (int)((long)var5_12 + l4) % this.laneLength;
    }

    private void digest(byte[] byArray, byte[] byArray2, int n, int n2) {
        Block block = this.memory[this.laneLength - 1];
        for (int k = 1; k < this.parameters.getLanes(); ++k) {
            Argon2BytesGenerator argon2BytesGenerator = this;
            int n3 = argon2BytesGenerator.laneLength;
            int n4 = k * n3;
            n4 = n3 - 1 + n4;
            block.xorWith(argon2BytesGenerator.memory[n4]);
        }
        block.toBytes(byArray);
        this.hash(byArray, byArray2, n, n2);
    }

    private void hash(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = n2;
        int n4 = 4;
        byte[] byArray3 = new byte[4];
        Pack.intToLittleEndian(n3, byArray3, 0);
        int n5 = 64;
        if (n3 <= 64) {
            Blake2bDigest blake2bDigest;
            Blake2bDigest blake2bDigest2 = blake2bDigest;
            blake2bDigest2(n2 * 8);
            blake2bDigest2.update(byArray3, 0, n4);
            blake2bDigest2.update(byArray, 0, byArray.length);
            blake2bDigest.doFinal(byArray2, n);
        } else {
            Blake2bDigest blake2bDigest;
            Blake2bDigest blake2bDigest3;
            Blake2bDigest blake2bDigest4 = blake2bDigest3;
            blake2bDigest3 = new Blake2bDigest(512);
            byte[] byArray4 = new byte[n5];
            blake2bDigest4.update(byArray3, 0, n4);
            blake2bDigest4.update(byArray, 0, byArray.length);
            blake2bDigest4.doFinal(byArray4, 0);
            n4 = 32;
            System.arraycopy(byArray4, 0, byArray2, n, n4);
            int n6 = n + n4;
            n = (n2 + 31) / 32 - 2;
            int n7 = 2;
            while (n7 <= n) {
                Blake2bDigest blake2bDigest5 = blake2bDigest4;
                blake2bDigest5.update(byArray4, 0, n5);
                blake2bDigest5.doFinal(byArray4, 0);
                System.arraycopy(byArray4, 0, byArray2, n6, n4);
                ++n7;
                n6 += n4;
            }
            n4 = n2 - n * 32;
            Blake2bDigest blake2bDigest6 = blake2bDigest;
            blake2bDigest6(n4 * 8);
            blake2bDigest6.update(byArray4, 0, n5);
            blake2bDigest.doFinal(byArray2, n6);
        }
    }

    private static void roundFunction(Block block, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        long[] lArray = block.v;
        Argon2BytesGenerator.F(lArray, n, n5, n9, n13);
        Argon2BytesGenerator.F(lArray, n2, n6, n10, n14);
        Argon2BytesGenerator.F(lArray, n3, n7, n11, n15);
        Argon2BytesGenerator.F(lArray, n4, n8, n12, n16);
        Argon2BytesGenerator.F(lArray, n, n6, n11, n16);
        Argon2BytesGenerator.F(lArray, n2, n7, n12, n13);
        Argon2BytesGenerator.F(lArray, n3, n8, n9, n14);
        Argon2BytesGenerator.F(lArray, n4, n5, n10, n15);
    }

    private static void F(long[] lArray, int n, int n2, int n3, int n4) {
        long[] lArray2 = lArray;
        long[] lArray3 = lArray;
        Argon2BytesGenerator.quarterRound(lArray2, n, n2, n4, 32);
        Argon2BytesGenerator.quarterRound(lArray3, n3, n4, n2, 24);
        Argon2BytesGenerator.quarterRound(lArray2, n, n2, n4, 16);
        Argon2BytesGenerator.quarterRound(lArray3, n3, n4, n2, 63);
    }

    private static void quarterRound(long[] lArray, int n, int n2, int n3, int n4) {
        long l = lArray[n];
        long l2 = lArray[n2];
        l = a.a((l & 0xFFFFFFFFL) * 2L, l2 & 0xFFFFFFFFL, l2, l);
        l2 = Longs.rotateRight(lArray[n3] ^ l, n4);
        lArray[n] = l;
        lArray[n3] = l2;
    }

    private void initialize(byte[] byArray, byte[] objectArray, int n) {
        Blake2bDigest blake2bDigest;
        Argon2BytesGenerator argon2BytesGenerator = object;
        Blake2bDigest blake2bDigest2 = blake2bDigest;
        byte[] byArray2 = objectArray;
        blake2bDigest2(512);
        int[] nArray = new int[6];
        objectArray = nArray;
        objectArray[0] = ((Argon2BytesGenerator)object).parameters.getLanes();
        objectArray[1] = n;
        objectArray[2] = ((Argon2BytesGenerator)object).parameters.getMemory();
        objectArray[3] = ((Argon2BytesGenerator)object).parameters.getIterations();
        objectArray[4] = ((Argon2BytesGenerator)object).parameters.getVersion();
        objectArray[5] = ((Argon2BytesGenerator)object).parameters.getType();
        Pack.intToLittleEndian(nArray, byArray, 0);
        blake2bDigest2.update(byArray, 0, 24);
        Argon2BytesGenerator.addByteString(byArray, blake2bDigest2, byArray2);
        Argon2BytesGenerator.addByteString(byArray, blake2bDigest2, ((Argon2BytesGenerator)object).parameters.getSalt());
        Argon2BytesGenerator.addByteString(byArray, blake2bDigest2, ((Argon2BytesGenerator)object).parameters.getSecret());
        Argon2BytesGenerator.addByteString(byArray, blake2bDigest2, ((Argon2BytesGenerator)object).parameters.getAdditional());
        byte[] byArray3 = new byte[72];
        Object object = byArray3;
        blake2bDigest.doFinal(byArray3, 0);
        argon2BytesGenerator.fillFirstBlocks(byArray, (byte[])object);
    }

    private static void addByteString(byte[] byArray, Digest digest, byte[] byArray2) {
        if (byArray2 == null) {
            digest.update(ZERO_BYTES, 0, 4);
            return;
        }
        Pack.intToLittleEndian(byArray2.length, byArray, 0);
        digest.update(byArray, 0, 4);
        digest.update(byArray2, 0, byArray2.length);
    }

    private void fillFirstBlocks(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[72];
        byte[] byArray4 = byArray3;
        System.arraycopy(byArray2, 0, byArray4, 0, 64);
        byArray3[64] = 1;
        for (int k = 0; k < this.parameters.getLanes(); ++k) {
            Argon2BytesGenerator argon2BytesGenerator = this;
            Argon2BytesGenerator argon2BytesGenerator2 = this;
            Pack.intToLittleEndian(k, byArray2, 68);
            Pack.intToLittleEndian(k, byArray4, 68);
            argon2BytesGenerator2.hash(byArray2, byArray, 0, 1024);
            argon2BytesGenerator2.memory[k * this.laneLength + 0].fromBytes(byArray);
            argon2BytesGenerator.hash(byArray4, byArray, 0, 1024);
            argon2BytesGenerator.memory[k * this.laneLength + 1].fromBytes(byArray);
        }
    }

    private long intToLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public void init(Argon2Parameters argon2Parameters) {
        this.parameters = argon2Parameters;
        if (argon2Parameters.getLanes() >= 1) {
            if (argon2Parameters.getLanes() <= 0x1000000) {
                if (argon2Parameters.getMemory() >= argon2Parameters.getLanes() * 2) {
                    if (argon2Parameters.getIterations() >= 1) {
                        this.doInit(argon2Parameters);
                        return;
                    }
                    throw new IllegalStateException("iterations is less than: 1");
                }
                throw new IllegalStateException(b.a.a("memory is less than: ").append(argon2Parameters.getLanes() * 2).append(" expected ").append(argon2Parameters.getLanes() * 2).toString());
            }
            throw new IllegalStateException("lanes must be less than 16777216");
        }
        throw new IllegalStateException("lanes must be greater than 1");
    }

    public int generateBytes(char[] cArray, byte[] byArray) {
        Argon2BytesGenerator argon2BytesGenerator = this;
        return argon2BytesGenerator.generateBytes(argon2BytesGenerator.parameters.getCharToByteConverter().convert(cArray), byArray);
    }

    public int generateBytes(char[] cArray, byte[] byArray, int n, int n2) {
        Argon2BytesGenerator argon2BytesGenerator = this;
        return argon2BytesGenerator.generateBytes(argon2BytesGenerator.parameters.getCharToByteConverter().convert(cArray), byArray, n, n2);
    }

    public int generateBytes(byte[] byArray, byte[] byArray2) {
        int n = byArray2.length;
        return this.generateBytes(byArray, byArray2, 0, n);
    }

    public int generateBytes(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (n2 >= 4) {
            Argon2BytesGenerator argon2BytesGenerator = object;
            byte[] byArray3 = new byte[1024];
            Object object = byArray3;
            argon2BytesGenerator.initialize(byArray3, byArray, n2);
            argon2BytesGenerator.fillMemoryBlocks();
            argon2BytesGenerator.digest((byte[])object, byArray2, n, n2);
            argon2BytesGenerator.reset();
            return n2;
        }
        throw new IllegalStateException("output length less than 4");
    }

    public static class Position {
        public int pass;
        public int lane;
        public int slice;
    }

    public static class Block {
        private static final int SIZE = 128;
        private final long[] v = new long[128];

        private Block() {
        }

        private void copyBlock(Block block) {
            System.arraycopy(block.v, 0, this.v, 0, 128);
        }

        private void xor(Block object, Block object2) {
            Object object3 = ((Block)object3).v;
            object = ((Block)object).v;
            object2 = ((Block)object2).v;
            for (int k = 0; k < 128; ++k) {
                object3[k] = object[k] ^ object2[k];
            }
        }

        private void xorWith(Block object) {
            Object object2 = ((Block)object2).v;
            object = ((Block)object).v;
            for (int k = 0; k < 128; ++k) {
                object2[k] = object2[k] ^ object[k];
            }
        }

        private void xorWith(Block object, Block object2) {
            Object object3 = ((Block)object3).v;
            object = ((Block)object).v;
            object2 = ((Block)object2).v;
            for (int k = 0; k < 128; ++k) {
                object3[k] = object3[k] ^ (object[k] ^ object2[k]);
            }
        }

        public /* synthetic */ Block(1 var1_1) {
            this();
        }

        public void fromBytes(byte[] byArray) {
            if (byArray.length >= 1024) {
                Pack.littleEndianToLong(byArray, 0, this.v);
                return;
            }
            throw new IllegalArgumentException("input shorter than blocksize");
        }

        public void toBytes(byte[] byArray) {
            if (byArray.length >= 1024) {
                Pack.longToLittleEndian(this.v, byArray, 0);
                return;
            }
            throw new IllegalArgumentException("output shorter than blocksize");
        }

        public Block clear() {
            Block block = this;
            Arrays.fill(block.v, 0L);
            return block;
        }
    }

    public static class FillBlock {
        public Block R;
        public Block Z;
        public Block addressBlock;
        public Block inputBlock;

        private FillBlock() {
            Block block;
            Block block2;
            Block block3;
            Block block4;
            Object object = block4;
            block4 = new Block(null);
            v1.R = object;
            object = block3;
            block3 = new Block(null);
            v1.Z = object;
            object = block2;
            block2 = new Block(null);
            v1.addressBlock = object;
            object = block;
            block = new Block(null);
            v1.inputBlock = object;
        }

        private void applyBlake() {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            for (n15 = 0; n15 < 8; ++n15) {
                int n16 = n14 = n15 * 16;
                n13 = n16 + 1;
                n12 = n14 + 3;
                n11 = n14 + 4;
                n10 = n14 + 5;
                n9 = n14 + 6;
                n8 = n14 + 7;
                n7 = n14 + 8;
                n6 = n14 + 9;
                n5 = n14 + 10;
                n4 = n14 + 11;
                n3 = n14 + 12;
                n2 = n14 + 13;
                n = n14 + 14;
                Argon2BytesGenerator.roundFunction(this.Z, n16, n13, n14 + 2, n12, n11, n10, n9, n8, n7, n6, n5, n4, n3, n2, n, n14 += 15);
            }
            for (n15 = 0; n15 < 8; ++n15) {
                int n17 = n14 = n15 * 2;
                n13 = n17 + 1;
                n12 = n14 + 17;
                n11 = n14 + 32;
                n10 = n14 + 33;
                n9 = n14 + 48;
                n8 = n14 + 49;
                n7 = n14 + 64;
                n6 = n14 + 65;
                n5 = n14 + 80;
                n4 = n14 + 81;
                n3 = n14 + 96;
                n2 = n14 + 97;
                n = n14 + 112;
                Argon2BytesGenerator.roundFunction(this.Z, n17, n13, n14 + 16, n12, n11, n10, n9, n8, n7, n6, n5, n4, n3, n2, n, n14 += 113);
            }
        }

        private void fillBlock(Block block, Block block2) {
            FillBlock fillBlock = this;
            fillBlock.Z.copyBlock(block);
            fillBlock.applyBlake();
            block2.xor(block, fillBlock.Z);
        }

        private void fillBlock(Block block, Block block2, Block block3) {
            FillBlock fillBlock = block4;
            fillBlock.R.xor(block, block2);
            fillBlock.Z.copyBlock(((FillBlock)((Object)block4)).R);
            fillBlock.applyBlake();
            Block block4 = fillBlock.R;
            block3.xor(block4, fillBlock.Z);
        }

        private void fillBlockWithXor(Block block, Block block2, Block block3) {
            FillBlock fillBlock = block4;
            fillBlock.R.xor(block, block2);
            fillBlock.Z.copyBlock(((FillBlock)((Object)block4)).R);
            fillBlock.applyBlake();
            Block block4 = fillBlock.R;
            block3.xorWith(block4, fillBlock.Z);
        }

        public /* synthetic */ FillBlock(1 var1_1) {
            this();
        }
    }
}

