/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.MacDerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFFeedbackParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import java.math.BigInteger;

public class KDFFeedbackBytesGenerator
implements MacDerivationFunction {
    private static final BigInteger INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private final Mac prf;
    private final int h;
    private byte[] fixedInputData;
    private int maxSizeExcl;
    private byte[] ios;
    private byte[] iv;
    private boolean useCounter;
    private int generatedBytes;
    private byte[] k;

    public KDFFeedbackBytesGenerator(Mac mac) {
        int n;
        KDFFeedbackBytesGenerator kDFFeedbackBytesGenerator = this;
        this.prf = mac;
        kDFFeedbackBytesGenerator.h = n = mac.getMacSize();
        kDFFeedbackBytesGenerator.k = new byte[n];
    }

    private void generateNext() {
        if (this.generatedBytes == 0) {
            this.prf.update(this.iv, 0, this.iv.length);
        } else {
            this.prf.update(this.k, 0, this.k.length);
        }
        if (this.useCounter) {
            KDFFeedbackBytesGenerator kDFFeedbackBytesGenerator = this;
            int n = kDFFeedbackBytesGenerator.generatedBytes / this.h + 1;
            byte[] byArray = kDFFeedbackBytesGenerator.ios;
            switch (kDFFeedbackBytesGenerator.ios.length) {
                default: {
                    throw new IllegalStateException("Unsupported size of counter i");
                }
                case 4: {
                    byArray[0] = (byte)(n >>> 24);
                }
                case 3: {
                    int n2 = byArray.length - 3;
                    byArray[n2] = (byte)(n >>> 16);
                }
                case 2: {
                    int n2 = byArray.length - 2;
                    byArray[n2] = (byte)(n >>> 8);
                }
                case 1: 
            }
            int n3 = n;
            n = byArray.length - 1;
            byArray[n] = (byte)n3;
            this.prf.update(byArray, 0, byArray.length);
        }
        KDFFeedbackBytesGenerator kDFFeedbackBytesGenerator = this;
        kDFFeedbackBytesGenerator.prf.update(this.fixedInputData, 0, this.fixedInputData.length);
        kDFFeedbackBytesGenerator.prf.doFinal(this.k, 0);
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof KDFFeedbackParameters) {
            derivationParameters = (KDFFeedbackParameters)derivationParameters;
            this.prf.init(new KeyParameter(((KDFFeedbackParameters)derivationParameters).getKI()));
            this.fixedInputData = ((KDFFeedbackParameters)derivationParameters).getFixedInputData();
            int n = ((KDFFeedbackParameters)derivationParameters).getR();
            this.ios = new byte[n / 8];
            if (((KDFFeedbackParameters)derivationParameters).useCounter()) {
                BigInteger bigInteger = TWO.pow(n).multiply(BigInteger.valueOf(this.h));
                int n2 = bigInteger.compareTo(INTEGER_MAX) == 1 ? Integer.MAX_VALUE : bigInteger.intValue();
                this.maxSizeExcl = n2;
            } else {
                this.maxSizeExcl = Integer.MAX_VALUE;
            }
            KDFFeedbackBytesGenerator kDFFeedbackBytesGenerator = this;
            this.iv = ((KDFFeedbackParameters)derivationParameters).getIV();
            kDFFeedbackBytesGenerator.useCounter = ((KDFFeedbackParameters)derivationParameters).useCounter();
            kDFFeedbackBytesGenerator.generatedBytes = 0;
            return;
        }
        throw new IllegalArgumentException("Wrong type of arguments given");
    }

    @Override
    public Mac getMac() {
        return this.prf;
    }

    @Override
    public int generateBytes(byte[] byArray, int n, int n2) {
        int n3 = this.generatedBytes;
        int n4 = n3 + n2;
        if (n4 >= 0 && n4 < this.maxSizeExcl) {
            if (n3 % this.h == 0) {
                this.generateNext();
            }
            int n5 = n;
            KDFFeedbackBytesGenerator kDFFeedbackBytesGenerator = this;
            n3 = kDFFeedbackBytesGenerator.generatedBytes;
            n4 = kDFFeedbackBytesGenerator.h;
            int n6 = n3;
            n3 %= n4;
            n4 = Math.min(n4 - n6 % n4, n2);
            System.arraycopy(kDFFeedbackBytesGenerator.k, n3, byArray, n, n4);
            kDFFeedbackBytesGenerator.generatedBytes += n4;
            n = n2 - n4;
            n3 = n5 + n4;
            while (n > 0) {
                int n7 = n3;
                int n8 = n;
                KDFFeedbackBytesGenerator kDFFeedbackBytesGenerator2 = this;
                kDFFeedbackBytesGenerator2.generateNext();
                n = Math.min(kDFFeedbackBytesGenerator2.h, n);
                System.arraycopy(kDFFeedbackBytesGenerator2.k, 0, byArray, n3, n);
                kDFFeedbackBytesGenerator2.generatedBytes += n;
                n3 = n8 - n;
                n = n7 + n;
                int n9 = n3;
                n3 = n;
                n = n9;
            }
            return n2;
        }
        throw new DataLengthException(b.a(a.a("Current KDFCTR may only be used for "), this.maxSizeExcl, " bytes"));
    }
}

