/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import b.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.NaccacheSternKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.NaccacheSternKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.NaccacheSternPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Vector;

public class NaccacheSternKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static int[] smallPrimes = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557};
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private NaccacheSternKeyGenerationParameters param;

    private static BigInteger generatePrime(int n, int n2, SecureRandom secureRandom) {
        BigInteger bigInteger = BigIntegers.createRandomPrime(n, n2, secureRandom);
        while (bigInteger.bitLength() != n) {
            bigInteger = BigIntegers.createRandomPrime(n, n2, secureRandom);
        }
        return bigInteger;
    }

    private static Vector permuteList(Vector vector, SecureRandom secureRandom) {
        Vector vector2;
        Vector vector3;
        Vector vector4 = vector3;
        vector3 = new Vector();
        Vector vector5 = vector2;
        vector2 = new Vector();
        for (int k = 0; k < vector.size(); ++k) {
            vector5.addElement(vector.elementAt(k));
        }
        vector4.addElement(vector5.elementAt(0));
        vector5.removeElementAt(0);
        while (vector5.size() != 0) {
            vector = vector5.elementAt(0);
            vector4.insertElementAt(vector, NaccacheSternKeyPairGenerator.getInt(secureRandom, vector4.size() + 1));
            vector5.removeElementAt(0);
        }
        return vector4;
    }

    private static int getInt(SecureRandom secureRandom, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = n;
        if ((n5 & -n5) == n) {
            return (int)((long)n * (long)(secureRandom.nextInt() & Integer.MAX_VALUE) >> 31);
        }
        do {
            n3 = secureRandom.nextInt() & Integer.MAX_VALUE;
        } while (n - 1 + (n4 = n3 - (n2 = n3 % n)) < 0);
        return n2;
    }

    private static Vector findFirstPrimes(int n) {
        Vector<BigInteger> vector;
        Vector<BigInteger> vector2 = vector;
        vector = new Vector<BigInteger>(n);
        for (int k = 0; k != n; ++k) {
            vector2.addElement(BigInteger.valueOf(smallPrimes[k]));
        }
        return vector2;
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (NaccacheSternKeyGenerationParameters)keyGenerationParameters;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters;
        NaccacheSternKeyParameters naccacheSternKeyParameters;
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Serializable serializable;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        int n;
        NaccacheSternKeyPairGenerator naccacheSternKeyPairGenerator = vector;
        int n2 = naccacheSternKeyPairGenerator.param.getStrength();
        SecureRandom secureRandom = naccacheSternKeyPairGenerator.param.getRandom();
        int n3 = naccacheSternKeyPairGenerator.param.getCertainty();
        boolean bl = naccacheSternKeyPairGenerator.param.isDebug();
        if (bl) {
            System.out.println(a.a("Fetching first ").append(((NaccacheSternKeyPairGenerator)((Object)vector)).param.getCntSmallPrimes()).append(" primes.").toString());
        }
        Vector vector = NaccacheSternKeyPairGenerator.permuteList(NaccacheSternKeyPairGenerator.findFirstPrimes(((NaccacheSternKeyPairGenerator)((Object)vector)).param.getCntSmallPrimes()), secureRandom);
        BigInteger bigInteger6 = ONE;
        BigInteger bigInteger7 = bigInteger6;
        for (n = 0; n < vector.size() / 2; ++n) {
            bigInteger7 = bigInteger7.multiply((BigInteger)vector.elementAt(n));
        }
        for (n = vector.size() / 2; n < vector.size(); ++n) {
            bigInteger6 = bigInteger6.multiply((BigInteger)vector.elementAt(n));
        }
        BigInteger bigInteger8 = bigInteger7.multiply(bigInteger6);
        int n4 = (n2 - bigInteger8.bitLength() - 48) / 2 + 1;
        BigInteger bigInteger9 = NaccacheSternKeyPairGenerator.generatePrime(n4, n3, secureRandom);
        BigInteger bigInteger10 = NaccacheSternKeyPairGenerator.generatePrime(n4, n3, secureRandom);
        long l = 0L;
        if (bl) {
            System.out.println("generating p and q");
        }
        BigInteger bigInteger11 = bigInteger6;
        bigInteger6 = bigInteger9.multiply(bigInteger7).shiftLeft(1);
        bigInteger7 = bigInteger10.multiply(bigInteger11).shiftLeft(1);
        while (true) {
            ++l;
            bigInteger5 = NaccacheSternKeyPairGenerator.generatePrime(24, n3, secureRandom);
            bigInteger4 = bigInteger5.multiply(bigInteger6).add(ONE);
            if (!bigInteger4.isProbablePrime(n3)) continue;
            while (true) {
                if (bigInteger5.equals(bigInteger3 = NaccacheSternKeyPairGenerator.generatePrime(24, n3, secureRandom))) {
                    continue;
                }
                serializable = ONE;
                bigInteger2 = bigInteger3.multiply(bigInteger7).add((BigInteger)serializable);
                if (bigInteger2.isProbablePrime(n3)) break;
            }
            if (!bigInteger8.gcd(bigInteger5.multiply(bigInteger3)).equals(serializable)) continue;
            if (bigInteger4.multiply(bigInteger2).bitLength() >= n2) break;
            if (!bl) continue;
            System.out.println("key size too small. Should be " + n2 + " but is actually " + bigInteger4.multiply(bigInteger2).bitLength());
        }
        if (bl) {
            System.out.println("needed " + l + " tries to generate p and q.");
        }
        bigInteger6 = bigInteger4.multiply(bigInteger2);
        bigInteger7 = bigInteger4.subtract((BigInteger)serializable).multiply(bigInteger2.subtract((BigInteger)serializable));
        l = 0L;
        if (bl) {
            System.out.println("generating g");
        }
        while (true) {
            int n5;
            Vector vector2;
            serializable = vector2;
            vector2 = new Vector();
            for (int k = 0; k != vector.size(); ++k) {
                BigInteger bigInteger12;
                BigInteger bigInteger13 = bigInteger7.divide((BigInteger)vector.elementAt(k));
                do {
                    ++l;
                } while ((bigInteger12 = BigIntegers.createRandomPrime(n2, n3, secureRandom)).modPow(bigInteger13, bigInteger6).equals(ONE));
                ((Vector)serializable).addElement(bigInteger12);
            }
            bigInteger = ONE;
            for (n5 = 0; n5 < vector.size(); ++n5) {
                bigInteger = bigInteger.multiply(((BigInteger)((Vector)serializable).elementAt(n5)).modPow(bigInteger8.divide((BigInteger)vector.elementAt(n5)), bigInteger6)).mod(bigInteger6);
            }
            boolean bl2 = false;
            for (n5 = 0; n5 < vector.size(); ++n5) {
                if (!bigInteger.modPow(bigInteger7.divide((BigInteger)vector.elementAt(n5)), bigInteger6).equals(ONE)) continue;
                if (bl) {
                    System.out.println(a.a("g has order phi(n)/").append(vector.elementAt(n5)).append("\n g: ").append(bigInteger).toString());
                }
                bl2 = true;
                break;
            }
            if (bl2) continue;
            BigInteger bigInteger14 = ONE;
            if (bigInteger.modPow(bigInteger7.divide(BigInteger.valueOf(4L)), bigInteger6).equals(bigInteger14)) {
                if (!bl) continue;
                System.out.println("g has order phi(n)/4\n g:" + bigInteger);
                continue;
            }
            if (bigInteger.modPow(bigInteger7.divide(bigInteger5), bigInteger6).equals(bigInteger14)) {
                if (!bl) continue;
                System.out.println("g has order phi(n)/p'\n g: " + bigInteger);
                continue;
            }
            if (bigInteger.modPow(bigInteger7.divide(bigInteger3), bigInteger6).equals(bigInteger14)) {
                if (!bl) continue;
                System.out.println("g has order phi(n)/q'\n g: " + bigInteger);
                continue;
            }
            if (bigInteger.modPow(bigInteger7.divide(bigInteger9), bigInteger6).equals(bigInteger14)) {
                if (!bl) continue;
                System.out.println("g has order phi(n)/a\n g: " + bigInteger);
                continue;
            }
            if (!bigInteger.modPow(bigInteger7.divide(bigInteger10), bigInteger6).equals(bigInteger14)) break;
            if (!bl) continue;
            System.out.println("g has order phi(n)/b\n g: " + bigInteger);
        }
        if (bl) {
            System.out.println("needed " + l + " tries to generate g");
            System.out.println();
            System.out.println("found new NaccacheStern cipher variables:");
            System.out.println("smallPrimes: " + vector);
            System.out.println("sigma:...... " + bigInteger8 + " (" + bigInteger8.bitLength() + " bits)");
            System.out.println("a:.......... " + bigInteger9);
            System.out.println("b:.......... " + bigInteger10);
            System.out.println("p':......... " + bigInteger5);
            System.out.println("q':......... " + bigInteger3);
            System.out.println("p:.......... " + bigInteger4);
            System.out.println("q:.......... " + bigInteger2);
            System.out.println("n:.......... " + bigInteger6);
            System.out.println("phi(n):..... " + bigInteger7);
            System.out.println("g:.......... " + bigInteger);
            System.out.println();
        }
        NaccacheSternKeyParameters naccacheSternKeyParameters2 = naccacheSternKeyParameters;
        int n6 = bigInteger8.bitLength();
        naccacheSternKeyParameters = new NaccacheSternKeyParameters(false, bigInteger, bigInteger6, n6);
        NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters2 = naccacheSternPrivateKeyParameters;
        n3 = bigInteger8.bitLength();
        naccacheSternPrivateKeyParameters = new NaccacheSternPrivateKeyParameters(bigInteger, bigInteger6, n3, vector, bigInteger7);
        return new AsymmetricCipherKeyPair(naccacheSternKeyParameters2, naccacheSternPrivateKeyParameters2);
    }
}

