/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.BCrypt;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.util.HashSet;
import java.util.Set;

public class OpenBSDBCrypt {
    private static final byte[] encodingTable;
    private static final byte[] decodingTable;
    private static final String defaultVersion = "2y";
    private static final Set<String> allowedVersions;

    private OpenBSDBCrypt() {
    }

    public static String generate(char[] cArray, byte[] byArray, int n) {
        return OpenBSDBCrypt.generate(defaultVersion, cArray, byArray, n);
    }

    public static String generate(byte[] byArray, byte[] byArray2, int n) {
        return OpenBSDBCrypt.generate(defaultVersion, byArray, byArray2, n);
    }

    public static String generate(String string, char[] cArray, byte[] byArray, int n) {
        if (cArray != null) {
            return OpenBSDBCrypt.doGenerate(string, Strings.toUTF8ByteArray(cArray), byArray, n);
        }
        throw new IllegalArgumentException("Password required.");
    }

    public static String generate(String string, byte[] byArray, byte[] byArray2, int n) {
        if (byArray != null) {
            return OpenBSDBCrypt.doGenerate(string, Arrays.clone(byArray), byArray2, n);
        }
        throw new IllegalArgumentException("Password required.");
    }

    private static String doGenerate(String string, byte[] byArray, byte[] byArray2, int n) {
        if (allowedVersions.contains(string)) {
            if (byArray2 != null) {
                if (byArray2.length == 16) {
                    if (n >= 4 && n <= 31) {
                        int n2 = byArray.length >= 72 ? 72 : byArray.length + 1;
                        byte[] byArray3 = new byte[n2];
                        if (n2 > byArray.length) {
                            n2 = byArray.length;
                            System.arraycopy(byArray, 0, byArray3, 0, n2);
                        } else {
                            System.arraycopy(byArray, 0, byArray3, 0, n2);
                        }
                        Arrays.fill(byArray, (byte)0);
                        String string2 = OpenBSDBCrypt.createBcryptString(string, byArray3, byArray2, n);
                        Arrays.fill(byArray3, (byte)0);
                        return string2;
                    }
                    throw new IllegalArgumentException("Invalid cost factor.");
                }
                throw new DataLengthException(b.a.a("16 byte salt required: ").append(byArray2.length).toString());
            }
            throw new IllegalArgumentException("Salt required.");
        }
        throw new IllegalArgumentException(g.a("Version ", string, " is not accepted by this implementation."));
    }

    public static boolean checkPassword(String string, char[] cArray) {
        if (cArray != null) {
            return OpenBSDBCrypt.doCheckPassword(string, Strings.toUTF8ByteArray(cArray));
        }
        throw new IllegalArgumentException("Missing password.");
    }

    public static boolean checkPassword(String string, byte[] byArray) {
        if (byArray != null) {
            return OpenBSDBCrypt.doCheckPassword(string, Arrays.clone(byArray));
        }
        throw new IllegalArgumentException("Missing password.");
    }

    private static boolean doCheckPassword(String string, byte[] byArray) {
        block11: {
            block12: {
                block15: {
                    int n;
                    String string2;
                    int n2;
                    block14: {
                        block13: {
                            if (string == null) break block11;
                            if (string.charAt(1) != '2') break block12;
                            n2 = string.length();
                            if (n2 != 60 && (n2 != 59 || string.charAt(2) != '$')) {
                                throw new DataLengthException(f.a("Bcrypt String length: ", n2, ", 60 required."));
                            }
                            if (string.charAt(2) != '$') break block13;
                            if (string.charAt(0) != '$' || string.charAt(5) != '$') {
                                throw new IllegalArgumentException("Invalid Bcrypt String format.");
                            }
                            break block14;
                        }
                        if (string.charAt(0) != '$' || string.charAt(3) != '$' || string.charAt(6) != '$') break block15;
                    }
                    if (string.charAt(2) == '$') {
                        string2 = string.substring(1, 2);
                        n = 3;
                    } else {
                        string2 = string.substring(1, 3);
                        n = 4;
                    }
                    if (allowedVersions.contains(string2)) {
                        int n3;
                        block10: {
                            String string3 = string.substring(n, n + 2);
                            try {
                                n3 = Integer.parseInt(string3);
                                if (n3 < 4 || n3 > 31) break block10;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IllegalArgumentException(i.a("Invalid cost factor: ", string3));
                            }
                            int n4 = string.lastIndexOf(36) + 1;
                            String string4 = OpenBSDBCrypt.doGenerate(string2, byArray, OpenBSDBCrypt.decodeSaltString(string.substring(n4, n2 - 31)), n3);
                            boolean bl = n2 == string4.length();
                            for (n3 = 0; n3 != n2; ++n3) {
                                boolean bl2 = string.charAt(n3) == string4.charAt(n3);
                                bl &= bl2;
                            }
                            return bl;
                        }
                        throw new IllegalArgumentException(f.a("Invalid cost factor: ", n3, ", 4 < cost < 31 expected."));
                    }
                    throw new IllegalArgumentException(g.a("Bcrypt version '", string2, "' is not supported by this implementation"));
                }
                throw new IllegalArgumentException("Invalid Bcrypt String format.");
            }
            throw new IllegalArgumentException("not a Bcrypt string");
        }
        throw new IllegalArgumentException("Missing bcryptString.");
    }

    private static String createBcryptString(String string, byte[] byArray, byte[] byArray2, int n) {
        if (allowedVersions.contains(string)) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            new StringBuilder(60).append('$');
            stringBuilder2.append(string);
            stringBuilder2.append('$');
            string = n < 10 ? a.a("0", n) : Integer.toString(n);
            StringBuilder stringBuilder3 = stringBuilder2;
            StringBuilder stringBuilder4 = stringBuilder2;
            stringBuilder4.append(string);
            stringBuilder4.append('$');
            OpenBSDBCrypt.encodeData(stringBuilder2, byArray2);
            OpenBSDBCrypt.encodeData(stringBuilder3, BCrypt.generate(byArray, byArray2, n));
            return stringBuilder3.toString();
        }
        throw new IllegalArgumentException(g.a("Version ", string, " is not accepted by this implementation."));
    }

    private static void encodeData(StringBuilder stringBuilder, byte[] byArray) {
        int n;
        if (byArray.length != 24 && byArray.length != 16) {
            throw new DataLengthException(b.a(b.a.a("Invalid length: "), byArray.length, ", 24 for key or 16 for salt expected"));
        }
        boolean bl = false;
        if (byArray.length == 16) {
            bl = true;
            byArray = new byte[18];
            n = byArray.length;
            System.arraycopy(byArray, 0, byArray, 0, n);
        } else {
            byArray[byArray.length - 1] = 0;
        }
        n = byArray.length;
        for (int k = 0; k < n; k += 3) {
            int n2 = byArray[k] & 0xFF;
            int n3 = byArray[k + 1] & 0xFF;
            int n4 = byArray[k + 2] & 0xFF;
            byte[] byArray2 = encodingTable;
            stringBuilder.append((char)byArray2[n2 >>> 2 & 0x3F]);
            stringBuilder.append((char)byArray2[(n2 << 4 | n3 >>> 4) & 0x3F]);
            stringBuilder.append((char)byArray2[(n3 << 2 | n4 >>> 6) & 0x3F]);
            stringBuilder.append((char)encodingTable[n4 & 0x3F]);
        }
        if (bl) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.setLength(stringBuilder2.length() - 2);
        } else {
            StringBuilder stringBuilder3 = stringBuilder;
            stringBuilder3.setLength(stringBuilder3.length() - 1);
        }
    }

    private static byte[] decodeSaltString(String object) {
        ByteArrayOutputStream byteArrayOutputStream;
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        Object object2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream(16);
        if (cArray.length == 22) {
            Object object3;
            for (int k = 0; k < ((Object)object).length; ++k) {
                object3 = object[k];
                if (object3 <= 122 && object3 >= 46 && (object3 <= 57 || object3 >= 65)) {
                    continue;
                }
                throw new IllegalArgumentException(a.a("Salt string contains invalid character: ", (int)object3));
            }
            Object object4 = object;
            int n = 24;
            char[] cArray2 = new char[24];
            object3 = ((Object)object4).length;
            System.arraycopy(object4, 0, cArray2, 0, (int)object3);
            for (object3 = (Object)false; object3 < n; object3 += 4) {
                byte[] byArray = decodingTable;
                byte by = byArray[cArray2[object3]];
                byte by2 = byArray[cArray2[object3 + true]];
                byte by3 = decodingTable[cArray2[object3 + 2]];
                byte by4 = byArray[cArray2[object3 + 3]];
                ((ByteArrayOutputStream)object2).write(by << 2 | by2 >> 4);
                ((ByteArrayOutputStream)object2).write(by2 << 4 | by3 >> 2);
                ((ByteArrayOutputStream)object2).write(by3 << 6 | by4);
            }
            byte[] byArray = ((ByteArrayOutputStream)object2).toByteArray();
            byte[] byArray2 = new byte[16];
            object2 = byArray2;
            System.arraycopy(byArray, 0, object2, 0, 16);
            return byArray2;
        }
        throw new DataLengthException(b.a(b.a.a("Invalid base64 salt length: "), ((Object)object).length, " , 22 required."));
    }

    static {
        byte[] byArray;
        encodingTable = new byte[]{46, 47, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
        decodingTable = new byte[128];
        allowedVersions = new HashSet<String>();
        allowedVersions.add("2");
        allowedVersions.add("2x");
        allowedVersions.add("2a");
        allowedVersions.add(defaultVersion);
        allowedVersions.add("2b");
        int n = 0;
        while (true) {
            byArray = decodingTable;
            if (n >= decodingTable.length) break;
            byArray[n] = -1;
            ++n;
        }
        n = 0;
        while (true) {
            byArray = encodingTable;
            if (n >= encodingTable.length) break;
            byte by = byArray[n];
            OpenBSDBCrypt.decodingTable[by] = (byte)n;
            ++n;
        }
    }
}

